/*************************************************************************
*
*
*	Name:  erm.c
*
*	Description:  erm() - routine used by the ERM$ p-code. Places
*			the error message coresponding to the error
*			given in a string descriptor.
*		      germ() - works similar to erm(), but places the
*			error message in a buffer.
*
*	History:
*	Date		By	Comments
*
*	03/01/83	WEB
*	04/13/83	WEB	germ no longer treats 0 as special case
*	04/14/83	WEB	changes '/bbsyslib' to '/bb/syslib'
*	06/22/83	mas	changed to use errfd and to try to open it 
*				if errfd == IDLE
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

*/



#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"

extern long lseek();

erm(str, bberrno)
STRDES *str;
long bberrno;
{
   char msg[64];

   germ(msg, bberrno);
   movbd(msg, 64, str);

} /* end-erm */

germ(msg, bberrno)
char *msg;
long bberrno;
{
  register int  n;
   long posn;

   if (errfd == IDLE) {
	   if ((errfd = open(xerrfile, 0)) < 0) {
		   errfd = IDLE;
		   baderr(msg, bberrno);
		   return;
	   }
   }

   posn = ((bberrno >= 0L) ? bberrno : 256L-bberrno) * 64;
   lseek(errfd,posn, 0);
   n = read(errfd, msg, 64);
   if (n < 64)
      baderr(msg, bberrno);

   return;

} /* end-germ */

baderr(str, no)
char *str;
long no;
{
   char sno[16];

   cbdl(sno, no, 0);
   strcpy(str, "Unknown error code: ");
   strcat(str, sno);

} /* end-baderr */
