/*************************************************************************
*
*
*	Name:  kfnds/l, knxts/l, kadds/l & kdels/l
*
*	Description:  ISAM file support
*
*
*	History:
*	Date		By		Comments
*
*	04/04/83        WEB
*	04/27/83        WEB		fixed problem with not positioning
*					the file when NO_LOCK set
*	05/11/83        WEB		fixed problem with nested KNEXTs
*	05/12/83        WEB		rewrote isam.c to keep the numeric
*					data in the buffer string in the
*					same format as it is on disk
*	05/17/83        WEB		added 'register' to improve performance
*	05/23/83        WEB		added -s versions w/ descriptor string
*	06/27/83        WEB		changed 'curkey' to word pointer to
*					maintain compatability 
*	07/07/83        WEB		changed 'keycnt' to remain constant,
*					last key is detected using 'curkey'
*	07/13/83        WEB		fixed problem with KADD allowing a
*					non-positive pointer, fixed problem
*					with KNEXT following KADD/KDEL
*	07/20/83        WEB		fixed problem with core dump when
*					block 0 data is bad
*	08/16/83        WEB		fixed problem with KDEL on an index
*					with duplicate keys allowed
*	08/16/83        WEB		fixed problem with unopened files not
*					reporting the proper error
*	09/12/83        WEB		fixed problem with KADD of KDEL'd key
*					destroying the index
*	02/25/84	JLE		fixed problem with split of block with
*					duplicate keys and incorrect counting
*					of splitcnt. 
*					fixed returned value of curkey in KADD
*	04/05/84	JLE		fixed add of key at end of block
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -


*/
#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/pfunc.h"
#include "/bb/include/bberms.h"
#include "/bb/include/index.h"

extern int errno;
extern long lseek();
char *getiblk();
long isamset(), indx(), addend(), kalloc();

/*
	global data for indexing routines
*/

static int      fd, mode, splitcnt, approx;
static long	inpptr, retptr;
static char	inpkey[133], retkey[133];
static KBUF     *kbptr;
static LFTENT   lfent;
static NUMDES   err;

/* ========================================================================= */

kfndl(lfn, buffer, key, pointer)
int	lfn;
STRDES	buffer;
STRDES	key;
NUMDES	pointer;
{

   if (flftbl(lfn, &lfent) == (LFTENT *) 0)
      bberr(BELSE);			/* verify LFTABL$ and set lfent */
   
   kfind(buffer, key, pointer);

} /* end-kfndl */

/* ========================================================================= */

kfnds(desc, buffer, key, pointer)
STRDES	desc;
STRDES	buffer;
STRDES	key;
NUMDES	pointer;
{
   register int i;
   register char *cptr;

   if (desc.curlth < 8)
      bberr(BESAR);			/* check descriptor string */
   
					/* copy descriptor to lfent */
   for (cptr = (char *) &lfent, i = 0; i < 18; i++)
      *cptr++ = (i < desc.curlth) ? *(desc.data+i) : '\0';

					/* swab the numeric items */
   swab ((char *) &lfent, (char *) &lfent, 8);

   lfent.lfiletype = 'I';		/* make it an index */

   kfind(buffer, key, pointer);

} /* end-kfnds */

/* ========================================================================= */

knxtl(lfn, buffer, key, pointer)
int	lfn;
STRDES	buffer;
STRDES	key;
NUMDES	pointer;
{

   if (flftbl(lfn, &lfent) == (LFTENT *) 0)
      bberr(BELSE);			/* verify LFTABL$ and set lfent */
   
   knext(buffer, key, pointer);

} /* end-knxtl */

/* ========================================================================= */

knxts(desc, buffer, key, pointer)
STRDES	desc;
STRDES	buffer;
STRDES	key;
NUMDES	pointer;
{
   register int i;
   register char *cptr;

   if (desc.curlth < 8)
      bberr(BESAR);			/* check descriptor string */
   
					/* copy descriptor to lfent */
   for (cptr = (char *) &lfent, i = 0; i < 18; i++)
      *cptr++ = (i < desc.curlth) ? *(desc.data+i) : '\0';

					/* swab the numeric items */
   swab ((char *) &lfent, (char *) &lfent, 8);

   lfent.lfiletype = 'I';		/* make it an index */

   knext(buffer, key, pointer);

} /* end-knxts */

/* ========================================================================= */

kaddl(lfn, buffer, key, pointer)
int	lfn;
STRDES	buffer;
STRDES	key;
NUMDES	pointer;
{

   if (flftbl(lfn, &lfent) == (LFTENT *) 0)
      bberr(BELSE);			/* verify LFTABL$ and set lfent */
   
   kadd(buffer, key, pointer);

} /* end-kaddl */

/* ========================================================================= */

kadds(desc, buffer, key, pointer)
STRDES	desc;
STRDES	buffer;
STRDES	key;
NUMDES	pointer;
{
   register int i;
   register char *cptr;

   if (desc.curlth < 8)
      bberr(BESAR);			/* check descriptor string */
   
					/* copy descriptor to lfent */
   for (cptr = (char *) &lfent, i = 0; i < 18; i++)
      *cptr++ = (i < desc.curlth) ? *(desc.data+i) : '\0';

					/* swab the numeric items */
   swab ((char *) &lfent, (char *) &lfent, 8);

   lfent.lfiletype = 'I';		/* make it an index */

   kadd(buffer, key, pointer);

} /* end-kadds */

/* ========================================================================= */

kdell(lfn, buffer, key, pointer)
int	lfn;
STRDES	buffer;
STRDES	key;
NUMDES	pointer;
{

   if (flftbl(lfn, &lfent) == (LFTENT *) 0)
      bberr(BELSE);			/* verify LFTABL$ and set lfent */
   
   kdel(buffer, key, pointer);

} /* end-kdell */

/* ========================================================================= */

kdels(desc, buffer, key, pointer)
STRDES	desc;
STRDES	buffer;
STRDES	key;
NUMDES	pointer;
{
   register int i;
   register char *cptr;

   if (desc.curlth < 8)
      bberr(BESAR);			/* check descriptor string */
   
					/* copy descriptor to lfent */
   for (cptr = (char *) &lfent, i = 0; i < 18; i++)
      *cptr++ = (i < desc.curlth) ? *(desc.data+i) : '\0';

					/* swab the numeric items */
   swab ((char *) &lfent, (char *) &lfent, 8);

   lfent.lfiletype = 'I';		/* make it an index */

   kdel(buffer, key, pointer);

} /* end-kdels */

/* ========================================================================= */

kfind(buffer, key, pointer)
STRDES	buffer;
STRDES	key;
NUMDES	pointer;
{
   long blk;

   mode = KFIND;			/* set operation mode */

					/* set-up & check block 0 */
   blk = isamset(buffer, key, pointer);

   indx(blk);				/* find the key */

   if ((lfent.lflags & LFT_NOLOCK) == FALSE)
      unlks(-1);			/* unlock block zero */

					/* set-up for exit */
   movbdz(retkey, kbptr->b0.keysiz-4, &key);
   updcl(&key);
   putvl(&pointer, retptr*approx);
 
   swab(buffer.data, buffer.data, 36);	/* swab all of the numerics back */

} /* end-kfind */

/* ========================================================================= */

knext(buffer, key, pointer)
STRDES	buffer;
STRDES	key;
NUMDES	pointer;
{
   register char *cptr;
   long blk;

   mode = KNEXT;			/* set operation mode */

					/* set-up */
   blk = isamset(buffer, key, pointer);

   kbptr = (KBUF *) buffer.data;	/* set KBUF pointer */

   swab(buffer.data, buffer.data, 36);	/* swab all of the numerics */

   if ((blk = (long) kbptr->dat.klink) <= 0L)
      bberr(BENDX);			/* error if not at lowest level */

					/* move pointer to next key */
   kbptr->b0.curkey += (kbptr->b0.keysiz >> 1);

					/* see if next key is in this block */
   if (kbptr->b0.curkey<<1 >= kbptr->dat.keycnt*kbptr->b0.keysiz) {
      if (blk == 65535L)		/* no, error if not at lowest level */
	 bberr(BEEOD);
      kbptr->dat.keycnt = 0;		/* zero count to force search */
   }

   while (kbptr->dat.keycnt == 0) {	/* search for non-empty block */

      if (lseek(fd, blk * 512L + lfent.start, 0) < 0)
	 bberr(BENDX);			/* seek to block */

      errno = 29;			/* trump up error in case of EOF */

      if (read(fd, (char *) &kbptr->dat, 512) < 512)
	 bbxerrno();		/* read in block */

				  	/* swab the numeric parts */
      swab((char *) &kbptr->dat, (char *) &kbptr->dat, 4);

      blk = (long) kbptr->dat.klink;

      if (blk == 0L || kbptr->dat.keycnt >= kbptr->b0.keyblk)
	 bberr(BENDX);			/* error if not at lowest level */

      kbptr->b0.curkey = 0;
   }

   cptr = kbptr->dat.kdata + (kbptr->b0.curkey << 1);
  
				    	/* set output pointer */
   swab(cptr+kbptr->b0.keysiz-4, (char *) &retptr, 4);

   if (indexend(cptr) == TRUE)
      retptr = 0L;			/* pointer = 0 if at end of index */

					/* set-up for exit */
   movbdz(cptr, kbptr->b0.keysiz-4, &key);
   updcl(&key);
   putvl(&pointer, retptr);
 
   swab(buffer.data, buffer.data, 36);	/* swab all of the numerics back */

} /* end-knext */

/* ========================================================================= */

kadd(buffer, key, pointer)
STRDES	buffer;
STRDES	key;
NUMDES	pointer;
{
   long blk;

   if (getvl(&pointer) < 0L)
	bberr(BEFAR);			/* pointer must be positive */

   mode = KADD;				/* set operation mode */
					/* set-up & check block 0 */
   blk = isamset(buffer, key, pointer);

   blk = indx(blk);			/* add the key */

   if (blk != 0L) {			/* check for level 0 split */
      fixlevel0(blk);
   }

   if ((lfent.lflags & LFT_NOLOCK) == FALSE)
      unlks(-1);			/* unlock block zero */

   putvl(&pointer, retptr);		/* return pointer */
 
   swab(buffer.data, buffer.data, 36);	/* swab all of the numerics back */

} /* end-kadd */

/* ========================================================================= */

kdel(buffer, key, pointer)
STRDES	buffer;
STRDES	key;
NUMDES	pointer;
{
   long blk;

   mode = KDEL;				/* set operation mode */

					/* set-up & check block 0 */
   blk = isamset(buffer, key, pointer);

   indx(blk);				/* delete the key */

   if ((lfent.lflags & LFT_NOLOCK) == FALSE)
      unlks(-1);			/* unlock block zero */

   putvl(&pointer, retptr);		/* return deleted pointer */

   swab(buffer.data, buffer.data, 36);	/* swab all of the numerics back */

} /* end-kdel */

/* ========================================================================= */

indexend(cptr)
char	 *cptr;
{
   register int i;

   for (i = 0; i < kbptr->b0.keysiz; i++)
      if(*cptr++ != '\377')
         return(FALSE);

   return(TRUE);

} /* end-indexend */

/* ========================================================================= */

fixlevel0(blk)
long	blk;
{
   register char *cptr;
   register int i;
   long nblk;

   nblk = kalloc();			/* get a new index block for level 0 */

   cptr = kbptr->dat.kdata;

   for (i = 0; i < kbptr->b0.keysiz-4; i++)
      *cptr++ = inpkey[i];		/* insert split key and pointer as */
   swab((char *) &inpptr, cptr, 4);	/*    new entry */

   cptr += 4;				/* advance to next key */

   for (i = 0; i < kbptr->b0.keysiz-4; i++)
      *cptr++ = '\377';			/* insert -1 key as second entry */
   swab((char *) &blk, cptr, 4);	/*    with pointer to new block */

   kbptr->dat.keycnt = 2;			/* set count to 2 & link to 0 */
   kbptr->dat.klink = 0;

					/* write new level 0 block */
   putiblk(nblk, (char *) &kbptr->dat);

   kbptr->b0.lv0blk = (unsigned) nblk;	/* update block 0 pointer */
   putblk0();

} /* end-fixlevel0 */

/* ========================================================================= */

long isamset(buffer, key, pointer)
STRDES	buffer;
STRDES	key;
NUMDES	pointer;
{
   register int n;	

   if (buffer.maxlth < 544)
      bberr(BESAR);			/* check buffer size */
   
   if (lfent.lfiletype != 'I')
      bberr(BEIFT);			/* check file type */

   if ((n = xltbchan(lfent.channel, &fd)) < 0)
      bberr(BEFNO);			/* file unopened error */

   switch (mode) {			/* check mode */

      case KFIND:
      case KNEXT:
	 if (n != 0 && n != 2)		/* read or read-write mode */
	    bberr(BEWRM);
	 break;

      case KADD:
      case KDEL:
	 if (n != 2)			/* read-write mode */
	    bberr(BEWRM);
      break;

      default:				/* should never happen ... */
	 bberr(BEWRM);
   
   } /* end-switch */

   lastfileno = lfent.channel;		/* save last accessed file no */

   if (mode == KNEXT)
      return(0L);			/* all done if KNEXT */

   splitcnt = 1;			/* set counter in case level 0 splits */

   err.ndata.j = (int *) 0;		/* dummy error return for locks */

   kbptr = (KBUF *) buffer.data;	/* set KBUF pointer */

					/* set length of buffer */
   for (n = 0; n < 544; n++, buffer.maxlth--)
      *buffer.data++ = '\0';
   updcl(&buffer);

					/* lock & lseek block 0 if locking */
   if ((lfent.lflags & LFT_NOLOCK) == FALSE) {
      locks(-1, fd, lfent.start, 512L, &err);
   } else					/* seek if not locking */
      if (lseek(fd, lfent.start, 0) < 0)
	 bbxerrno();

   valikey = FALSE;			/* disable IKEY now */

   errno = 29;				/* trump up error in case of EOF */

   if (read(fd, (char *) kbptr, 32) < 32)
      bbxerrno();		/* read in block zero */

					/* swab block 0 numerics */
   swab((char *) &kbptr->b0, (char *) &kbptr->b0, 32);

   if ((n = kbptr->b0.keysiz) < 2 || n > 128)
	 bberr(BENDX);			/* validate block 0 data */

					/* move padded key to global area */
   for (n = 0; n < kbptr->b0.keysiz-4; n++)
      inpkey[n] = (n < key.curlth) ? *(key.data+n) : '\0';

   inpptr = getvl(&pointer);		/* move pointer to global area */

   return(kbptr->b0.lv0blk);		/* return level 0 block # */
   
} /* end-isamset */

/* ========================================================================= */

long indx(blk)
long	blk;
{
   char *cptr;
   int match;
   long nblk;

					/* pre-set link */
   kbptr->dat.klink = (unsigned) blk&65535L;

   do {					/* search for the key */
      blk = (long) kbptr->dat.klink;
      cptr = getiblk(blk);
      match = findkey(&cptr);
   } while (kbptr->dat.klink > 0 && kbptr->dat.keycnt == 0 &&
		     (mode == KFIND || mode == KDEL));

   if (kbptr->dat.klink <= 0 && kbptr->dat.keycnt == 0)
      bberr(BENDX);			/* should never happen ... */

					/* save current key location */
   kbptr->b0.curkey = (unsigned) ((cptr - kbptr->dat.kdata) >> 1);

					/* set return pointer */
   swab(cptr+kbptr->b0.keysiz-4, (char *) &retptr, 4);

   switch (mode) {			/* finish up based on mode */

      case KFIND:
	 if (kbptr->dat.klink == 0)	/* lowest level ? */
	    indx(retptr);		/* no, recurse */
	 else
	    fndend(cptr, match);	/* yes, finish up */
	 return(0);

      case KDEL:
	 if (kbptr->dat.klink == 0)	/* lowest level ? */
	    indx(retptr);		/* no, recurse */
	 else
	    delend(cptr, match, blk);	/* yes, finish up */
	 return(0);

      case KADD:
	 if (kbptr->dat.keycnt == (kbptr->b0.keyblk-1))
	    splitcnt++;			/* count it, this block would split */
	 else
	    splitcnt = 0;		/* otherwise clear the counter */

	 if (kbptr->dat.klink == 0)	/* lowest level ? */
	    nblk = indx(retptr);	/* no, recurse */
	 else
	    nblk = -1L;			/* yes, set negative nblk as flag */
	 return(addend(cptr, match, blk, nblk));

      default:				/* should never happen ... */
	 panic();

   } /* end-switch */

} /* end-indx */

/* ========================================================================= */

fndend(cptr, match)
char	*cptr;
int	match;
{
   register int i;

   approx = (match == 0) ? 1 : -1;	/* set approximate key flag */

   if (indexend(cptr) == TRUE)
      retptr = 0L;			/* pointer = 0 if at end of index */

					/* set return key */
   for (i = 0; i < kbptr->b0.keysiz-4; i++)
      retkey[i] = *(cptr+i);

} /* end-fndend */

/* ========================================================================= */

long addend(cptr, match, blk, nblk)
char	*cptr;
int	match;
long	blk, nblk;
{
   register char *s, *d;

   if (nblk == 0L)
      return(0);			/* return 0 not split below */

   else if (nblk > 0L) {
      getiblk(blk);			/* re-read this block */
					/* put in new block's address */
      swab((char *) &nblk, cptr+kbptr->b0.keysiz-4, 4);

   } else {				/* must be on lowest level */
      if ((kbptr->b0.kflags & ALLOW_DUPS) != ALLOW_DUPS && match == 0) {
	 retptr = 0L;			/* return 0 for dup if not allowed */
	 return(0);
      }
      if (splitcnt > (kbptr->b0.lastblk - kbptr->b0.nextblk + 1))
	 bberr(BEIFF);			/* not enough blocks for splits */
      retptr = inpptr;			/* set return pointer also */
   }

   					/* check for overflow */
   if (kbptr->dat.keycnt + 1 > kbptr->b0.keyblk)
      panic();				/* should never happen ... */

					/* move rest of keys up */
   s = kbptr->dat.kdata + kbptr->dat.keycnt * kbptr->b0.keysiz - 1;
   d = s + kbptr->b0.keysiz;
   while (s >= cptr) *d-- = *s--;

					/* insert new key */
   d -= 4;
   s = inpkey;
   while (cptr <= d) *cptr++ = *s++;
		
					/* insert new pointer */
   swab((char *) &inpptr, cptr, 4);

   kbptr->dat.keycnt++;			/* adjust key count in block 0 */

   if (kbptr->dat.keycnt < kbptr->b0.keyblk) {
      putiblk(blk, (char *) &kbptr->dat);
      return(0);
   } else
      return(splitblk(blk));

} /* end-addend */

/* ========================================================================= */

delend(cptr, match, blk)
char	*cptr;
int	match;
long	blk;
{
   register char *s, *e;

   if ((kbptr->b0.kflags & ALLOW_DUPS) != ALLOW_DUPS)
      inpptr = retptr;			/* pointer doesn't matter if no dups */
   else if (inpptr < 0L)
      bberr(BEFAR);			/* error if pointer is negative */

					/* look again if pointers don't match */
   while (match == 0 && retptr != inpptr) {

      cptr += kbptr->b0.keysiz;		/* move on to next key */

				 	/* set current key location */
      kbptr->b0.curkey = (unsigned) ((cptr - kbptr->dat.kdata) >> 1);

					/* get another block if at end */
      if (kbptr->b0.curkey<<1 >= kbptr->dat.keycnt*kbptr->b0.keysiz) {
	 blk = (long) kbptr->dat.klink;
	 cptr = getiblk(blk);
	 kbptr->b0.curkey = (unsigned) ((cptr - kbptr->dat.kdata) >> 1);
      }

      match = bstrncmp(cptr, inpkey, kbptr->b0.keysiz-4);

					/* set return pointer */
      swab(cptr+kbptr->b0.keysiz-4, (char *) &retptr, 4);

   }

   if (match != 0 || retptr != inpptr || indexend(cptr) == TRUE) {
      retptr = 0L;
      return;
   }

					/* move rest of keys down */
   s = cptr + kbptr->b0.keysiz;
   e = kbptr->dat.kdata + (kbptr->dat.keycnt * kbptr->b0.keysiz) - 1;
   while (s <= e) *cptr++ = *s++;

   kbptr->dat.keycnt--;			/* adjust key count in block 0 */

   putiblk(blk, (char *) &kbptr->dat);	/* re-write key block */

} /* end-delend */

/* ========================================================================= */

findkey(cpptr)				/* find closest match in block */
char	**cpptr;
{
   register int f, kcnt;

   kcnt = kbptr->dat.keycnt;		/* set count of keys in block */

   while (kcnt > 0 && (f = bstrncmp(*cpptr, inpkey, kbptr->b0.keysiz-4)) < 0) {
      kcnt--;				/* look until out of keys or match */
      *cpptr += kbptr->b0.keysiz;
   }

   if (kcnt == 0 && mode != KADD)	/* if no match and not KADDing then */
	 kbptr->dat.keycnt = 0;		/*    zero keycnt to force search   */

   return(f);				/* return loop exit condition */

} /* end-findkey */

/* ========================================================================= */

long kalloc()				/* allocate a new block */
{
   long nblk;

   nblk = (long) kbptr->b0.nextblk;	/* get new block number */

   kbptr->b0.nextblk++;			/* increment next-block pointer */

   putblk0();				/* update block 0 */

   return(nblk);

} /* end-kalloc */

/* ========================================================================= */

putblk0()
{
					/* restore block 0 numerics */
   swab((char *) &kbptr->b0, (char *) &kbptr->b0, 32);

   if (lseek(fd, lfent.start, 0) < 0)
      bberr(BENDX);

   if (write(fd, (char *) kbptr, 32) < 32)
      bbxerrno();

					/* swab block 0 numerics again */
   swab((char *) &kbptr->b0, (char *) &kbptr->b0, 32);

} /* end-putblk0 */

/* ========================================================================= */

putiblk(blk, ptr)			/* write key block */
long	blk;
char	*ptr;
{

   swab(ptr, ptr, 4);			/* restore the numeric parts */

   if (lseek(fd, blk * 512L + lfent.start, 0) < 0)
      bberr(BENDX);

   if (write(fd, ptr, 512) < 512)
      bbxerrno();

   swab(ptr, ptr, 4);			/* swab the numeric parts again */

} /* end-putiblk */

/* ========================================================================= */

char *getiblk(blk)			/* read & check an index block */
long	blk;
{
   if (lseek(fd, blk * 512L + lfent.start, 0) < 0)
      bberr(BENDX);			/* seek to block */

   errno = 29;				/* trump up error in case of EOF */

   if (read(fd, (char *) &kbptr->dat, 512) < 512)
      bbxerrno();		/* read in block */

   					/* swab the numeric parts */
   swab((char *) &kbptr->dat, (char *) &kbptr->dat, 4);

   if (kbptr->dat.keycnt >= kbptr->b0.keyblk)
      bberr(BENDX);			/* error if too many keys */

					/* return pointer to the key(s) */
   return(kbptr->dat.kdata);

} /* end-getiblk */

/* ========================================================================= */

splitblk(blk)
long	blk;
{
   register char *cptr;
   register int i;
   int split;
   long nblk;

   split = kbptr->dat.keycnt / 2;		/* determine split point */

   cptr = kbptr->dat.kdata + (split - 1) * kbptr->b0.keysiz;

   for (i = 0; i < kbptr->b0.keysiz; i++)
      inpkey[i] = *cptr++;		/* save split key */

   cptr = kbptr->dat.kdata + split * kbptr->b0.keysiz - 4;
   i = kbptr->dat.keycnt - split;

					/* trump up new key count & link */
   *((unsigned *) cptr) = (unsigned) i;
   *((unsigned *) (cptr+2)) = kbptr->dat.klink;

   nblk = kalloc();			/* get a new index block */

   putiblk(nblk, cptr);			/* write out new block */

   cptr = kbptr->dat.kdata + (split - 1) * kbptr->b0.keysiz;

   for (i = 0; i < kbptr->b0.keysiz; i++)
      *cptr++ = inpkey[i];		/* restore split key */

   cptr = (char *) &kbptr->dat;

					/* update old key count & link */
   kbptr->dat.keycnt = (unsigned) split;
   if (kbptr->dat.klink != 0)		/* leave link 0 for upper levels */
      kbptr->dat.klink = (unsigned) nblk&65535L;

   putiblk(blk, cptr);			/* write back old block */

   inpptr = blk;			/* reset pointer for upper levels */

   return(nblk);

} /* end-splitblk */
