/*************************************************************************
*
*
*	Name:  lftabl.c
*
*	Description:  Support routines dealing with LFTABL$
*
*
*	History:
*	Date		By	Comments
*
*	03/14/83	mas
*	05/24/83	mas	added lfntofd to search through LFTABL$
*				to find the entry for the given filename
*				and set the logical file number, the starting
*				offset in the physical file and returns the
*				file descriptor
*	06/16/83	mas	memory and speed squeeze
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

	flftbl() - returns a pointer to the LFTENT given the logical file no
	lftofd - converts logical file number to XENIX file desc and sets
		 a seek value to the start of the logical file
	lftochan - converts a logical file number to a BASIC channel number

*/


#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/bberms.h"


/* 
	Finds the address of the entry in LFTABL$ given the logical file no
*/

LFTENT *flftbl(logno,lfdup)
int	logno;
LFTENT	*lfdup;	/* this copy will have all the numeric parts swabbed */
{
register LFTENT	*lfptr;
register char	*cptr;
	unsigned u;

	cptr = ((struct GFRAMEA *)GFP)->LFTDES.pdata;
	u = ((struct GFRAMEA *)GFP)->LFTDES.pcurlth;

	lfptr = (LFTENT *)cptr;
	lfptr += (logno-1);

	if ((char *)lfptr >= cptr + u)
		return((LFTENT *)0);

/* copy and swab numeric parts over to local copy */
swab((char *)&(lfptr->channel),(char *)&(lfdup->channel),sizeof(int));
swab((char *)&(lfptr->start),(char *)&(lfdup->start),sizeof(long));
swab((char *)&(lfptr->lflags),(char *)&(lfdup->lflags),sizeof(unsigned));
swab((char *)&(lfptr->lflags),(char *)&(lfdup->lflags),sizeof(unsigned));
swab((char *)&(lfptr->lreclen),(char *)&(lfdup->lreclen),sizeof(unsigned));
swab((char *)&(lfptr->lastrecno),(char *)&(lfdup->lastrecno),sizeof(long));

	strncpy(lfdup->lname,lfptr->lname,10);	/* get log file name */
	lfdup->lfiletype = lfptr->lfiletype;
	lfdup->nextvol = lfptr->nextvol;

	return(lfdup);	/* return pointer to fixed up LFTENT */
}

/* 
	converts logicaL file number to XENIX fd and sets the start of the
	logical file in the physical file 
*/

lftofd(logno,start)
int	logno;
long	*start;
{
	int	fd;
register LFTENT	*lfptr;
	LFTENT	lfdup;

	lfptr = flftbl(logno,&lfdup);	/* get pointer to LFTENT */

	if (lfptr == (LFTENT *)0)
		bberr(BELSE);		/* error in LFTABL$ */

	*start = lfptr->start;	/* set start */

	xltbchan(lfptr->channel,&fd);	/* convert to file desc */

	return(fd);
}

/*
	convert logical file name to logical number, starting offset, and
	file descriptor
*/
lfntofd(lfname,lfno,lfstart)
STRDES	*lfname;
int	*lfno;
long	*lfstart;
{
register LFTENT	*lfptr;
	LFTENT	*lfend,lfdup;
register int	i;
	int	fd;
	char	buf[PATHSIZE];
	unsigned u;

	lfptr = (LFTENT *)((struct GFRAMEA *)GFP)->LFTDES.pdata;
	u = ((struct GFRAMEA *)GFP)->LFTDES.pcurlth;
	(char *)lfend = (char *)lfptr + u;

	movdb(lfname,buf,PATHSIZE);

	for (i = 1;lfptr < lfend; ++lfptr,++i) {
		if (strncmp(lfptr->lname,buf,10) == 0) {
			flftbl(i,&lfdup);
			*lfstart = lfdup.start;
			*lfno = i;
			xltbchan(lfdup.channel,&fd);
			return(fd);
		}
	}
	bberr(BELSE);	/* name not in lftabl$ */
	return(0);
}

	

/*
	converts the logical file number to a BASIC channel number
*/

lftochan(logno)
int	logno;
{
	LFTENT	*lfptr,lfdup;

	lfptr = flftbl(logno,&lfdup);	/* get pointer to entry */

	return(lfptr->channel);	/* return basic channel */
}
