/*************************************************************************
*
*
*	Name:  lopen.c
*
*	Description:  open a logical file & set-up LFTABL$.
*				lopnc()	-
*				lopnb()	-
*
*
*	History:
*	Date		By		Comments
*
*	04/21/83	WEB
*	04/27/83	WEB	fixed a problem with matching an
*					initial sub-name by mistake, fixed
*					a problem with re-using a closed 
*					channel
*	04/29/83	WEB	fixed a problem with pseudo-links
*					not resolving for the .VL & .DB,
*					changed pseudo-links to ".lk"
*	06/16/83	mas	memory and speed squeeze
*	09/16/83	waf	Deleted redundant strcpy() call in resolve().
*	10/10/83	waf	Use ust.ftab[].dev to make ust.ftab[].ino unique across
*					multiple file systems.
*	10/27/83	waf	Use BBCHANS param.
*	10/28/83	waf	Use chanloop() macro.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -


	resolve(link_filename, resolution_filename) traces pseudo-links
		and returns the resolution_filename for the input
		link_filename and an indicator of the result as follows:

		0	resolution_filename is correct (same as
			link_filename if link_filename doesn't exist)

		ERNLE	link_filename exists but is not a pseudo-link

		ERLDE	chain of pseudo-links exceeded maximum depth
			(probably the pseudo-link is linked to itself)



*/

#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/pfunc.h"
#include "/bb/include/bberms.h"
#include "/bb/include/syerms.h"
#include <sys/types.h>
#include <sys/stat.h>

extern int errno;



lopnc (err, lfileno, chan, flags, lfile, type, reclen, lastrec, offset, nxtvol)
NUMDES	err;
int	lfileno, chan;
long	flags;
STRDES	lfile, type;
long	reclen, lastrec, offset;
int	nxtvol;
{
	char lftype[2], lfname[11], tmp[PATHSIZE+1];
	register int  i;

	for (i = 0; i < 11; i++)		/* set up name with null pad */
		lfname[i] = '\0';
	movdb(&lfile, lfname, 10);

	movdb(&type, lftype, 2);		/* copy file type */

	lopn(err, lfileno, chan, flags, lfname, lftype[0], reclen,
	lastrec, offset, nxtvol);

	} /* end-lopnc */

lopnb (err, lfileno, buffer, flags, lfile)
NUMDES	err;
int	lfileno;
STRDES	buffer;
long	flags;
STRDES	lfile;
{
	register char *lfp;
	int  i;
	register char   *tp;
	char	pfile[PATHSIZE+1], lftype, lfname[11], tmp[PATHSIZE+1];
	int	  j, k, fd, found, chan, nxtvol;
	long   mode, reclen, offset, lastrec;
	unsigned sector;
	struct stat stats;
	STRDES bfile;

	if (buffer.maxlth < 512) {
		errchk(&err, BEFAR); 
		return;	/* check buffer space */
		}

	for (i = 0; i < 11; i++)		/* set up name with null pad */
		lfname[i] = '\0';
	movdb(&lfile, lfname, 10);

	if ((i = resolve(lfname, pfile)) != 0) {
		errchk(&err, i); 
		return;		/* resolve logical file link */
		}

	if (strcmp(lfname, pfile) == 0) {
		errchk(&err, ERDLE); 
		return;	/* error if it didn't link somewhere */
		}

	i = strlen(pfile) - 3;		/* error if pfile not end in '.VL' */
	if (bstrncmp((pfile+i), ".VL", 3) != 0) {
		errchk(&err, BENDF); 
		return;
		}

	resolve(pfile, tmp);			/* resolve pseudo-links */

	if ((fd = open(tmp, 0)) < 0) {	/* open the volume-label file */
		errxechk( &err );
		return;
		}

	forever {
		if (read(fd, buffer.data, 512) != 512) {
			close(fd);			/* no such logical file if get eof */
			errchk(&err, BELFN);
			return;
			}
		/* look for the logical file */
		found = FALSE;
		for (lfp = buffer.data, i = 0; i < 512; i += 32, lfp += 32)
			if (bstrncmp(lfp, lfname, 10) == 0) {
				found = TRUE;
				break;
				}
		if (found == TRUE)		/* done once it's found */
			break;
		} /* end-forever */

	close(fd);				/* found it, close the volume-label */

	i = strlen(pfile) - 2;		/* change .VL to .DB */
	strcpy((pfile+i), "DB");

	resolve(pfile, tmp);			/* resolve pseudo-links */

	if (stat(tmp, &stats) < 0) {		/* get stats on data-base file */
		errchk(&err, ERDLE); 
		return;	/* error if no such file */
		}

	chan = -1;

	/* see if data base is already open */
	chanloop( i ) {
		if ( i == 16 )
			continue ;		/* skip console */
		if ( ust.ftab[i].xfd != IDLE && ust.ftab[i].ino == stats.st_ino
				&& ust.ftab[i].dev == stats.st_dev )
			chan = i;
		}

	if (chan < 0) {			/* not open, open it now */
		/* find an idle channel */
		chanloop( i ) {
			if ( i == 16 )
				continue ;		/* skip console */
			if (ust.ftab[i].xfd == IDLE) {
				chan = i;
				break;
				}
			}
		if (chan < 0) {			/* error if no idle channel */
			errchk(&err, BENAC); 
			return;
			}
		bfile.data = pfile;		/* put together a STRDES for file */
		bfile.curlth = strlen(pfile);
		bfile.maxlth = bfile.curlth;
		mode = ((flags & (long) LFT_EOPEN) == (long) LFT_EOPEN) ? 6L : 5L;
		bopen(err, chan, mode, bfile);	/* open the data-base file */
		if (isvar(&err) != FALSE && getvj(&err) != 0)
			return;			/* exit if an error occurred in open */
		}

	/* extract logical file entry */
	swab((lfp+10), (char *) &sector, 2);
	offset = (long) sector * 512L;	/* convert starting sector to byte */
	swab((lfp+12), (char *) &i, 2);
	reclen = (long) i;
	lftype = *(lfp+14);
	tp = (char *) &lastrec;		/* special for 3-byte lastrec */
	for (i = 0, j = 3, k = 15; i <= 3; i++, j--)
		*(tp+i) = (j < 3) ? *(lfp+(k++)) : '\0';
	swab(tp, tp, 4);
	nxtvol = 0;

	lopn(err, lfileno, chan, flags, lfname, lftype, reclen,
	lastrec, offset, nxtvol);

	} /* end-lopnc */

lopn (err, lfileno, chan, flags, lfile, type, reclen, lastrec, offset, nxtvol)
NUMDES	err;
int	lfileno, chan;
long	flags;
char 	*lfile, type;
long	reclen, lastrec, offset;
int	nxtvol;
{
	struct GFRAMEA *gfptr;
	register char   *lftabl, lftype;
	int	  lflen, i, ireclen;

	gfptr = (struct GFRAMEA *) GFP;		/* set pointers, etc. */
	lftabl = (char *) ((LFTENT *) (gfptr->LFTDES.pdata) + lfileno - 1);
	lftype = type - ((type >= 'a' && type <= 'z') ? 32 : 0);
	lflen = strlen(lfile);
	ireclen = (int) reclen;
	/* check for errors */
	if (lfileno <= 0) {
		errchk(&err, BEIFN); 
		return;		/* file number out of range */
		}

	if (lfileno*26 > gfptr->LFTDES.pcurlth) {
		errchk(&err, BELSE); 
		return;		/* LFTABL$ too small */
		}

	if (*(lftabl+24) != '\0') {
		errchk(&err, BEFAO); 
		return;		/* LFTABL$ entry in use */
		}

	if (lftype != 'D' && lftype != 'L' && lftype != 'I') {
		errchk(&err, BEIFT); 
		return;		/* invalid logical file type */
		}

	if (reclen < 0L || reclen > 65535L) {
		errchk(&err, BEIRL); 
		return;		/* invalid record length */
		}

	if (flags < 0L || flags > 65535L) {
		errchk(&err, BEFAR); 
		return;		/* invalid flags value */
		}

	swab((char *) &chan, lftabl, 2);		/* set-up LFTABL$ */
	swab((char *) &offset, lftabl+2, 4);
	i = (int) flags;
	swab((char *) &i, lftabl+6, 2);
	for (i = 0; i < 10; i++)
		*(lftabl+8+i) = lfile[i];
	swab((char *) &ireclen, lftabl+18, 2);
	swab((char *) &lastrec, lftabl+20, 4);
	*(lftabl+24) = lftype;
	*(lftabl+25) = (char) nxtvol&255;

	errchk(&err, NOERR);				/* return no-error */

	} /* end-lopn */

resolve (linknam, reslnam)
char	*linknam, *reslnam;
{
	register int depth,i;
	int  n, fd;
	char	tmp[PATHSIZE+1];

	strcpy(reslnam, linknam);		/* assume its not a link */

	/* trace links */
	for (depth = MAXDEPTH; depth > 0; depth--) {
		strcpy(tmp, reslnam);
		strcat(tmp, ".lk");

		if ((fd = open(tmp, 0)) < 0)	/* try to open the pseudo-link */
			return(0);			/* done if can't open it */

		/* read contents as resolution name */
		if ((n = read(fd, reslnam, PATHSIZE+1)) <= 0) {
			close(fd);
			return(ERNLE);			/* not a link if nothing there */
			}

		for (i = 0; i < n; i++)		/* find the terminator */
			if (reslnam[i] == '\n' || reslnam[i] == '\r' ||
			    reslnam[i] == '\f' ||
			    reslnam[i] == '\0') {
				reslnam[i] = '\0';		/* set terminator to null */
				break;
				}

		/* strcpy(tmp, reslnam);		<* waf 9/16 */

		close(fd);			/* close it and repeat */
		}

	return(ERLDE);			/* error if too many levels */

	} /* end-resolve */
