/*************************************************************************
*
*
*	Name:  pexit.c
*
*	Description:  Exits pmachine
*
*
*	History:
*	Date		By	Comments
*
*	03/15/83	mas
*	04/14/83	WEB	changes '/bbsyslib' to '/bb/syslib'
*	04/24/83	mas	changed to close all user channels to
*				avoid error loop if all fd's used
*	05/09/83	mas	added call for p-code histogram dump
*	06/24/83	mas	changed to use numfd
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -
	resets terminal characteristics
	resets job number in basic.no
	exits to xenix with status
		0 = normal exit
		-1= error exit

*/


#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include <signal.h>

#include "/bb/include/pcondcomp.h"

extern	int	errno;
extern long lseek();

pexit(status)
int	status;
{
register int	fd;
	struct	specialno numrec;

	bclose(16);			/* close all user channels */

	signal(SIGINT,SIG_IGN);		/* ignore ints till done */
	signal(SIGQUIT,SIG_IGN);
	signal(SIGHUP,SIG_IGN);
	signal(SIGTERM,SIG_IGN);

	GFP->ERRVEC.B = (char *)-1;	/* can't capture errors either */

	if (numfd == IDLE)
		fd = open(xnumfile,2);
	else
		fd = numfd;

	lseek(fd,0L,0);
	read(fd,&numrec,sizeof(numrec));
	lseek(fd,0L,0);  /* position for write */
	numrec.jobno[ust.pjobno] = IDLE;
	write(fd,&numrec,sizeof(numrec));

	close(fd);

#ifdef PHIST
	phdump();			/* do pcode histogram dump */
#endif

	termflush();
	termreset();

	exit(status);
}
