/*************************************************************************
*
*
*	Name:  stma15.c
*
*	Description:  STMA 15  statement.
*
*
*	History:
*	Date		By		Comments
*
*	4/11/83		waf
*	5/12/83		waf		'endptr' comparison fix ( s15getc() ).
*	6/24/83 	mas		changed to use registers where possible
*	10/25/83	waf		Made s15getc() a static fn.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -


.SH */
#include	"/bb/include/ptype.h"


/** global vars **/
static	char	*strptr[3];		/* ptr to str1 & str2 */
static	char	*endptr[3];		/* end of str1 & str2 */


stma15 ( str1, str2, numvar )

STRDES	str1, str2 ;
NUMDES	numvar ;
{

	/** get ptrs **/
	strptr[1] = str1.data ;
	strptr[2] = str2.data ;
	endptr[1] = strptr[1] + str1.curlth ;
	endptr[2] = strptr[2] + str2.curlth ;
	putvj( &numvar, s15match() );		/* return flag in numvar */
	}


/** flag vals returned by match **/
#define	MATCH	1
#define	NOMATCH	0

s15match ()
{
	char	c1,c2;
	register char	*optr1, *optr2;
	int	x;

	forever {		/* while chars in str1 and str2 match */

		/** get next char from str1 **/
		if ( s15getc(&c1, 1) == -1 ) {

			/** end of str1 **/
			if ( s15getc(&c2, 2) == -1 )
				return( MATCH );		/* str2 was at end also */
			else
				return( NOMATCH );	/* str2 was not at end */
			}

		if ( c1 == '-' ) {

			/** '-' in str1 **/
			forever {		/* until match found or str2 exausted */

				/** call match, starting at each char remaining in $2 **/
				optr1 = strptr[1];  
				optr2 = strptr[2];		/* save current ptrs */
				x = s15match();		/* recurse */

				/* restore old ptrs */
				strptr[1] = optr1 ;  
				strptr[2] = optr2 ;	/* restore ptrs */

				/* chk for match */
				if ( x == MATCH )
					break;		/* match found */

				/* No match. If $2 not empty, start at next char in $2 */
				if ( s15getc(&c2, 2) == -1 )
					break ;		/* end of $ 2 */

				}		/* loop */

			return( x );		/* return match flag */
			}

		else {

			/** get next char from str2 **/
			if ( s15getc(&c2, 2) == -1 )
				return( NOMATCH );		/* end of $2 */

			/** compare chars **/
			if ( c1 == '*' )  continue ;		/* '*' always matches */
			if ( c1 != c2 )
				return( NOMATCH );		/* chars don't match */
			}
		}
	}


static	s15getc ( c, n )

/* Get next char from str n.
	Return -1 if end of $ */

char	*c;		/* return char */
int	n;
{

	if ( strptr[n] >= endptr[n] ) {
		*c = '\0' ;
		return( -1 );
		}
	else {
		*c = *(strptr[n]++);
		return( 0 );
		}
	}
