/*************************************************************************
*
*
*	Name:  termout.c
*
*	Description:  Terminal (I/O buffer) output functions.
*				Termout() - writes iobuf to termbuf
*		      	Termflush() - writes termbuf to terminal or file
*
*
*	History:
*	Date		By	Comments
*
*	03/10/83	mas
*	04/12/83	mas	fixed problem of IKEY during write.
*				the IKEY caused the write to abort 
*				prematurely and the compare was for the
*				number requested to be written. This was
*				changed to be a compare for a negative value.
*	05/09/83	mas	changed to work like RDOS in that transfers
*				to the terminal stop on a null, and to a file
*				stop on a null, cr, lf, or nl.
*	05/16/83	mas	cleaned up unused automatics and added
*				register variables where possible
*	08/24/83	waf		termflush() - Check for Ikey during write().
*	02/21/84	waf		New ioerr() functionality - must handle return.
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

  See ioerr() in bberr.c for a discussion of ikey's during char i/o.
Note that, if i/o from or to a char device is ikey'ed, the results of the i/o
are undefined. In particular, output may be truncated.

  NOTE that output to stdout is differentiated from output to a 'file' (where
a file can be a block or character device).
  If output is to the stdout, ALL ERRORS ARE IGNORED (including EINTR).


Modification Notes -

02/22/84	waf
  All errors (including EINTR) while writing to stdout are INGORED. (Errors
while writing to a 'file' are processed).

*/


#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"

termout ()
{
	register int	i;
	register char	c;

	if (iostat.iocount == 0)
		return;

	for (i = 0 ; i < iostat.iocount ; i++ ) {
		c = iobuf[i];
		if (iostat.ofd == 1 && c == '\0')
			break;
		termput(c);	/* output character */
		if (iostat.ofd != 1 && (c=='\0'||c=='\n'||c=='\r'||c=='\f') )
			break;
		}

	iostat.iocount = 0;
	}


termput (c)

/* put one character into terminal buffer */

char	c;
{

	termbuf[termcount] = c;
	if (++termcount >= TERMSIZE)
		termflush();
	return;
	}

termflush ()

/* write terminal buffer to output file in iostat */

{


	if (termcount == 0)
		return;

	if (write(iostat.ofd,termbuf,termcount) < 0) {

		/* error during write */
		if ( iostat.ofd != 1 ) {	/* IGNORE errors from stdout */
			ioerr() ;		/* report error / chk for EINTR */
			;				/** Ignore EINTR **/
			}
		}

	termcount = 0;
	return;
	}
