/*************************************************************************
*
*
*	Name:  wline.c
*
*	Description:  writes line to io buffer
*
*
*	History:
*	Date		By	Comments
*
*	05/12/83	mas	added routine to convert pc value
*				into line+offset and changed call
*				to wline to use pc value
*	06/07/83	mas	fixed bug where the buffer for the line
*				number was not being init'ed right
*				if the line number was 5 digits long
*	6/27/83		mas	added registers where possible
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

*/


extern long	pctoline();

wline(pc)
char	*pc;
{
	char	nbuf[32];

	cnvlin(pc,nbuf);
	iocpy(nbuf,strlen(nbuf));
	termout();

	return;
}

cnvlin(pc,buf)
char	*pc,*buf;
{
	int	i;
	long	l,line;
	register unsigned offset,*uptr;
	char	nbuf[32];

	line = pctoline(pc,1);		/* convert to line + offset */

	uptr = (unsigned *)&line;

	offset = *uptr;
	l = *(uptr+1);

	cbdl(nbuf,l,0);

	i = strlen(nbuf);

	*buf = '\0';			/* set up for strcat */

	if (i < 5) {
		strcpy(buf,"0000");
		buf[4-i] = '\0';
	}

	strcat(buf,nbuf);

	if (offset != 0) {
		strcat(buf,"+");
		cbdl(nbuf,(long)offset,0);
		strcat(buf,nbuf);
	}

	return;
}
