:! GETCM - Reads fields and switches from common area generated by CLI
:#
:     INITCM reads the common area into T9$ and set Q9 to point
:     to the first argument (Command name and global switches).
:     Each GETCM returns the next argument in X$ and switches in
:     S.  S is returned as -1 after all arguments have been read.
:     This routine will also parse COM.CM generated by RDOS CLI.
:     T9$ and Q9 must be preserved between calls to GETCM.
:> CALLING SEQUENCE
:     GOSUB 7500 : READ NEXT COMMAND ARGUMENT
:     X$ - CONTAINS FIELD READ
:     S  - SWITCHES FOR THIS FIELD (=-1 IF END OF COMMAND LINE)
:$ STORAGE USED
:     T9$ - 512 BYTE STRING FOR HOLDING COMMON (PERMANANT)
:     Q9 - POINTER INTO T9$ (PERMANANT)
::
7500 REM \ GETCM 
7505 IF T9$[Q9,Q9]="<255>" THEN GOTO 7540    :END OF COMMAND LINE?
7510 LET X$=TRUN$(T9$[Q9])                   :READ UP TO NEXT NULL
7512 IF X$="" THEN GOTO 7540                 :ALSO END OF COM.CM
7515 LET Q9=Q9+LEN(X$)                       :POINT TO SWITCHES
7520 IF Q9>508 THEN STOP                     :END OF COMMON AREA???
7525 UNPACK "L",T9$[Q9+1],S                  :SET SWITCHES
7530 LET Q9=Q9+5                             :POINT TO NEXT FIELD
7535 RETURN                                  :THAT'S ALL
7540 LET S=-1                                :END OF COMMAND LINE...SET FLAG
7545 RETURN 
:
:! INITCM - Initialize variables for GETCM by reading common
:#
:     INITCM initialize T9$ and Q9 for GETCM.
:> CALLING SEQUENCE
:     GOSUB 7550
::
7550 REM \ INITCM
7552 LET Q9=1                                :RESET BYTE POINTER
7555 BLOCK READ T9$                          :READ COMMON AREA
7560 RETURN                                  
7599 REM * END GETCM.SL 10/25/77
