: !P_SHELL.SR
:
:
: SUBROUTINE FOR SORTING AN ARRAY `A' OR STRING `A$' IN CORE.
: STATEMENT SUBSTITUTIONS ARE GIVEN TO ALLOW THE ROUTINE TO SORT
: A SINGLE DIMENSION ARRAY, A[R]; A TWO DIMENSION ARRAY, A[R,C];
: AND A STRING, A$[R*C] WHERE A$ CONSISTS OF `R' SUBSTRINGS `C'
: CHARACTERS IN LENGTH. FOR A[R,C] ONLY THE FIRST `K' ELEMENTS
: OF THE SECOND DIMENSION ARE COMPARED TO CHECK SEQUENCE, BUT ALL
: `C' ELEMENTS ARE SWAPPED ON AN OUT-OF-SEQUENCE CONDITION.
: FOR A$[R*C] ONLY THE FIRST `K' CHARACTERS OF THE `C' CHARACTER
: SUBSTRING ARE COMPARED TO CHECK SEQUENCE, BUT ALL `C' CHARACTERS
: ARE SWAPPED ON AN OUT-OF-SEQUENCE CONDITION.
:
:   1 A   ARRAY TO BE SORTED (A$) FOR STRING SORT
:   2 B9  POINTER
:   3 C   NUMBER OF ELEMENTS (CHARACTERS) TO BE TREATED AS A RECORD
:   4 F9  LOGIC CONTROL; COUNT # OF SWAPS
:   5 I8  POINTER
:   6 I9  POINTER
:   7 K   NUMBER OF ELEMENTS (CHARACTERS) TO BE COMPARED AS A KEY
:   8 K9  SEGMENT SIZE
:   9 L8  LOWEST ELEMENT OF SEGMENT
:  10 L9  HIGHEST ELEMENT OF SEGMENT
:  11 P8  LAST SEGMENT SORTED THIS PASS
:  12 P9  POINTER
:  13 R   NUMBER OF RECORDS (GROUPS OF `C' ELEMENTS) TO BE SORTED
:  14 R9  TEMPORARY SEGMENT POINTER
:  16 S9  SEGMENT SIZE
:  17 T8  TEMPORARY
:  18 T9  POINTER TO UPPER ELEMENT BEING COMPARED
:
9000 REM SORT SUBROUTINE USING SHELL/ASM ALGORITHM - REV 0.01 (01/27/75)
9001 LET K9=2
9002 LET P9=1
9003 LET L9=R
9004 LET L8=0
9005 LET S9=R/K9
9006 LET F9=0
9007 LET P8=L9-S9
9008 IF S9>1 THEN LET K9=K9*2
9010 FOR I8=0 TO P8
9011   FOR R9=I8 TO 1 STEP -S9
9012   LET T9=R9
9013   LET B9=T9+S9
9014   FOR I9=0 TO K
9015     ON SGN(A[T9,I9]-A[B9,I9])+2 THEN GOTO 9028, 9016, 9018
9016   NEXT I9
9017   GOTO 9028
9018   FOR I9=0 TO C
9019     LET T8=A[T9,I9]
9020     LET A[T9,I9]=A[B9,I9]
9021     LET A[B9,I9]=T8
9022   NEXT I9
9023   LET L8=R9
9024   LET F9=F9+1
9026   NEXT R9
9028 NEXT I8
9029 IF F9=0 THEN IF S9=1 THEN RETURN 
9030 LET P9=P9+1
9031 IF S9=1 THEN LET L9=L8
9032 GOTO 9005
:
: * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
: FOR SORTING A SINGLE DIMENSION ARRAY, A[R]:
:
:      SUBSTITUTE FOLLOWING STATEMENT FOR 9014-17
: 9015   IF A[T9]>=A[B9] THEN GOTO 9028
:
:      SUBSTITUTE FOLLOWING STATEMENTS FOR 9018-22
: 9019   LET T8=A[T9]
: 9020   LET A[T9]=A[B9]
: 9021   LET A[B9]=T8
:
: * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
: FOR SORTING A STRING, A$[R*C]:
:
:      SUBSITUTE FOLLOWING FOR 9014-22
: 9015   LET T9=(T9-1)*C+1
: 9016   LET B9=(B9-1)*C+1
: 9017   IF A$[T9,T9+C-1]<=A$[B9,B9+C-1] THEN GOTO 9026
: 9018   LET T9$=A$[T9,T9+C-1]
: 9019   LET A$[T9,T9+C-1]=A$[B9,B9+C-1]
: 9020   LET A$[B9,B9+C-1]=T9$
