/*************************************************************************
*
*
*	Name:  sfdata.c
*
*	Description:  Global data structures for SForm routines.
*
*
*	History:
*	Date		By		Comments
*
*	03/16/84	waf
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

*/

#include	"/sform/src/sfint.h"



/************************************/
/*		User definable variables	*/
/************************************/

/* NOTE that many of these vars/ptrs are 'reset' by sfinit(), so they should
   be changed after sfinit() is called. */


char	*sf_spchr	= (char *) 0 ;
/* If the SF_SPCHR bit flag is set, this var must contain the address of a
null terminated list of legal characters. */

extern	sf_nulerr() ;
int		(*sf_usrerr)()	= sf_nulerr ;
/* This fn is invoked if an fatal error occurs during input. The code returned
from this fn determines whether the error is reported.
Note - If the user sets this var to the addr of a user fn, the function must
return a reasonable completion code. The code returned should be SF_ERROR is
the error is to be reported.
Note - If the user sets this var, it should be reset to 'sf_nullerr' after-
wards. */

extern	int	sf_stdftbl[][2] ;
int		(*sf_fntable)[][2]	= (int (*)[][2]) sf_stdftbl ;
/* This is the address of the 'function key' mapping table. The entries
consist of a character or TIP code, followed by the code for one of the
internal SForm functions. Note that the default table is in the module
fnkeys.c. Note that the table is NULL terminated. */

unsigned sf_inatros ;
/* This value is added to the display attribute value to derive the 'input
display attribute'. This is used to 'highlight' the current input field. */

extern	sfnotimp() ;
int	(*sf_usrhelp)()		= (int (*)()) sfnotimp ;
/* This is the address of the function to be invoked when the user hits the
'Help' fn key. */

/********************************/
/*		User accesable vars		*/
/********************************/

/* These vars contain information which may be useful to the user's pgm */


int		sf_fldmod ;
/* After winio() returns, this var will contain the fld # of the last field in
the window which was modified by the user. It will be '0' if no flds were
modified. */

/********************************/
/*		Internal variables		*/
/********************************/


struct SF_FIELD		sf_nullfld = 	/* define a 'null' field desc */
SF_ENDFLD ;
/* This structure MUST be used to terminate the field desc structure list. */

struct SF_WINDOW	*sf_curwin 	= SF_NULL ;
/* This is the addr of the current window. It is set by the sfinit() fn,
and is used to be sure that the sfinit() fn has been called. */


int		sf_nchars ;
/* This value is returned by the field input functions, and is the # of
characters actually input into the field. If it is 0, then either the field
was not changed or the field was cleared (the fn should return code SF_CLRFLD
if the field was cleared). */

char	sf_delchar ;
char	sf_killchar ;
/* These are the (current) values of the erase and kill characters. They are
set by sfinit(). */

unsigned sf_datr 	= SF_ATNORM ;
/* This var is used to save the most recent value of the display attribute
word. It is updated every time sfsetdatr() is called. It is used to restore
the display attributes after an error message, etc.. */

int		sf_hifld	= 0 ;
/* This is the fld # of the highest field number in the current window. It is
set by sfinit(). */

int		sf_curfld	= 0 ;
/* This var is used to save the current field number. It is used (along with
sf_nchars) to derive the current cursor position. */

int		sf_errflg	= 0 ;
/* If an error message is printed, this flag is set. It can be used to erase
old error messages, using sfclrerm(). */

int		sfcurcol, sfcurrow ;
/* These vars are used to save the current cursor position (zero based).
The PC BIOS fn's have to know the cursor position. */
/** Currently not used **/
