#include "stdio.h"
#include "errno.h"
#include "a.out.h"
#include "exe.h"

extern int errno;
char hexdigits[] = "0123456789ABCDEF";
struct exec exec;

main(argc,argv)
int argc;
char **argv;
{
   char **arg;
   char *inname;
   int mode=1, flag=0;

   for (arg = argv + 1; *arg != 0; arg++) {
      if (**arg == '-') {
	 if ((mode = cindex("abce",*(++(*arg)))) == 0) {
	    printf("topc: Invalid switch %s\n",*arg);
	    exit(-1);
	 }
      } else {
	 flag = 1;
	 if (makeout(open(*arg,0),mode) != 0)
	    perror("topc");
      }
   }
   if (flag == 0)
      if (makeout((mode == 1) ? 0 : open("a.out",0),mode) != 0)
	 perror("topc");
}

/* Return relative offset of charater c in string s or zero
*/
cindex(s,c)
char *s, c;
{
   int i;
   
   for (i=1 ; *s != '\0' ; i++) 
      if (*s++ == c) return(i);
   return (0);
}

makeout(inchan,mode)
int inchan, mode;
{
   if (inchan == -1) return(-1);
   switch (mode) {
      case 1:
	 return (maketxt(inchan));
      case 2:
	 return (makebin(inchan));
      case 3:
	 if (read(inchan,&exec,sizeof exec) <= 0) return(-1);
	 if (exec.a_flag != 1 || exec.a_magic != A_MAGIC1) {
	    errno = ENOEXEC;
	    return(-1);
	 }
	 return (makecom(inchan));
      case 4:
	 if (read(inchan,&exec,sizeof exec) <= 0) return(-1);
	 if (exec.a_flag != 1 || exec.a_magic != A_MAGIC3) {
	    errno = ENOEXEC;
	    return(-1);
	 }
	 return (makeexe(inchan));
   }
}

maketxt(inchan)
{
   int c, firstchar;
   FILE *fd;

   firstchar = 1;
   fd = fdopen(inchan,"r");
   while ((c = getc(fd)) != EOF) {
      if (firstchar) putchar(1);
      putchar(c);
      firstchar = (c == '\n');
   }
   return (0);
}

makebin(inchan)
{
   int c;
   FILE *fd;
   unsigned adr;

   fd = fdopen(inchan,"r");
   adr = 0;
   absbeg();
   while ((c = getc(fd)) != EOF) {
      absout(adr++,c);
   }
   absdump();
   return(0);
}

makecom(inchan)
int inchan;
{
   char buffer[512], *p;
   int n;
   long size;
   unsigned adr;

   size = (long) exec.a_text + (long) exec.a_data - 0x0100;
   lseek(inchan,(long) 0x0100,1);
   absbeg();
   for (adr = 0; size > 0;) {
      if (read(inchan,p = buffer,sizeof buffer) <= 0) return(-1);
      for (n = sizeof buffer; n > 0; n--)
	 if (size-- > 0) absout(adr++,*p++);
	 else break;
   }
   if (exec.a_bss != 0) {
      absout(adr+exec.a_bss-1,0);
   }
   absdump();
   return(0);
}

makeexe(inchan)
int inchan;
{
#define stksize 0x0100

   long size;
   struct exehead exehead;
   int n;
   char buffer[512], *p;
   unsigned adr;

   size = (long) exec.a_text + (long) exec.a_data;
   exehead.e_magic = 0x5a4d;
   exehead.e_last = (size + stksize) & 0xff;
   exehead.e_size = (size + stksize + 511)/512 + 1;
   exehead.e_nrel = 0;
   exehead.e_hsize = 512/16;
   exehead.e_min = 0;
   exehead.e_max = -1;
   exehead.e_stkseg = (exec.a_text+15)/16;
   exehead.e_stack = exec.a_data + stksize;
   exehead.e_check = 0;
   exehead.e_code = 0;
   exehead.e_codseg = 0;
   exehead.e_reloff = 512/16;
   exehead.e_ovlnum = 0;
   absbeg();
   for (adr = 0, p = (char *) &exehead; adr <= sizeof exehead;)
      absout(adr++,*p++);
   for (adr = 512; size > 0;) {
      if (read(inchan,p = buffer,sizeof buffer) <= 0) return(-1);
      for (n = sizeof buffer; n > 0; n--)
	 if (size-- > 0) absout(adr++,*p++);
	 else break;
   }
   absout(adr + stksize - 1,0);
   absdump();
   return(0);
}

unsigned absadr;
char absbuf[32];
int abslen;

absbeg()
{
   absadr = 0;
   abslen = 0;
}

absout(adr,j)
unsigned adr;
int j;
{
   if (abslen == 32 || adr != absadr+abslen) absdump();
   if (abslen == 0) absadr = adr;
   absbuf[abslen++] = j;
}

absdump()
{
   char *p;
   int cksum;

   if (abslen == 0) return;
   putchar(1);
   puthex(absadr>>8); puthex(absadr);
   puthex(abslen);
   for (p = absbuf, cksum = 0; abslen > 0; p++, abslen--) {
      puthex(*p);
      cksum += (*p) & 0xFF;
   }
   puthex(-cksum);
   putchar('\n');
}

puthex(h)
int h;
{
   putchar(hexdigits[(h>>4)&0xF]);
   putchar(hexdigits[h&0xF]);
}
