/*
	make new .pl from old .pl
*/

#include "/bb/include/ptype.h"

#define BUCKCNT 32
#define BUCKSTART 512L

main()
{
	int	fdi,fdo,n,i,j;
	char	iname[100],oname[100],buf[30000];
	PLHEADER plh;
	PLENT	plbuck[BUCKCNT];
	long	progpos;

	printf("Input old .pl: ");
	scanf("%s",iname);
	printf("Input new .pl: ");
	scanf("%s",oname);

	if ((fdi = open(iname,0)) < 0) {
		printf("Can't open %s\n",iname);
		exit(-1);
	}

	if((fdo = creat(oname,0777)) < 0) {
		printf("Can't create %s\n",oname);
		exit(-1);
	}

	if (read(fdi,&plh,sizeof(PLHEADER)) < sizeof(PLHEADER)) {
		printf("Can't read .pl header\n");
		exit(-1);
	}

	if (write(fdo,&plh,sizeof(PLHEADER)) < sizeof(PLHEADER)) {
		printf("Can't write .pl header\n");
		exit(-1);
	}

	swab(&plh,&plh,sizeof(PLHEADER));

	lseek(fdo,BUCKSTART,0);	/* leave sector for header in new .pl */
	lseek(fdi,16L,0);;	/* start of buckets on input */

	/* copy rest of file over */
	while ((n = read(fdi,buf,30000)) > 0) {
		if (write(fdo,buf,n) < 0) {
			printf("Can't write to %s\n",oname);
			exit(-1);
		}
	}

	lseek(fdi,16L,0);		/* point to input buckets */
	lseek(fdo,BUCKSTART,0);		/* point to output buckets */

	for (j = 0; j < plh.hashfram; ++j) {
		if (read(fdi,plbuck,sizeof(plbuck)) < sizeof(plbuck)) {
			printf("Can't read bucket #%d\n",j);
			exit(-1);
		}
		for (i = 0; i < plh.entrycnt; i++) {
			if (plbuck[i].plname[0] != '\0') {
				swab(&plbuck[i].plloc,&progpos,sizeof(long));
				printf("old position = %D\n",progpos);
				progpos += BUCKSTART - 16L;
				printf("new position = %D\n",progpos);
				swab(&progpos,&plbuck[i].plloc,sizeof(long));
			}
		}
		if (write(fdo,plbuck,sizeof(plbuck)) < sizeof(plbuck)) {
			printf("Can't write bucket #%d\n",j);
			exit (-1);
		}
	}

	exit(0);
}
