/* 
	Dump pcode header
*/

#include "/bb/include/ptype.h"

main (argc,argv)
int argc;
char *argv[];
{
	int	i,fd;
	struct phead pch;
	char	buf[PATHSIZE],cram[4];
	unsigned *uptr,chk;

	if (argc != 2) {
		printf("Usage: %s pcodefile\n",argv[0]);
		exit(-1);
	}

	if ((fd = open(argv[1],0)) < 0) {
		printf("Can't open %s\n",argv[1]);
		exit(-1);
	}

	if (read(fd,(char *)&pch,sizeof(pch)) < 0) {
		printf("Can't read pcode header\n");
		exit(-1);
	}

	if (pch.magic != 30042) {
		printf("%s is not a pcode file!\n",argv[1]);
		exit (-1);
	}

	if (read(fd,buf,PATHSIZE) < 0) {
		printf("Can't read program name\n");
		exit(-1);
	}

	for (i=0; i<4; ++i)  
		cram[i] = pch.cram[i];

	if (buf[0] != '\0')
	printf("Dump for : %s\n",buf);
	printf("magic    : %-5u\t",pch.magic);
	printf("totsiz   : %-5u\n",pch.totsiz);
	printf("codsiz   : %-5u\t",pch.codsiz);
	printf("ltabsiz  : %-5u\n",pch.ltabsiz);
	printf("symsiz   : %-5u\t",pch.symsiz);
	printf("stksiz   : %-5u\n",pch.stksiz);
	printf("ustsiz   : %-5u\t",pch.ustsiz);
	printf("maxsiz   : %-5u\n",pch.maxsiz);
	printf("lasterrno: %-5d\t",pch.lasterrno);
	printf("begmem   : %-5x\n",pch.begmem);
	printf("pclast   : %-5x\t",pch.pclast);
	printf("pcerr    : %-5x\n",pch.pcerr);
	printf("lastfilno: %-5d\t",pch.lastfileno);
	printf("randseed : %-5u\n",pch.randseed);
	printf("timeleft : %-5u\t",pch.timeleft);
	printf("cram     : %c %c %c %c\n",cram[0],cram[1],cram[2],cram[3]);
	printf("pc       : %-5x\t",pch.pc.B);
	printf("fp       : %-5x\n",pch.fp.B);
	printf("bfp      : %-5x\t",pch.bfp.B);
	printf("gfp      : %-5x\n",pch.gfp.B);
	printf("sp       : %-5x\t",pch.sp.B);
	printf("revision : %u.%u\n",(pch.revision>>8)&0x00ff,pch.revision&0x00ff);
	printf("pcstmtx  : %-5x\t",pch.pcstmtx.sxflag);
	printf("derror   : %-5u\n",pch.derror);
	printf("dikey    : %-5u\t",pch.dikey);
	printf("dbreak   : %-5u\n",pch.dbreak);
	printf("dcontin  : %-5u\t",pch.dcontin);
	printf("dabort   : %-5u\n",pch.dabort);
	printf("dabortp  : %-5u\t",pch.dabortp);
	printf("dpmdump  : %-5u\n",pch.dpmdump);
	printf("compdeb  : %-5u\t",pch.compdeb);
	printf("runonly  : %-5u\n",pch.runonly);
	printf("noltab   : %-5u\t",pch.noltab);
	printf("chksum   : %-5u\n",pch.chksum);

	for(chk=0,uptr=(unsigned *)&pch,i=0;
		i < (sizeof(pch)-sizeof(pch.chksum))/sizeof(unsigned);
			++i)
		chk += *uptr++;
	chk = 0 - chk;

	printf("computed checsum = %u\n",chk);

	exit(0);
}

