/*
	read file names from /dev/tar
*/

#include <stdio.h>

#define BUFSIZE 10240
#define TARSIZE 1152000

char	buf1[BUFSIZE*3],buf2[BUFSIZE];

main(argc,argv)
int	argc;
char	*argv[];
{
	char	*cp;
	FILE	*fdi;

	cp = argv[0];

	if (argc > 2) {
		fprintf(stderr,"%s: Usage - %s\n",cp,cp);
		exit(-1);
	}

	if ((fdi = fopen("/dev/tar","r")) == NULL) {
		fprintf(stderr,"%s: Can't open /dev/tar\n",cp);
		exit (-1);
	}

	for (;;) {
		if (fread(buf1,1,1,fdi) < 1) {
			fprintf(stderr,"Can't read /dev/tar\n");
			exit(-1);
		}

		if (buf1[0] == 'E') {
			fclose (fdi);
			exit(0);
		}
		if (buf1[0] == 'N') {
			readtar(fdi);
			continue;
		}
		fprintf(stderr,"Incorrect format!\n");
		exit(-1);
	}
}


readtar(fd)
FILE	*fd;
{
	char	name[256];
register unsigned n,y;
	unsigned x;
	long	l;
	int	fdt;
	
	if (fread(&x,sizeof(unsigned),1,fd) < 1) {
		fprintf(stderr,"Can't read size of name from /dev/tar\n");
		exit(-1);
	}

	if (fread(name,1,x,fd) < x) {
		fprintf(stderr,"Can't read name of file from /dev/tar\n");
		exit(-1);
	}

	name[x] = '\0';
	printf("%s: ",name);

	for (l = 0;;) {
		if (fread(buf1,1,1,fd) < 1) {
			fprintf(stderr,"Can't read record type from /dev/tar\n");
			exit(-1);
		}

		if (buf1[0] == 'Z') {
			fdt = open("/dev/tty",0);
			fprintf(stderr,"Mount next disk - press newline to continue\n");
			read(fdt,name,1);
			close(fdt);
			continue;
		}
		if (buf1[0] == 'F') {
			printf("%U bytes\n",l);
			return;
		}
		if (buf1[0] != 'D') {
			fprintf(stderr,"Incorrect format on disk\n");
			exit(-1);
		}
		if (fread(&x,sizeof(unsigned),1,fd) < 1) {
			fprintf(stderr,"Can't read data record size from /dev/tar\n");
			exit(-1);
		}

		if (fread(buf1,1,x,fd) < x) {
			fprintf(stderr,"Can't read data record /dev/tar\n");
			exit(-1);
		}

		l += x;	/* add in data lentgh */

	}
}
