
/*                                                           */
/*       Copyright 1983 Technical Analysis Corporation       */
/*                                                           */

#define TRUE  1
#define FALSE 0

main(argc, argv)
int argc;
char *argv[];
{
   int fd, i, k, blk;
   long ptr, start;
   unsigned keysiz, keycnt, klink;
   char buf[512], *cp;

   if (argc != 2) {
      printf("Usage: ick file\n");
      exit(-1);
   }

   if ((fd = open(*++argv, 0)) < 0) {
      printf("ick: can't open %s\n", *argv);
      exit(-1);
   }

   start = 0L;
   lseek(fd, start, 0);
   read(fd, buf, 512);
   swab(buf, (char *) &keysiz, 2);

   loop:

      printf("\nblock number: ");
      scanf("%d", &blk);
      if (blk <= 0)
	 exit(0);

      lseek(fd, (long) blk*512, 0);
      read(fd, buf, 512);

      cp = buf;
      swab(cp, (char *) &keycnt, 2);
      swab(cp+2, (char *) &klink, 2);
      printf("key-count = %d, link = %d  (", keycnt, klink);
      for (i = 0; i < 4; i++)
	 printf("%5d", (int) *(cp+i)&255);
      printf(")\n");

      for (k = 1; k <= keycnt; k++) {
	 cp = buf+k*keysiz;
	 swab(cp, (char *) &ptr, 4);
	 printf("      pointer = %3D      key = '", ptr);
	 cp = buf+(k-1)*keysiz+4;
	 if (*cp >= ' ' && *cp <= '~')
	    for (i = 0; *cp != '\0' && i < keysiz-4; i++)
	       printf("%c", *(cp+i));
	 else
	    printf("<end-marker>");
	 printf("'\n");
      }

   goto loop;

} /* end-main */
