/*
	cmprs - compress common characters
	decmp - decompress common characters
*/
#define CMPCHR '\233'

cmprs(inbuf,inlth,outbuf)	/* returns the number of characters in outbuf */
char	*inbuf,*outbuf;
int	inlth;
{
register unsigned i,j,k;
	char	c;

	for(i=0, k=0; i < inlth; ) {
		c = inbuf[i++];
		if (c == CMPCHR) {
			outbuf[k++] = CMPCHR;
			outbuf[k++] = '\0';
			outbuf[k++] = '\0';
			continue;
		}
		for (j = 1; c == inbuf[i] && j < 255; ++i, ++j)
			;
		if (j == 1)
			outbuf[k++] = c;
		else if (j == 2) {
			outbuf[k++] = c;
			outbuf[k++] = c;
		} else if (j == 3) {
			outbuf[k++] = c;
			outbuf[k++] = c;
			outbuf[k++] = c;
		} else {
			outbuf[k++] = CMPCHR;
			outbuf[k++] = c;
			outbuf[k++] = (char)j;
		}
	}

	return(k);
}

decmp(inbuf,outbuf)	/* returns the number of chars in outbuf */
char	*inbuf,*outbuf;	/* inbuf holds 3 characters */
{
register unsigned i,j;
	char	c;

	if (inbuf[0] != CMPCHR)
		return(-1);	/* error */

	if (inbuf[1] == '\0' && inbuf[2] == '\0') {
		outbuf[0] = CMPCHR;
		return(1);
	}

	j = (unsigned)inbuf[2];
	c = inbuf[1];
	for (i=0; i < j; ++i)
		outbuf[i] = c;

	return(j);
}
