/* pls.c - 'ls' with date comparisons.

??/??/??	mas
10/11/83	waf	Exclude 'special' files.
10/14/83	waf	Allow '+' after date.

Usage:	pls [ -d mm/dd/yy[+] ]

All files in the current dir, and all sub-directories are 'listed'.
If -d is used, the 'last modified' dates of all files are compared against the 
given date.
If the '+' is not included after the date, file dates equal to or greater
than the given dates are passed.
If the '+' is included after the date, file dates greater than the given
date are passed. (This was included for our backups, which use a previously
saved date).

Note - the 'd' switch allows only the date to be specified, not the time.
*/

#include <sys/types.h>
#include <sys/dir.h>
#include <stdio.h>
#include <sys/stat.h>

FILE	*fopen(),*popen(),*pclose();
long	cdate,cnvdate();
int		datesw;		/* '-d' switch */
char	plus;		/* '+' flag */

main(argc,argv)
int	argc;
char	*argv[];
{
	char	curdir[130];
	FILE	*pp;
	int	i;
	unsigned month,day,year;

	pp = popen("pwd","r");
	fgets(curdir,128,pp);
	pclose(pp);
	curdir[strlen(curdir)-1] = '\0';

	datesw = 0;
	if (argv[1][0] == '-') {
		for (i=1; argv[1][i] != '\0'; ++i) {
			if (argv[1][i] == 'd')
				datesw = 1;
			}
		}

	month = day = year = 0;
	if (datesw == 1) {
		plus = ' ' ;
		sscanf(argv[2],"%d/%d/%d%c",&month,&day,&year,&plus);
		cdate = cnvdate(month,day,year,0,0,0);
		if ( plus == '+' )
			cdate += 86400 ;	/* add (about) a day to the given date */
		}

	dodir(curdir);

	exit(0);
	}

dodir(dirname)
char	*dirname;
{
	register FILE	*fp;
	register int	i;
	struct direct dbuf;
	struct stat stbuf;

	char	buf[128],wbuf[128];

	if ((fp = fopen(dirname,"r")) == NULL) {
		fprintf ( stderr, "\7pls: Can't open directory: %s\n",dirname);
		return;
		}

	for (;;) {
		if (fread((char *)&dbuf,sizeof(dbuf),1,fp) == 0)
			break;	/* eof */
		if (dbuf.d_ino == 0)
			continue;
		if (strcmp(dbuf.d_name,"..") == 0)
			continue;
		if (strcmp(dbuf.d_name,".") == 0)
			continue;
		strncpy(buf,dbuf.d_name,14);
		buf[14] = '\0';
		strcpy(wbuf,dirname);
		if ( wbuf[1] != 0 )		/* append '/' if dirname != '/' */
			strcat(wbuf,"/");
		strcat(wbuf,buf);

		stat(wbuf,&stbuf);
		i = stbuf.st_mode ;

		/* chk for special file */
		if ( (i & S_IFBLK) == S_IFBLK || (i & S_IFCHR) == S_IFCHR ) {
			/* fprintf( stderr, "pls: skipping special file = %s\n", wbuf ); */
			continue ;
			}

		/* chk for dir */
		if ( (i & S_IFDIR) == S_IFDIR ) {
				dodir(wbuf);
			continue;
			}

		/* chk file date */
		if (datesw == 1 ) {
			if ( stbuf.st_mtime < cdate )
				continue;
			}

		if ((stbuf.st_mode & S_IFDIR) != S_IFDIR)
			printf("%s\n",wbuf);
		}

	fclose(fp);
	return;
	}


long cnvdate(month, day, year, hour, min, sec)
unsigned month,day,year,hour,min,sec;
{
	register unsigned i,d;
	unsigned y,mflg;
	long	s;

	for (y=year-68, d=day, i=0; i < y; ++i)
		d += (i & 3) ? 365 : 366;

	for (mflg = 2773, i=1; i < month; ++i, mflg >>= 1)
		d += (mflg & 1) ? 31 : (i != 2) ? 30 : (y & 3) ? 28 : 29;
	d -= 731;	/* make it since 1970 */

	s = (long)d * 86400L;
	s += sec;
	s += min * 60;
	s += (long)hour * 3600L;

	s -= 61200L;

	return(s);
	}

