
	* * * * * * * * * * * * * * * * * * * * * * * * * * * *
	*						      *
        *                      MULTIDSK	 		      *
	*						      *
        *   COPYRIGHT (C) 1984,85,86 - AMPRO COMPUTERS, INC.  *
	*						      *	
	* * * * * * * * * * * * * * * * * * * * * * * * * * * *


;revision log:
;
;		4/24/86 Ver 2.4
;			Fixed problem with 96tpi.
;
;		4/08/86 Ver 2.3 
;			Fixed display bug. Non-functional change.
;
;		5/22/85 Ver 2.2
;			Added support for 48tpi formats in a 96tpi
;			drive.  Added support for 8" 3740 with bios
;			3.0+ (assembly time option)
;
;		2/28/85 Ver 2.1
;			Removed warning message of 12/12/84, added
;			translation of drive letters for bios 2.0+
;
;	       12/12/84 Ver 2.0
;			Added warning message for use with
;			Hard disk bios.
;
;		5/13/84 Ver 1.4
;			Added nulls to line feeds for
;			S-L-O-W terminals (VT100 etc.).
;
;		5/08/84 Unreleased Ver.1.3X 
;			Added Televideo, Sanyo, Pmc Type A.
;		
;		3/09/84	Release Ver 1.2
;			Deleted IBM DS, TI DS. Added OSB 1,
;			H/Z 89 SD, TRS80-3. Corrected menus
;			This version requires Bios 3/5
;			or later.
;
;		2/17/84 Release Ver 1.1
;			Now allow drive A to be used as "E".
;			Corrected bug in H9 (H89 DSXD)
;			WS added a few lines of extra code!
;		
;		2/3/84  Release version 1.0
;			
;
;MULTIDSK allows the "E" drive of the AMPRO series 100 computers
;to read and write several different 48 & 96 tpi disk formats.  Multidsk 
;changes the TYPE byte, DPB, Drive, and the SKEW table in the bios.  A 
;total of 37 bytes are allowed (1 TYPE byte, 15 for DPB, 1 for Drive 
;selected 20 for SKEW table).  Type byte is a single byte which defines 
;the particulars of the foreign disk format.  The DPB (disk parameter 
;block) is the standard Digital Research dpb and can be learned by 
;studying the CP/M 2 Alteration Guide as supplied by Digital Research.  
;The drive select byte defines which drive will be used as the "E" drive 
;(01=B, 02=C, and 03=D).  The skew table defines the skew of the physical 
;sectors not the logical sectors. 
;
;definition of type byte:
;
;	bit 7	  density: 0=single; 1=double
;	bit 6	  double sided media if = 1
;	bit 5	  double sided mode:
;				1 = continuous sector numbers (first
;				    sector on side one = last sector
;				    on side 0 + 1).
;				    both tracks are treated as a 
;				    single track with twice as many
;				    sectors.
;				0 = same sectors on both sides
;				    (normal method)
;	bit 4	  reserved 
;	bits 3-2  00 = 1k allocation blocks
;		  01 = 2k allocation blocks
;		  10 = not used
;		  11 = not used
;	bits 1-0  00 = 128 byte sectors
;		  01 = 256 byte sectors
;		  10 = 512 byte sectors
;		  11 = 1024 byte sectors 
;
;
CR:	EQU	0DH		;carrige return 
LF:	EQU	0AH		;line feed
ESC:	EQU	01BH		;escape
CAPS:	EQU	05FH		;upper case
ETX:	EQU	3		;^c

EIGHT$INCH:	EQU	0	; Set to 1 to show 8" entries

bdos	equ	5

	ORG	0100H		;base of tpa
	;
BEGIN:	
	LXI	H,0		;zero out h&l
	DAD	SP		;add sp to hl
	SHLD	OLDSP		;save it
	LXI	SP,STACK 	;set up new stack	
	;
	;ckdrv loads the default drive and compares it
	;against the e drive which isn't allowed.  prints
	;error message if true.
	;
CKDRV:
	LDA	4		;get default drive
	CPI	4		;is it drive "e"?
	JZ	WRGDRV		;get ready to quit if it is

	lhld	01H
	mvi	l,74h
	mov	a,m
	ani	3fh		; mask off D-speed & D-step
	mov	m,a

	;
	;eaddr gets the location of eparm in the bios.
	;
EADDR:	LHLD	1		;get warm boot vector
	MVI	L,36H		;getedsk offset
	LXI	D,BIORET 	;point to bios return point
	PUSH	D		;save d
	PCHL			;return with dpb addr
	;
	;bioret returns with the bios location of eparm
	;and saves it for use later.
	;
BIORET: DCX	H		;back up to type byte location
	SHLD	ADDR		;save location

; Interrogate the command line for any characters

	lxi	h,80h
	mov	a,m
	inx	h
	ora	a
	jz	sign
	mov	b,a
	lxi	d,cldrive
	mvi	c,4
nextchr:
	mov	a,m
	dcr	b
	inx	h
	jm	sign
	cpi	' '
	jz	nextchr
	stax	d
	inx	d
	dcr	c
	jz	sign
	jmp	nextchr

cldrive	db	0
clmenu	db	0
cltype	db	0
cl4896	db	0

	;
	;print the signon message.
	;
SIGN:
	mvi	a,0		; clear bios version 
	sta	lb$vers

	call	get$bios$vers	; get bios version
	mvi	a,16
	jnz	new$sys
	lhld	1
	mvi	l,5ch
	mov	a,m
	jmp	plugem
new$sys:
	push	psw
	xra	a
	lxi	h,jplug1
	mov	m,a
	inx	h
	mov	m,a
	inx	h
	mov	m,a
	pop	psw
plugem:
	adi	'@'
	sta	plug1
	inr	a
	sta	cplug1

	lda	lb$vers
	cpi	30
	jp	chk$eight
	mvi	a,0c3H		; change nop's to jmp if less than bios 3.0
	sta	loop
	lxi	h,loop2
	shld	loop+1
chk$eight:
	lda	lb$vers
	cpi	30
	if	eight$inch	; If 8" is enabled, then blot out text only
	jp	doit		;   if bios is less than version 3.0.  If 8" 
	endif			;   is not enabled, always blot out text.
	mvi	a,0c3h		; change 'jz' to 'jmp'
	sta	zplug3a
	mvi	a,'$'		; add '$' to text
	sta	zplug3b
	lxi	h,zplug3c	; remove '4, ' from text
	mvi	m,0
	inx	h
	mvi	m,0
	inx	h
	mvi	m,0


	jmp	doit


DISPLAY$FDEV:
	lda	lb$vers
	cpi	20
	rm

	LXI	D,D$FDEV$HDR	; Print header
	mvi	c,9
	call	bdos

	mvi	a,0		; starting unit #
D$NEXT$FDEV:
	sta	unit
	call	lb$get$ldte	; Get address of unit id	
	MOV	A,M		; Get unit id
	CPI	01		; Floppy?
	JNZ	D$BUMP$PTR	; No -- go to the next device
	inx	h		; Get drive #
	mov	a,m		; .
	ani	03h		; mask out excess bits
	MOV	l,a		; update floppy device number
	mvi	h,0		; .
	dad	h		; x2
	xchg
	LXI	H,FNAMES	; .
	dad	d		; x2
	dad	d		; x4
	dad	d		; x6
	lxi	d,d$fname	;
	lxi	b,6		; 
	db	0edh,0b0h	; . (LDIR)
	lda	unit		;
	adi	'A'		;
	sta	d$current	;
	LXI	D,D$FDEV$LIN	; and output the line
	mvi	c,9
	call	bdos

D$BUMP$PTR:
	lda	unit
	inr	a		; Bump to next unit
	cpi	16		; Done yet?
	jm	D$NEXT$FDEV	; No -- go do the next one
	RET

unit:	db	0

D$FDEV$HDR:	DB	CR,LF,'FLOPPY DISK ASSIGNMENTS',CR,LF
		DB	'CP/M drive   '
		DB	'Floppy disk',CR,LF
		DB	'------------------------',CR,LF,'$'

D$FDEV$LIN:
		DB	' '
D$CURRENT:	DB	'x  '
D$EDISK:	DB	'   '
D$EBLANK:	DB	'         '
D$FNAME:	DB	'        '
		DB	CR,LF,'$'
D$FDEV$HLEN	EQU	$-D$FDEV$LIN	; Line length

FNAMES:		DB	'First '
		DB	'Second'
		DB	'Third '
		DB	'Fourth'

; end of DISPLAY$FDEV



GET$BIOS$VERS:
; Get bios version -- Brings the current BIOS jump tables (starting
;     at warm boot) to a local area for ease of utility access.  If
;     this BIOS is version 2.1 or greater, the secondary jump table
;     is brought in as well.
;
; Entry: none
; Exit:  Z  = bios < 2.1 (old bios)
;        NZ = bios 2.1+  (fixed disk bios)
;        All registers are modified
;
	LHLD	1		; Get start of bios jump table
	LXI	D,LB$BIOS$TBL	; Move bios to local storage
	lxi	B,LB$LEN	; .  (length of bios area)
	db	0edh,0b0h	; .  (move routine)
	MVI	A,0		; Test CP/M version
	CALL	LB$GETNXT	; Get next jump table
	STA	LB$VERS		; Save bios version
	INX	H		; See if HL is 0FFFFh
	MOV	A,H		; .
	ORA	L		; .
	RZ			; If so, then old version
	DCX	H		; Fix HL as it has the table addr
	LXI	D,LB$XTBL	; Move extra table to local storage
	lxi	B,LB$XLEN	; .  (length of extra table)
	db	0edh,0b0h	; .  (move routine)
	MVI	A,0FFH		; Set NZ to indicate bios
	ORA	A		; ... version 2.1+
	RET			; ... and return.


* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*							*
*		Data area . . .				*
*							*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * *

; Replicated BIOS for ease of use . . .
LB$BIOS$TBL:
LB$WBOOT	DB	0,0,0	; Warm boot
LB$CONST	DB	0,0,0	; Console status
LB$CONIN	DB	0,0,0	; Console input
LB$CONOUT	DB	0,0,0	; Console output
LB$LISTOUT	DB	0,0,0	; List output
LB$PUNCH	DB	0,0,0	; Punch output
LB$READER	DB	0,0,0	; Reader input
LB$HOMDSK	DB	0,0,0	; Home disk (move to track 00)
LB$SELDSK	DB	0,0,0	; Select disk drive
LB$SETTRK	DB	0,0,0	; Select track number
LB$SETSEC	DB	0,0,0	; Select sector number
LB$SETDMA	DB	0,0,0	; Set DMA address
LB$DSKREAD	DB	0,0,0	; Disk read
LB$DSKWRITE	DB	0,0,0	; Disk write
LB$LISTST	DB	0,0,0	; List status
LB$SECTRN	DB	0,0,0	; Sector translate routine
; AMPRO-specific BIOS calls
LB$GETNXT	DB	0,0,0	; Get bios ver & next tbl address
LB$GETEDSK	DB	0,0,0	; Get pointer to E-disk storage
LB$IOINIT	DB	0,0,0	; Set new I/O parameters
LB$SCSIDRV	DB	0,0,0	; SCSI direct driver

LB$LEN	EQU	$-LB$WBOOT	; Length of bios table

LB$XTBL:
LB$SWAP$DRV	DB	0,0,0	; Swap two logical drives
LB$WINDRV	DB	0,0,0	; Set/get win drive parameters
LB$PHYTAB	DB	0,0,0	; Set/get phytab access
LB$GET$LDTE	DB	0,0,0	; Get physical table entry address
LB$RESERVED	DB	0,0,0	; Reserved entry

LB$XLEN	EQU	$-LB$XTBL	; Length of extra table

LB$VERS		DB	0

doit:
	lda	cldrive
	ora	a
	jnz	getdrvc

sign2c:
	LXI	D,SIGNON 	;point to sign on message
	CALL	OUTPUT		;

	lda	lb$vers
	cpi	20
	cp	display$fdev
	lxi	d,sign2
	call	output

	;
	;getdrv checks which drive is selected as the "e" drive.
	;
GETDRV:	CALL	CONIN		;get drive selection
getdrvc	CPI	ESC		;esc?
	JZ	DONE		;endit
	CPI	ETX		;^c?
	JZ	DONE		;
	ANI	CAPS		;force upper case

	cpi	'A'
	jc	another
cplug1	equ	$+1
	cpi	'E'
	jnc	another
	sta	drvsel+7
	sta	sgnoff+19
	sui	'A'
jplug1:	jmp	get$20e
	call	lb$get$ldte
	mov	a,m
	cpi	1
	jnz	another
	inx	h
	mov	a,m
	ani	3
get$20e
	sta	drive
	jmp	main

another
	lda	cldrive
	ora	a
	jz	getdrv
	xra	a
	sta	cldrive
	jmp	sign2c

MAIN:
	lda	clmenu
	ora	a
	jnz	compc

	LXI	D,MAINMU	;point to main menu
	CALL	OUTPUT		;print the main menu
	lxi	d,mainm2
	call	output
	;
	;comp checks which sub-menu is selected and prints it.
	;^c allows exit to cp/m.
	;
COMP:	CALL	CONIN		;
compc	CPI	ESC		;esc?
	JZ	DONE		;end if so
	CPI	ETX		;^c?
	JZ	DONE		;
	ANI	7FH		;clean it up
	STA	TYPE		;
	cpi	'1'
	jz	prtsub
	cpi	'2'
	jz	prtsub
	cpi	'3'
	jz	prtsub
zplug3a:
	jz	zplug3ax
	IF	EIGHT$INCH
	cpi	'4'
	jz	prtsub
	ENDIF
zplug3ax:
	lda	clmenu
	ora	a
	jz	comp
	xra	a
	sta	clmenu
	jmp	main
	;
PRTSUB:
	lda	cltype
	ora	a
	jnz	ckmenu
	lda	type
	LXI	D,SS48		;load d with sub-menu
	CPI	'1'		;single sided 48 tpi?
	JZ	PRTSUB2		;
	LXI	D,DS48		;
	CPI	'2'		;double sided 48 tpi?
	JZ	PRTSUB2		;
	LXI	D,TPI96		;
	CPI	'3'		;96 tpi?
	JZ	PRTSUB2		;
	LXI	D,IBM3740
	cpi	'4'
	jz	ibm3740
prtsub2
	CALL	OUTPUT		;prints the submenu selected
	;
	;ckmenu determines which sub-menu has been selected
	;and jumps to the appropriate comparison routine.
	;
CKMENU:	LDA	TYPE		;get sub menu
	CPI	'1'		;ss48?
	JZ	COMP1		;
	CPI	'2'		;ds48?
	JZ	COMP2		;
	CPI	'3'		;96tpi?
	JZ	COMP3		;
	CPI	'4'
	JZ	IBM3740
	JMP	MAIN		;this should never happen!
	;
	;comp1 checks to see which single sided format has been
	;selected. ^c allows exit to cp/m.
	;
COMP1:
	lda	cltype
	ora	a
	jnz	comp1z
	CALL	CONIN		;
comp1z
	CPI	ESC		;esc?
	JZ	MAIN		;return to main menu
	CPI	ETX		;^c?
	JZ	DONE		;endit
	ANI	CAPS		;force upper case
	CPI	'A'		;a?
	JZ	ACT		;actrix 
	CPI	'B'		;b?
	JZ	DEC		;dec vt180
	CPI	'C'		;c?
	JZ	H10		;heath/zenith 100 ssdd
	CPI	'D'		;d?
	JZ	H12		;heath/zenith 89 sssd
	CPI	'E'		;e?
	JZ	H1		;heath/zenith ssdd
	CPI	'F'		;f?
	JZ	H4		;heath/zenith ssxd
	CPI	'G'		;g?
	JZ	H3		;heath w/magnolia
	CPI	'H'		;h?
	JZ	IBMSS		;ibm ssdd
	CPI	'I'		;i?
	JZ	KAY2		;kaypro ii
	CPI	'J'		;j?
	JZ	LOBO		;lobo ssdd
	CPI	'K'		;k?
	JZ	MOR		;morrow md2
	CPI	'L'		;l?
	JZ	NEC		;nec pc8001a
	CPI	'M'		;m?
	JZ	OS1		;osborne 1 sssd 
	CPI	'N'		;n?
	JZ	OSB		;osborne 2 ssdd
	CPI	'O'		;o?
	JZ	TISS		;ti ssdd
	CPI	'P'		;p?
	JZ	TRS80		;trs80-1
	CPI	'Q'		;q?
	JZ	TRS3		;trs80-3
	CPI	'R'		;r?
	JZ	TRS4		;trs80-4
	CPI	'S'		;s?
	JZ	XERSD		;xerox 820-1
	CPI	'T'		;t?
	JZ	XERDD		;xerox 820-2
	lda	cltype
	ora	a
	jz	comp1
	xra	a
	sta	cltype
	jmp	prtsub
	;
	;comp2 checks to see which double sided 48 tpi format
	;has been selected. ^c exits to cp/m. 
	;
COMP2:
	lda	cltype
	ora	a
	jnz	comp2z
	CALL	CONIN		;
comp2z	CPI	ESC		;esc?
	JZ	MAIN		;return to main menu
	CPI	ETX		;^c?
	JZ	DONE		;endit
	ANI	CAPS		;force upper case
	CPI	'A'		;a?
	JZ	H11		;heath/zenith 100 dsdd
	CPI	'B'		;b?
	JZ	H2		;heath/zenith 89 dsdd
	CPI	'C'		;c?
	JZ	H5		;heath/zenith dsxd
	CPI	'D'		;d?
	JZ	KAY4		;kaypro 4/10
	CPI	'E'		;e?
	JZ	LOBO1		;lobo dsdd
	CPI	'F'		;f?
	JZ	MOR1		;morrow md3
	CPI	'G'		;g?
	JZ	PMC		;pmc type a
	CPI	'H'		;h?
	JZ	SAN		;sanyo mbc1000/1100
	CPI	'I'		;i?
	JZ	TEL		;televideo 802/803
	lda	cltype
	ora	a
	jz	comp2
	xra	a
	sta	cltype
	jmp	prtsub
	;
	;comp3 checks to see which 96 tpi format has been selected.
	;a ^c will allow you to exit directly
	;to cp/m.
	;
COMP3:
	lda	cltype
	ora	a
	jnz	comp3z
	CALL	CONIN		;
comp3z	CPI	ESC		;esc?
	JZ	MAIN		;return to main menu
	CPI	ETX		;^c?
	JZ	DONE		;endit
	ANI	CAPS		;force upper case
	CPI	'A'		;a?
	JZ	DEC1		;dec rainbow
	CPI	'B'		;b?
	JZ	EGL		;eagle 2e-2 ss
	CPI	'C'		;c?
	JZ	H6		;h/z 89 ssdd
	CPI	'D'		;d?
	JZ	H7		;h/z 89 dsdd
	CPI	'E'		;e?
	JZ	H8		;h/z 89 ssxd
	CPI	'F'		;f?
	JZ	H9		;h/z 89 dsxd
	lda	cltype
	ora	a
	jz	comp3
	xra	a
	sta	cltype
	jmp	prtsub
	;
	;conin gets a single character from the keyboard and
	;puts it in the accumulator.
	;
CONIN:	MVI	A,9		; bios call avoids echo to console
	LHLD	1
	MOV	L,A
	PCHL
	;
	;output sends the message pointed to by de to the screen.
	;
OUTPUT:	MVI	C,9		;print string function
	CALL	5		;bdos
	RET			;
	;
TYPE:	DB	'1'		;which sub menu selected
	;
DRIVE:	DB	1		;selected drive
	;
ADDR:	DS	2		;"e" drive parms addr  
	;
	;the signon message...
	;
SIGNON: DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	'	AMPRO Disk Compatibility Utility - Version '
VERSION:
	DB	'2.4',CR,LF
	DB	'	Copyright (c) 1984,85,86 AMPRO Computers, Inc.'
	DB	CR,LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	' MULTIDSK prepares your AMPRO system to read, write, '
	DB	'run programs,',CR,LF,' and access data on 5 1/4 inch '
	DB	'diskettes formatted for many other',CR,LF,' computers.'
	DB	CR,LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	'$'
sign2:	DB	lf,' Which drive do you wish to use as the "E" drive? '
	DB	'(A - '
plug1:	DB	'D) $'
MAINMU:	DB	CR,LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	'			    MULTIDSK  MAIN  MENU',CR,LF
	DB	'			    --------  ----  ----',CR,LF,LF
	DB	'			1 - Single Sided 48 TPI Menu',CR,LF
	DB	'			2 - Double Sided 48 TPI Menu',CR,LF
	DB	'			3 - 96 TPI Menu',CR,LF
zplug3b	db	0
	IF	EIGHT$INCH
	DB	'			4 - SSSD IBM 3740 8" format',CR,LF
	ENDIF
	DB	'$'

mainm2:	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	'			   <ESC> - Exit to CP/M',CR,LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
DRVSEL:	DB	CR,'Drive A Selected as the "E" Drive.',CR,LF
	DB	'Select 1, 2, 3, '
zplug3c	db	'4, '
	DB	'or <ESC> to Exit: $'
	;
	;the single sided 48 tpi menu...
	;
SS48:	DB	CR,LF,'	'
	DB	'These formats require a single or double sided 48 tpi '
	DB	'drive.'
	DB	CR,LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	'		         SINGLE SIDED 48 TPI MENU'
	DB	CR,LF
	DB	'			 ------ ----- -- --- ----',CR,LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	'	A - ACTRIX (ACCESS)		'
	DB	'	K - MORROW MD2',CR,LF
	DB	'	B - DEC VT180			'
	DB	'	L - NEC PC8001A',CR,LF
	DB	'	C - HEATH/ZENITH 100 		'
	DB	'	M - OSBORNE 1',CR,LF
	DB	'	D - HEATH/ZENITH 89 SD		'
	DB	'	N - OSBORNE 2',CR,LF
	DB	'	E - HEATH/ZENITH 89 DD		'
	DB	'	O - TI Pro (CP/M 86)',CR,LF
	DB	'	F - HEATH/ZENITH 89 XD		'
	DB	'	P - TRS80-1 w/OMIKRON',CR,LF
	DB	'	G - HEATH w/MAGNOLIA		'
	DB	'	Q - TRS80-3 w/MEM MERCHANT CP/M',CR,LF
	DB	'	H - IBM (CP/M 86)		'
	DB	'	R - TRS80-4 w/MONTEZUMA CP/M',CR,LF
	DB	'	I - KAYPRO II			'
	DB	'	S - XEROX 820-I',CR,LF
	DB	'	J - LOBO MAX80			'
	DB	'	T - XEROX 820-II',CR,LF
	DB	CR,LF
	DB	0,0,0,0,0,0,0,0,0
	DB	LF
	DB	'		       <ESC> - Return to Main Menu',CR,LF
	DB	0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0
	DB	LF
	DB	'Select a format or <ESC> to Main Menu: $'
	;
	;the double sided 48 tpi menu...
	;
DS48:	DB	CR,LF
	DB	0,0,0,0,0,0,0,0,0
	DB	LF,'	      '
	DB	'These formats require a double sided 48 tpi drive.'
	DB	CR,LF
	DB	0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0
	DB	LF
	DB	'		         DOUBLE SIDED 48 TPI MENU'
	DB	CR,LF
	DB	'			 ------ ----- -- --- ----',CR,LF
	DB	LF
	DB	'			'
	DB	'A - HEATH/ZENITH 100',CR,LF
	DB	'			'
	DB	'B - HEATH/ZENITH 89 DD',CR,LF
	DB	'			'
	DB	'C - HEATH/ZENITH 89 XD',CR,LF
	DB	'			'
	DB	'D - KAYPRO 4/10',CR,LF
	DB	'			'
	DB	'E - LOBO MAX80',CR,LF
	DB	'			'
	DB	'F - MORROW MD3',CR,LF
	DB	'			'
	DB	'G - PMC-101 MicroMate (Type "A")',CR,LF
	DB	'			'
	DB	'H - SANYO MBC 1000/1100',CR,LF
	DB	'			'
	DB	'I - TELEVIDEO 802/803',CR
	DB	LF,LF
	DB	'		       <ESC> - Return to Main Menu',CR,LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	'Select a format or <ESC> to Main Menu: $'
	;
	;the 96 tpi menu follows...
	;
TPI96:	DB	CR,LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF,'	         '
	DB	'These formats require a 96 tpi drive.'
	DB	CR,LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	'		               96 TPI MENU'
	DB	CR,LF
	DB	'			       -- --- ----',CR,LF
	DB	LF
	DB	'			'
	DB	'A - DEC RAINBOW (CP/M)',CR,LF
	DB	'			'
	DB	'B - EAGLE IIE-2 SSDD',CR,LF
	DB	'			'
	DB	'C - HEATH/ZENITH 89 SSDD',CR,LF
	DB	'			'
	DB	'D - HEATH/ZENITH 89 DSDD',CR,LF
	DB	'			'
	DB	'E - HEATH/ZENITH 89 SSXD',CR,LF
	DB	'			'
	DB	'F - HEATH/ZENITH 89 DSXD',CR,LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	' 		       <ESC> - Return to Main Menu',CR,LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF
	DB	'Select a format or <ESC> to Main Menu: $'
	;
	;ending message...
	;
SGNOFF:	DB	CR,LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF,'Drive B is now a$'
ENDIT:	DB	CR,LF,'drive when you call it "E".',CR,LF,'$'
	;
PRINT:	CALL	OUTPUT		;print it
	LXI	D,ENDIT		;set up end routine
PRINT1:	CALL	OUTPUT		;
	JMP	0		;done
	;
	;wrgdrv loads the wrong drive error message, prints
	;it and exits to cp/m. 
	;
WRGDRV:	LXI	D,ERROR		;load error message
	CALL	OUTPUT		;bdos
DONE:	LHLD	OLDSP		;get stack back
	SPHL			;put it in sp
	RET			;return to zcpr3
	;
ERROR:	DB	7,CR,LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF,'Wrong drive selected.',CR,LF
	DB	'MULTIDSK can only be run from drive A, B, C, or D.'
	DB	CR,LF
	DB	0,0,0,0,0,0,0,0,0,0
	DB	LF,'$'
	;
askd:	lda	cl4896
	cpi	'Y'
	jz	setdst
	cpi	'y'
	jz	setdst
	cpi	'N'
	jz	loop2
	cpi	'n'
	jz	loop2
	push	b
	push	d
	push	h
	lxi	d,dsmsg
	call	output
	pop	h
	pop	d
	pop	b
askd2x
	push	b
	push	d
	push	h
	call	conin
	pop	h
	pop	d
	pop	b
	cpi	esc
	jz	done
	cpi	etx
	jz	done
	ani	05fh
	cpi	'Y'
	jz	setdst
	cpi	'N'
	jz	loop2
	jmp	askd2x
setdst:
	push	h
	lhld	1
	mvi	l,74h
	mov	a,m
	ori	40h
	mov	m,a
	pop	h
	jmp	loop2

dsmsg:	DB	CR,LF,'Is the E-drive a 96tpi drive (Y/N)? ','$'
	;
	;loop moves the type byte, dpb, drive,and
	;skew table to the location in the bios pointed to
	;by the hl registers. the bytes to be moved are pointed
	;to by the de registers and b contains the number
	;of bytes to be moved.
	;  
LOOP:
	nop
	nop
	nop
	lda	type
	cpi	'1'
	jz	askd
	cpi	'2'
	jz	askd
LOOP2:	LDAX	D		;put 1st byte into a
	MOV	M,A		;store it in bios
	INX	D		;roll up d
	INX	H		;roll up h
	DCR	B		;decrement b
	JNZ	LOOP2		;loop until done
	LXI	D,SGNOFF	;
	CALL	OUTPUT		;print it
	RET
	;
	;the following tables contain the type byte, dpb, drive
	;selected, and skew for the different formats
	;which can be read/write. 
	;
KAY2:   LDA	DRIVE		;get drive pointer back
	STA	K2DPB+16	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,27		;number of bytes to move (1+15+1+10)
	LXI	D,K2DPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,K2END 	;point to end message
	JMP	PRINT		;
	;
K2DPB: ;type byte
	DB	082H		;kaypro ii ssdd
	;dpb
	DW	40		;spt
	DB	3		;block shift
	DB	7		;block mask
	DB	0		;extent mask
	DW	0C2H		;disk size-1
	DW	63		;# of directories-1
	DB	0F0H		;allocation 0
	DB	0		;allocation 1
	DW	16		;dir check size
	DW	1		;reserved tracks
	;drive
	DB	1		;drive selected
	;skew table
	DB	0,1,2,3,4,5,6,7,8,9
	;
K2END:	DB	' KAYPRO II$' 
	;
SAN:    LDA	DRIVE		;get drive pointer back
	STA	SANDPB+16	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,33		;number of bytes to move (1+15+1+16)
	LXI	D,SANDPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,SANEND 	;point to end message
	JMP	PRINT		;
	;
SANDPB: ;type byte
	DB	0C5H		;sanyo dsdd
	;dpb
	DW	32		;spt
	DB	4		;block shift
	DB	15		;block mask
	DB	1		;extent mask
	DW	9BH		;disk size-1
	DW	63		;# of directories-1
	DB	80H		;allocation 0
	DB	0		;allocation 1
	DW	16		;dir check size
	DW	2		;reserved tracks
	;drive
	DB	1		;drive selected
	;skew table
	DB	1,4,7,10,13,16,3,6,9,12,15,2,5,8,11,14
	;
SANEND:	DB	' SANYO MBC 1000/1100$' 
	;
TEL:    LDA	DRIVE		;get drive pointer back
	STA	TELDPB+16	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,35		;number of bytes to move (1+15+1+18)
	LXI	D,TELDPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,TELEND 	;point to end message
	JMP	PRINT		;
	;
TELDPB: ;type byte
	DB	0C5H		;televideo dsdd
	;dpb
	DW	36		;spt
	DB	4		;block shift
	DB	15		;block mask
	DB	0		;extent mask
	DW	0AAH		;disk size-1
	DW	63		;# of directories-1
	DB	80H		;allocation 0
	DB	0		;allocation 1
	DW	16		;dir check size
	DW	4		;reserved tracks
	;drive
	DB	1		;drive selected
	;skew table
	DB	1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18
	;
TELEND:	DB	' TELEVIDEO 802/803$'
	;
PMC:    LDA	DRIVE		;get drive pointer back
	STA	PMCDPB+16	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,22		;number of bytes to move (1+15+1+5)
	LXI	D,PMCDPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,PMCEND 	;point to end message
	JMP	PRINT		;
	;
PMCDPB: ;type byte
	DB	0C7H		;pmc type a dsdd
	;dpb
	DW	40		;spt
	DB	4		;block shift
	DB	15		;block mask
	DB	1		;extent mask
	DW	194		;disk size-1
	DW	127		;# of directories-1
	DB	192		;allocation 0
	DB	0		;allocation 1
	DW	32		;dir check size
	DW	2		;reserved tracks
	;drive
	DB	1		;drive selected
	;skew table
	DB	1,2,3,4,5
	;
PMCEND:	DB	' PMC-101 MicroMate (Type "A")$'
	;
DEC:    LDA	DRIVE		;get drive pointer back
	STA	DECDPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,26		;number of bytes to move (1+15+1+9)
	LXI	D,DECDPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,DECEND	;point to end message
	JMP	PRINT		;	
DECDPB: ;type byte
	DB	082H		;dec vt180 ssdd
	;dpb
	DW	36		;spt
	DB	3		;block shift
	DB	7		;block mask
	DB	0		;extent mask
	DW	0AAH		;disk size-1
	DW	63		;# of directories-1
	DB	0C0H		;allocation 0
	DB	0		;allocation 1
	DW	16		;dir check size
	DW	2		;reserved tracks
	;drive
	DB	1
	;skew table
	DB	1,3,5,7,9,2,4,6,8
	;
DECEND:	DB	' DEC VT180$'
	;
	;
DEC1:   LDA	DRIVE		;get drive pointer back
	STA	DEC1DPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,27		;number of bytes to move (1+15+1+10)
	LXI	D,DEC1DPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,DEC1END 	;point to end message
	JMP	PRINT		;
DEC1DPB: ;type byte
	DB	086H		;dec rainbow
	;dpb
	DW	40		;spt
	DB	4		;block shift
	DB	15		;block mask
	DB	1		;extent mask
	DW	0C2H		;disk size-1
	DW	127		;# of directories-1
	DB	0C0H		;allocation 0
	DB	0		;allocation 1
	DW	32		;dir check size
	DW	2		;reserved tracks
	;drive
	DB	1
	;skew table
	DB	1,3,5,7,9,2,4,6,8,10
	;
DEC1END: DB	' DEC RAINBOW SSDD 96tpi$'
	;
EGL:	LDA	DRIVE		;get drive pointer back
	STA	EGLDPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,22		;number of bytes to move (1+15+1+5)
	LXI	D,EGLDPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,EGLEND 	;point to end message
	JMP	PRINT		;
EGLDPB: ;type byte
	DB	087H		;eagle 2e-2 ss
	;dpb
	DW	40		;spt
	DB	4		;block shift
	DB	15		;block mask
	DB	1		;extent mask
	DW	0C2H		;disk size-1
	DW	191		;# of directories-1
	DB	0E0H		;allocation 0
	DB	0		;allocation 1
	DW	30H		;dir check size
	DW	2		;reserved tracks
	;drive
	DB	1
	;skew table
	DB	1,3,5,2,4
	;
EGLEND: DB	' EAGLE IIE-2 SSDD 96tpi$'
	;
ACT:	LDA	DRIVE		;get drive pointer back
	STA	ACTDPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,26		;number of bytes to move (1+15+1+9)
	LXI	D,ACTDPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,ACTEND 	;point to end message
	JMP	PRINT		;
ACTDPB: ;type byte
	DB	082H		;actrix (access)
	;dpb
	DW	36		;spt
	DB	3		;block shift
	DB	7		;block mask
	DB	0		;extent mask
	DW	0AAH		;disk size-1
	DW	63		;# of directories-1
	DB	0C0H		;allocation 0
	DB	0		;allocation 1
	DW	16		;dir check size
	DW	2		;reserved tracks
	;drive
	DB	1
	;skew table
	DB	1,4,7,2,5,8,3,6,9
	;
ACTEND: DB	'n ACTRIX (ACCESS) SSDD$'
	;
	;
KAY4:   LDA	DRIVE		;get drive pointer back
	STA	K4DPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,27		;number of bytes to move (1+15+1+10)
	LXI	D,K4DPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,K4END 	;point to end message
	JMP	PRINT		;
	;
K4DPB: ;type byte
	DB	0E6H		;kaypro 4/10 dsdd
	;dpb
	DW	40		;spt
	DB	4		;block shift
	DB	15		;block mask
	DB	1		;extent mask
	DW	(40*79)/16-1	;disk size-1
	DW	63		;# of directories-1
	DB	192		;allocation 0
	DB	0		;allocation 1
	DW	16		;dir check size
	DW	1		;reserved tracks
	;drive
	DB	1		;default b
	;skew table
	DB	0,1,2,3,4,5,6,7,8,9
	;
K4END:	DB	' KAYPRO 4/10 DSDD$'
	;
	;
H1:	LDA	DRIVE		;get drive pointer back
	STA	H1DPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,33		;number of bytes to move (1+15+1+16)
	LXI	D,H1DPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,H1END 	;point to end message
	JMP	PRINT		;
	;
H1DPB: ;type byte
	DB	081H		;heath/zenith ssdd
	;dpb
	DW	32		;spt
	DB	3		;block shift
	DB	7		;block mask
	DB	0		;extent mask
	DW	097H		;disk size-1
	DW	127		;# of directories-1
	DB	0F0H		;allocation 0
	DB	0		;allocation 1
	DW	32		;dir check size
	DW	2		;reserved tracks
	;drive
	DB	1		;default to b
	;skew table
	DB	1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16
	;
H1END:	DB	' HEATH/ZENITH 89 SSDD$'
	;
	;
H2:	LDA	DRIVE		;get drive pointer back
	STA	H2DPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,33		;number of bytes to move (1+15+1+16)
	LXI	D,H2DPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,H2END 	;point to end message
	JMP	PRINT		;
	;
H2DPB: ;type byte
	DB	0C5H		;heath/zenith dsdd
	;dpb
	DW	32		;spt
	DB	4		;block shift
	DB	15		;block mask
	DB	0		;extent mask
	DW	09BH		;disk size-1
	DW	0FFH		;# of directories-1
	DB	0F0H		;allocation 0
	DB	0		;allocation 1
	DW	040H		;dir check size
	DW	2		;reserved tracks
	;drive
	DB	1		;
	;skew table
	DB	1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16
	;
H2END:	DB	' HEATH/ZENITH 89 DSDD$'
	;
	;
H3:	LDA	DRIVE		;get drive pointer back
	STA	H3DPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,26		;number of bytes to move (1+15+1+9)
	LXI	D,H3DPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,H3END 	;point to end message
	JMP	PRINT		;
	;
H3DPB: ;type byte
	DB	086H		;heath w/magnolia ssdd
	;dpb
	DW	36		;spt
	DB	4		;block shift
	DB	15		;block mask
	DB	1		;extent mask
	DW	052H		;disk size-1
	DW	05FH		;# of directories-1
	DB	0C0H		;allocation 0
	DB	0		;allocation 1
	DW	018H		;dir check size
	DW	3		;reserved tracks
	;drive
	DB	1		;
	;skew table
	DB	1,2,3,4,5,6,7,8,9
	;
H3END:	DB	' HEATH w/MAGNOLIA SSDD$'
	;
	;
H4:	LDA	DRIVE		;get drive pointer back
	STA	H4DPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,22		;number of bytes to move (1+15+1+5)
	LXI	D,H4DPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,H4END 	;point to end message
	JMP	PRINT		;
	;
H4DPB: ;type byte
	DB	083H		;heath ssxd
	;dpb
	DW	40		;spt
	DB	3		;block shift
	DB	7		;block mask
	DB	0		;extent mask
	DW	0BDH		;disk size-1
	DW	07FH		;# of directories-1
	DB	0F0H		;allocation 0
	DB	0		;allocation 1
	DW	020H		;dir check size
	DW	2		;reserved tracks
	;drive
	DB	1		;
	;skew table
	DB	1,2,3,4,5
	;
H4END:	DB	' HEATH/ZENITH SS EXTENDED DENSITY$'
	;
	;
H5:	LDA	DRIVE		;get drive pointer back
	STA	H5DPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,22		;number of bytes to move (1+15+1+5)
	LXI	D,H5DPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,H5END 	;point to end message
	JMP	PRINT		;
	;
H5DPB: ;type byte
	DB	0C7H		;heath dsxd
	;dpb
	DW	40		;spt
	DB	4		;block shift
	DB	15		;block mask
	DB	0		;extent mask
	DW	0C2H		;disk size-1
	DW	255		;# of directories-1
	DB	0F0H		;allocation 0
	DB	0		;allocation 1
	DW	64		;dir check size
	DW	2		;reserved tracks
	;drive
	DB	1		;
	;skew table
	DB	1,2,3,4,5
	;
H5END:	DB	' HEATH/ZENITH DS EXTENDED DENSITY$'
	;
	;
H6:	LDA	DRIVE		;get drive pointer back
	STA	H6DPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,33		;number of bytes to move (1+15+1+16)
	LXI	D,H6DPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,H6END 	;point to end message
	JMP	PRINT		;
H6DPB: ;type byte
	DB	085H		;h/z 89 ssdd
	;dpb
	DW	32		;spt
	DB	4		;block shift
	DB	15		;block mask
	DB	1		;extent mask
	DW	09BH		;disk size-1
	DW	127		;# of directories-1
	DB	0C0H		;allocation 0
	DB	0		;allocation 1
	DW	32		;dir check size
	DW	2		;reserved tracks
	;drive
	DB	1
	;skew table
	DB	1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16
	;
	;
H6END: DB	' HEATH/ZENITH SSDD 96tpi$'
	;
H7:	LDA	DRIVE		;get drive pointer back
	STA	H7DPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,33		;number of bytes to move (1+15+1+16)
	LXI	D,H7DPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,H7END 	;point to end message
	JMP	PRINT		;
H7DPB: ;type byte
	DB	0C5H		;h/z 89 dsdd
	;dpb
	DW	32		;spt
	DB	4		;block shift
	DB	15		;block mask
	DB	0		;extent mask
	DW	013BH		;disk size-1
	DW	255		;# of directories-1
	DB	0F0H		;allocation 0
	DB	0		;allocation 1
	DW	64		;dir check size
	DW	2		;reserved tracks
	;drive
	DB	1
	;skew table
	DB	1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16
	;
H7END: DB	' HEATH/ZENITH DSDD 96tpi$'
	;
	;
H8:	LDA	DRIVE		;get drive pointer back
	STA	H8DPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,22		;number of bytes to move (1+15+1+5)
	LXI	D,H8DPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,H8END 	;point to end message
	JMP	PRINT		;
H8DPB:	;type byte
	DB	087H		;h/z 89 ssxd
	;dpb
	DW	40		;spt
	DB	4		;block shift
	DB	15		;block mask
	DB	1		;extent mask
	DW	0C2H		;disk size-1
	DW	127		;# of directories-1
	DB	0C0H		;allocation 0
	DB	0		;allocation 1
	DW	32		;dir check size
	DW	2		;reserved tracks
	;drive
	DB	1
	;skew table
	DB	1,2,3,4,5
	;
H8END: 	DB	' HEATH/ZENITH SSXD 96tpi$'
	;
H9:	LDA	DRIVE		;get drive pointer back
	STA	H9DPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,22		;number of bytes to move (1+15+1+5)
	LXI	D,H9DPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,H9END 	;point to end message
	JMP	PRINT		;
H9DPB: ;type byte
	DB	0C7H		;h/z 89 dsxd
	;dpb
	DW	40		;spt
	DB	4		;block shift
	DB	15		;block mask
	DB	0		;extent mask
	DW	395		;disk size-1
	DW	255		;# of directories-1
	DB	0F0H		;allocation 0
	DB	0		;allocation 1
	DW	64		;dir check size
	DW	2		;reserved tracks
	;drive
	DB	1
	;skew table
	DB	1,2,3,4,5
	;
H9END: DB	' HEATH/ZENITH DSXD 96tpi$'
	;
H10:	LDA	DRIVE		;get drive pointer back
	STA	H10DPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,25		;number of bytes to move (1+15+1+8)
	LXI	D,H10DPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,H10END 	;point to end message
	JMP	PRINT		;
H10DPB: ;type byte
	DB	82H		;h/z 100 ssdd
	;dpb
	DW	20H		;spt
	DB	3		;block shift
	DB	7		;block mask
	DB	0		;extent mask
	DW	97H		;disk size-1
	DW	127		;# of directories-1
	DB	0F0H		;allocation 0
	DB	0		;allocation 1
	DW	32		;dir check size
	DW	2		;reserved tracks
	;drive
	DB	1
	;skew table
	DB	1,2,3,4,5,6,7,8
	;
H10END: DB	' HEATH/ZENITH 100 SSDD$'
	;
H11:	LDA	DRIVE		;get drive pointer back
	STA	H11DPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,25		;number of bytes to move (1+15+1+8)
	LXI	D,H11DPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,H11END 	;point to end message
	JMP	PRINT		;
H11DPB: ;type byte
	DB	0C6H		;h/z 100 dsdd
	;dpb
	DW	20H		;spt
	DB	4		;block shift
	DB	15		;block mask
	DB	1		;extent mask
	DW	9BH		;disk size-1
	DW	255		;# of directories-1
	DB	0F0H		;allocation 0
	DB	0		;allocation 1
	DW	64		;dir check size
	DW	2		;reserved tracks
	;drive
	DB	1
	;skew table
	DB	1,2,3,4,5,6,7,8
	;
H11END: DB	' HEATH/ZENITH 100 DSDD$'
	;
H12:	LDA	DRIVE		;get drive pointer back
	STA	H12DPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,27		;number of bytes to move (1+15+1+10)
	LXI	D,H12DPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,H12END 	;point to end message
	JMP	PRINT		;
H12DPB: ;type byte
	DB	01H		;h/z 89 sssd
	;dpb
	DW	14H		;spt
	DB	3		;block shift
	DB	7		;block mask
	DB	0		;extent mask
	DW	5BH		;disk size-1
	DW	63		;# of directories-1
	DB	0C0H		;allocation 0
	DB	0		;allocation 1
	DW	16		;dir check size
	DW	3		;reserved tracks
	;drive
	DB	1
	;skew table
	DB	1,2,3,4,5,6,7,8,9,10
	;
H12END: DB	' HEATH/ZENITH 89 SSSD$'
	;
	;
NEC:	LDA	DRIVE		;get drive pointer back
	STA	NECDPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,33		;number of bytes to move (1+15+1+16)
	LXI	D,NECDPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,NECEND 	;point to end message
	JMP	PRINT		;
	;
NECDPB: ;type byte
	DB	081H		;nec pc8001a
	;dpb
	DW	32		;spt
	DB	3		;block shift
	DB	7		;block mask
	DB	0		;extent mask
	DW	097H		;disk size-1
	DW	03FH		;# of directories-1
	DB	0C0H		;allocation 0
	DB	0		;allocation 1
	DW	16		;dir check size
	DW	2		;reserved tracks
	;drive
	DB	1		;
	;skew table
	DB	1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16
	;
NECEND:	DB	' NEC PC8001A$'
	;
	;
IBMSS:	LDA	DRIVE		;get drive pointer back
	STA	IBMDPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,25		;number of bytes to move (1+15+1+8)
	LXI	D,IBMDPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,IBMEND 	;point to end message
	JMP	PRINT		;
	;
IBMDPB: ;type byte
	DB	082H		;ibm ssdd (cp/m 86)
	;dpb
	DW	32		;spt
	DB	3		;block shift
	DB	7		;block mask
	DB	0		;extent mask
	DW	09BH		;disk size-1
	DW	03FH		;# of directories-1
	DB	0C0H		;allocation 0
	DB	0		;allocation 1
	DW	16		;dir check size
	DW	1		;reserved tracks
	;drive
	DB	1
	;skew table
	DB	1,2,3,4,5,6,7,8
	;
IBMEND:	DB	'n IBM SSDD (CP/M 86)$'
	;
	;
TISS:	LDA	DRIVE		;get drive back
	STA	T1DPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,25		;number of bytes to move (1+15+1+8)
	LXI	D,T1DPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,T1END 	;point to end message
	JMP	PRINT		;
	;
T1DPB: ;type byte
	DB	082H		;ti pro ssdd (cp/m 86)
	;dpb
	DW	32		;spt
	DB	3		;block shift
	DB	7		;block mask
	DB	0		;extent mask
	DW	09BH		;disk size-1
	DW	03FH		;# of directories-1
	DB	0C0H		;allocation 0
	DB	0		;allocation 1
	DW	16		;dir check size
	DW	1		;reserved tracks
	;drive
	DB	1		;
	;skew table
	DB	1,2,3,4,5,6,7,8
	;
T1END:	DB	' TI Pro SSDD (CP/M 86)$'
	;
	;
XERDD:	LDA	DRIVE		;get drive back
	STA	XDDDPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,35		;number of bytes to move (1+15+1+18)
	LXI	D,XDDDPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,XDDEND 	;point to end message
	JMP	PRINT		;
	;
XDDDPB: ;type byte
	DB	081H		;xerox 820-ii ssdd 
	;dpb
	DW	34		;spt
	DB	3		;block shift
	DB	7		;block mask
	DB	0		;extent mask
	DW	09CH		;disk size-1
	DW	03FH		;# of directories-1
	DB	0C0H		;allocation 0
	DB	0		;allocation 1
	DW	16		;dir check size
	DW	3		;reserved tracks
	;drive
	DB	1		;
	;skew table
	DB	1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18
	;
XDDEND:	DB	' XEROX 820-II SSDD$'
	;
	;
XERSD:	LDA	DRIVE		;get drive back
	STA	XSDDPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,35		;number of bytes to move (1+15+1+18)
	LXI	D,XSDDPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,XSDEND 	;point to end message
	JMP	PRINT		;
	;
XSDDPB: ;type byte
	DB	0		;xerox 820-i sssd 
	;dpb
	DW	18		;spt
	DB	3		;block shift
	DB	7		;block mask
	DB	0		;extent mask
	DW	052H		;disk size-1
	DW	01FH		;# of directories-1
	DB	080H		;allocation 0
	DB	0		;allocation 1
	DW	8		;dir check size
	DW	3		;reserved tracks
	;drive
	DB	1		;
	;skew table
	DB	1,6,11,16,3,8,13,18,5,10,15,2,7,12,17,4,9,14
	;
XSDEND:	DB	' XEROX 820-I SSSD$'
	;
	;
TRS80:	LDA	DRIVE		;get drive back
	STA	TRSDPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,35		;number of bytes to move (1+15+1+18)
	LXI	D,TRSDPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,TRSEND 	;point to end message
	JMP	PRINT		;
	;
TRSDPB: ;type byte
	DB	0		;trs-80 1 w/ omikron sssd 
	;dpb
	DW	18		;spt
	DB	3		;block shift
	DB	7		;block mask
	DB	0		;extent mask
	DW	052H		;disk size-1
	DW	03FH		;# of directories-1
	DB	0C0H		;allocation 0
	DB	0		;allocation 1
	DW	16		;dir check size
	DW	3		;reserved tracks
	;drive
	DB	1		;
	;skew table
	DB	1,5,9,13,17,3,7,11,15,2,6,10,14,18,4,8,12,16
	;
TRSEND:	DB	' TRS80-1 w/OMIKRON SSSD$'
	;
	;
LOBO:	LDA	DRIVE		;get drive back
	STA	LSSDPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,35		;number of bytes to move (1+15+1+18)
	LXI	D,LSSDPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,LSSEND 	;point to end message
	JMP	PRINT		;
	;
LSSDPB:	;type byte
	DB	081H		;lobo max-80 ssdd 
	;dpb
	DW	36		;spt
	DB	3		;block shift
	DB	7		;block mask
	DB	0		;extent mask
	DW	0A5H		;disk size-1
	DW	03FH		;# of directories-1
	DB	0C0H		;allocation 0
	DB	0		;allocation 1
	DW	16		;dir check size
	DW	3		;reserved tracks
	;drive
	DB	1		;
	;skew table
	DB	0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17
	;
LSSEND:	DB	' LOBO MAX-80 SSDD$'
	;
	;
LOBO1:	LDA	DRIVE		;get drive back
	STA	LDSDPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,35		;number of bytes to move (1+15+1+18)
	LXI	D,LDSDPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,LDSEND 	;point to end message
	JMP	PRINT		;
	;
LDSDPB: ;type byte
	DB	0C5H		;lobo max-80 dsdd 
	;dpb
	DW	36		;spt
	DB	4		;block shift
	DB	15		;block mask
	DB	0		;extent mask
	DW	0ACH		;disk size-1
	DW	07FH		;# of directories-1
	DB	0C0H		;allocation 0
	DB	0		;allocation 1
	DW	32		;dir check size
	DW	3		;reserved tracks
	;drive
	DB	1		;
	;skew table
	DB	0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17
	;
LDSEND:	DB	' LOBO MAX-80 DSDD$'
	;
	;
MOR:	LDA	DRIVE		;get drive back
	STA	MSSDPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,22		;number of bytes to move (1+15+1+5)
	LXI	D,MSSDPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,MSSEND 	;point to end message
	JMP	PRINT		;
	;
MSSDPB: ;type byte
	DB	087H		;morrow md2 ssdd 
	;dpb
	DW	40		;spt
	DB	4		;block shift
	DB	15		;block mask
	DB	1		;extent mask
	DW	05EH		;disk size-1
	DW	07FH		;# of directories-1
	DB	0C0H		;allocation 0
	DB	0		;allocation 1
	DW	32		;dir check size
	DW	2		;reserved tracks
	;drive
	DB	1		;
	;skew table
	DB	1,4,2,5,3
	;
MSSEND:	DB	' MORROW MD2 SSDD$'
	;
	;
MOR1:	LDA	DRIVE		;get drive back
	STA	MDSDPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,22		;number of bytes to move (1+15+1+5)
	LXI	D,MDSDPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,MDSEND 	;point to end message
	JMP	PRINT		;
	;
MDSDPB: ;type byte
	DB	0C7H		;morrow md3 dsdd 
	;dpb
	DW	40		;spt
	DB	4		;block shift
	DB	15		;block mask
	DB	1		;extent mask
	DW	0C2H		;disk size-1
	DW	0BFH		;# of directories-1
	DB	0E0H		;allocation 0
	DB	0		;allocation 1
	DW	48		;dir check size
	DW	2		;reserved tracks
	;drive
	DB	1		;
	;skew table
	DB	1,4,2,5,3
	;
MDSEND:	DB	' MORROW MD3 DSDD$'
	;
	;
OSB:	LDA	DRIVE		;get drive back
	STA	OSBDPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,22		;number of bytes to move (1+15+1+5)
	LXI	D,OSBDPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,OSBEND 	;point to end message
	JMP	PRINT		;
	;
OSBDPB: ;type byte
	DB	083H		;osborne 2 ssdd 
	;dpb
	DW	40		;spt
	DB	3		;block shift
	DB	7		;block mask
	DB	0		;extent mask
	DW	0B8H		;disk size-1
	DW	03FH		;# of directories-1
	DB	0C0H		;allocation 0
	DB	0		;allocation 1
	DW	16		;dir check size
	DW	3		;reserved tracks
	;drive
	DB	1		;
	;skew table
	DB	1,2,3,4,5
	;
OSBEND:	DB	'n OSBORNE 2 SSDD$'
	;
OS1:	LDA	DRIVE		;get drive back
	STA	OS1DPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,27		;number of bytes to move (1+15+1+10)
	LXI	D,OS1DPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,OS1END 	;point to end message
	JMP	PRINT		;
	;
OS1DPB: ;type byte
	DB	05H		;osborne 1 sssd 
	;dpb
	DW	14H		;spt
	DB	4		;block shift
	DB	15		;block mask
	DB	1		;extent mask
	DW	2DH		;disk size-1
	DW	3FH		;# of directories-1
	DB	80H		;allocation 0
	DB	0		;allocation 1
	DW	16		;dir check size
	DW	3		;reserved tracks
	;drive
	DB	1		;
	;skew table
	DB	1,3,5,7,9,2,4,6,8,10
	;
OS1END:	DB	'n OSBORNE 1 SSSD$'
	;
	;
TRS3:	LDA	DRIVE		;get drive back
	STA	T3DPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,27		;number of bytes to move (1+15+1+10)
	LXI	D,T3DPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,T3END 	;point to end message
	JMP	PRINT		;
	;
T3DPB: ;type byte
	DB	86H		;trs80- w/memory merchant cp/m ssdd 
	;dpb
	DW	40		;spt
	DB	4		;block shift
	DB	15		;block mask
	DB	1		;extent mask
	DW	5EH		;disk size-1
	DW	7FH		;# of directories-1
	DB	0C0H		;allocation 0
	DB	0		;allocation 1
	DW	32		;dir check size
	DW	2		;reserved tracks
	;drive
	DB	1		;
	;skew table
	DB	1,2,3,4,5,6,7,8,9,10
	;
T3END:	DB	' TRS80-3 w/MEMORY MERCHANT CP/M SSDD$'
	;
TRS4:	LDA	DRIVE		;get drive back
	STA	T4DPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,35		;number of bytes to move (1+15+1+18)
	LXI	D,T4DPB 	;point to new dpb
	CALL	LOOP		;put into memory
	LXI	D,T4END 	;point to end message
	JMP	PRINT		;
	;
T4DPB: ;type byte
	DB	81H		;trs80-4 w/montezuma cp/m ssdd 
	;dpb
	DW	36		;spt
	DB	4		;block shift
	DB	15		;block mask
	DB	1		;extent mask
	DW	54H		;disk size-1
	DW	7FH		;# of directories-1
	DB	0C0H		;allocation 0
	DB	0		;allocation 1
	DW	32		;dir check size
	DW	2		;reserved tracks
	;drive
	DB	1		;
	;skew table
	DB	1,3,5,7,9,11,13,15,17,2,4,6,8,10,12,14,16,18
	;
T4END:	DB	' TRS80-4 w/MONTEZUMA CP/M SSDD$'

IBM3740:
	lhld	1		; set double speed bit
	mvi	l,74h
	mov	a,m
	ori	80h
	mov	m,a

	LDA	DRIVE		;get drive back
	STA	IBM3740DPB+16 	;store it
	LHLD	ADDR		;get bios pointer back
	MVI	B,43		;number of bytes to move (1+15+1+26)
	LXI	D,IBM3740DPB 	;point to new dpb
	CALL	LOOP2		;put into memory
	LXI	D,IBM3740END 	;point to end message
	JMP	PRINT		;
	;
IBM3740DPB:
		;type byte
	DB	00H		; IBM 3740
		;dpb
	DW	26		;spt
	DB	3		;block shift
	DB	7		;block mask
	DB	0		;extent mask
	DW	242		;disk size-1
	DW	63		;# of directories-1
	DB	192		;allocation 0
	DB	0		;allocation 1
	DW	16		;dir check size
	DW	2		;reserved tracks
	;drive
	DB	1		;
	;skew table
	DB	1,7,13,19,25,5,11,17,23,3,9,15,21
	DB	2,8,14,20,26,6,12,18,24,4,10,16,22
	;
IBM3740END:
	DB	' SSSD IBM 3740 8"$'
	;
	;
	DS	64		;32 level stack
STACK:	
;
OLDSP:	DS	2		;room for old stack pointer
	; 
	;
	;
	END	BEGIN
