/*
 *			C O M P L E X . H
 *
 *	Definitions for complex arithmetic routines
 *
 *  Authors -
 *	Douglas A Gwyn		(Original Version)
 *	Michael John Muuss
 *  
 *  Source -
 *	SECAD/VLD Computing Consortium, Bldg 394
 *	The U. S. Army Ballistic Research Laboratory
 *	Aberdeen Proving Ground, Maryland  21005
 *  
 *  Copyright Notice -
 *	This software is Copyright (C) 1985 by the United States Army.
 *	All rights reserved.
 *
 *  $Header: complex.h,v 3.0 86/06/10 01:31:33 mike Exp $
 */

/* "complex number" data type: */
typedef struct 	{
	double		re;		/* real part */
	double		im;		/* imaginary part */
}  complex;

/* functions that are efficiently done as macros: */

#define	CxCopy( ap, bp )	(&(*(ap) = *(bp)))
#define	CxNeg( cp )		CxScal( cp, (-1.0) )
#define	CxReal( cp )		(cp)->re
#define	CxImag( cp )		(cp)->im

#define CxAdd( ap, bp )		{ (ap)->re += (bp)->re; (ap)->im += (bp)->im;}
#define CxAmpl( cp )		hypot( (cp)->re, (cp)->im )
#define CxAmplSq( cp )		( (cp)->re * (cp)->re + (cp)->im * (cp)->im )
#define CxConj( cp )		{ (cp)->im = -(cp)->im; }
#define CxCons( cp, r, i )	{ (cp)->re = r; (cp)->im = i; }
#define CxPhas( cp )		atan2( (cp)->im, (cp)->re )
#define CxScal( cp, s )		{ (cp)->re *= (s); (cp)->im *= (s); }
#define CxSub( ap, bp )		{ (ap)->re -= (bp)->re; (ap)->im -= (bp)->im;}

#define CxMul( ap, bp )		{ LOCAL fastf_t a__re, b__re; \
				a__re = (ap)->re; b__re = (bp)->re; \
				(ap)->re = a__re*b__re - (ap)->im*(bp)->im; \
				(ap)->im = a__re*(bp)->im + (ap)->im*b__re; }


extern void	free();
extern char	*malloc();

/* library functions defined in complex.c */
extern void	CxDiv();
extern complex	*CxSqrt();
extern void	pr_roots();
