/*
	SCCS id:	@(#) fb.h	1.19
	Last edit: 	6/11/86 at 13:45:16
	Retrieved: 	6/11/86 at 13:45:31
	SCCS archive:	/vld/src/libfb/s.fb.h

			U. S. Army Ballistic Research Laboratory
			Aberdeen Proving Ground
			Maryland 21005-5066
*/
#define INCL_FB
struct pixel
	{
	unsigned char	red;
	unsigned char	green;
	unsigned char	blue;
	unsigned char	spare;
	};

struct color_map
	{
	unsigned char cm_red[256];
	unsigned char cm_green[256];
	unsigned char cm_blue[256];
	};

typedef	struct pixel		Pixel;
typedef	struct color_map	ColorMap;
#if defined(NULL)
#define PIXEL_NULL	(Pixel *) NULL
#endif

/* _fb_type values.							*/
#define	FB_FILE		0
#define	FB_IKONAS	1
#define FB_RASTER_TECH	2
#define FB_PTTY		3

/* Mode flags for fbopen().						*/
#define APPEND		0	/* Open existing file/device.		*/
#define CREATE		1	/* Create file if it doesn't exist.	*/

/* Default device name.							*/
#if defined( vax )
#define FB_DEFAULT	"/dev/ik0l"
#else
#define FB_DEFAULT	"/dev/rat0"
#endif

/* Globals beginning with '_' are not intended to be accessed directly.
	but may be for convenience or speed.
 */
extern Pixel		_fbbackground; /* Set by fbsetbackground().	*/
extern int		_fbsize;       /* Set by fbsetsize().		*/

/* These are set by fbopen().						*/
extern char		*_fbfile;      /* Actual device/file opened.	*/
extern int		_fbfd;
extern int		_fbtype;

/* For compatibility with old names.					*/
#define setbackground	fbsetbackground
#define setfbsize	fbsetsize
#define getfbtype	fbgettype
#define getfbsize	fbgetsize
