/*
 *  			I K L I B . C
 *  
 *  Author -
 *	Michael John Muuss	
 *	Paul R. Stay
 *
 *  Source -
 *	SECAD/VLD Computing Consortium, Bldg 394
 *	The U. S. Army Ballistic Research Laboratory
 *	Aberdeen Proving Ground, Maryland  21005
 *  
 *  Copyright Notice -
 *	This software is Copyright (C) 1985 by the United States Army.
 *	All rights reserved.
 */

int ikhires, ikfd;

#include <stdio.h>
#include <gl2/gl.h>
#include <gl2/device.h>

int ir_xres, ir_yres;
short ir_xpsize, ir_ypsize;
short ir_xoffset;
short ir_yoffset;

ikwpixel( x, y, r, g, b) 
int x,y;
int r, g,b;
{
	Colorindex pix;
	Coord rxl, ryb, rxr, ryt;

	pix = r & 0xE0;
	pix |= (g & 0xE0) >>3;
	pix |= (b & 0xC0) >>5;

	rxl = ir_xoffset + x * ir_xpsize;
	ryb = ir_yoffset + (ir_yres - y) * ir_ypsize;
	
	rxr = rxl + ir_xpsize;
	ryt = ryb + ir_ypsize;

#ifdef never
	fprintf(stderr, "rgb value = %d %d %d\n",r, g, b);
	fprintf(stderr, "pixel value = %d\n", pix);
	fprintf(stderr, "ir_psize = %d\n", ir_xpsize );
	fprintf(stderr, "ir_offset = %d\n", ir_offset );
	fprintf(stderr, "pixel rect = %d %d %d %d\n", (int)rxl, (int)ryb, (int)rxr, (int)ryt);
#endif

	color( pix);
	rectf( rxl, ryb, rxr, ryt );
}

ikopen() 
{
	ginit();
	singlebuffer();
	onemap();
	gconfig();
	ir_xres = 768;
	ir_yres = 768;
	ir_xpsize = 1;
	ir_ypsize = 1;
	color(BLACK);
	clear();
	load_map();
	ikfd = 99;
}

ikclear() 
{
	color(BLACK);
	clear();
}

ikzoom(dx, dy) 
{
	int res;

	if( ikhires )  res = 1024;
	else res=512;
	res = res/(dx+1);
	ir_xpsize = (768 / res);
	ir_ypsize = (768 / res);
	ir_xres = res;
	ir_yres = res;

	ir_xoffset = (768 - res * ir_xpsize) / 2;
	ir_yoffset = (768 - res * ir_ypsize) / 2;
printf("xsize=%d, xres=%d, xoffset=%d\n", ir_xpsize, ir_xres, ir_xoffset);
}

ikwindow() 
{
;
}

load_map() 	/* Load color map for 8 bit system */
{
	int i;

	/* Set up the 8 bit color map indexes */
	for(i = 0; i < 255; i++)  {
		mapcolor( i,
			(i>>5) * 36,
			((i>>2)&7) * 36,
			(i&3) * 85 );
	}
}

clustwrite(line,y,nlines)
register struct pixel {unsigned char pad, blue, green, red} *line;
int y, nlines;
{
	register int i;
	register Colorindex pix[1024];

	for(i=0; i<nlines; i++, line++){
		pix[i] = line->red & 0xE0;
		pix[i] |= (line->green & 0xE0) >>3;
		pix[i] |= (line->blue & 0xC0) >>5;
	}
	cmov2i(0, y);
	writepixels( nlines, pix);
}
