	/* pixops.h : macros for simple pixel operations, can be used
	 * either from gia2 or C.
	 *	M. Pique.
	 */
#ifdef vax
#ifdef DEBUG
long ik___pix;
#define putpixel(x,y,col) ik___pix=col,ikpwrite(&ik___pix,4,x,y)
#define getpixel(x,y,col) col=ikpread(&ik___pix,4,x,y),ik___pix
#else
#define putpixel(x,y,col) printf("putpix(%3d,%3d) color=%06x\n",x,y,col)
#define getpixel(x,y,col) printf("getpix(%3d,%3d)\n",x,y)
#endif vax
#else
/* a C style pixel write routine */
#define putpixel(x, y, s) { \
	reserve MDR, MAR; \
 \
	MDR = s; \
	MAR = ((x) | ((y) <<> 16)) << 1$ \
	lwrite mash; \
}
#define reputpixel(s) { \
	reserve MDR, MAR; \
 \
	MDR = (s) $ \
	/* This routine uses previous value of MAR, presumably from get/putpix*/ \
	/* It is only available on the BMP */ \
	lwrite mash; \
}
/* getpixel is a macro for reading a pixel from frame buffer memory */
#define getpixel(x, y, val) { \
	reserve MAR; 			/* protect the MAR */ \
	MAR = (HR (y)| (x)) << 1$ 	/* calculate the address */ \
	lread mash$ 			/* assert the bus function code and \
					   force a new instruction */ \
	val = BUS; 			/* gate the data off the bus into the \
					   result register */ \
	}
#define getputpixel(x,y, readval, writeval) { \
	/* Reads pixel into readval, then rewrites it from writeval */ \
	reserve MAR, MDR; \
	MAR = ((x) | ((y) <<> 16)) << 1$ \
	lread mash$ \
	readval = BUS; \
	MDR = writeval $ \
	lwrite mash; \
	}
#endif
