
; This routine expects a pointer to be  passed on the stack that points to
; a Turbo Basic integer.  The integer is assigned the value of the current
; logged drive.
;
;  STACK after saving BP
;
;    32 bit(segment offset) 
;    pointer to TB integer   <----- BP + 6
;    representing drive id  
;   Ĵ
;    return address that    
;    TB will go to after     <----- BP + 2
;    completion of routine  
;   Ĵ
;          saved BP	      <----- BP
;   			     
;   



DosCall  equ  21h	; equates for module
GetDrive equ  19h


program segment  ; begin program segment
  assume cs:program

  push  bp	; save bp
  mov   bp, sp
  push  es      ; save es because we'll use it for pointer manipulation

  les   di, [bp + 6h]	; load pointer to integer into es:di

  mov   ah, GetDrive
  int   DosCall
  cbw
  mov   es:[di], ax

  pop   es	; restore registers
  pop   bp

program ends	; end program segment

end

