
; This  routine expects two pointers to be passed on  the stack that point
; to Turbo Basic integers.   The integers will be assigned the segment and
; offset of the current DTA.
;
;  STACK after saving BP
;
;    32 bit(segment and offset) 
;    pointer to TB integer rep-  <----- BP + 0Ah
;    resenting segment of DTA	 
;   Ĵ
;    32 bit(segment and offset) 
;    pointer to TB integer rep-  <----- BP + 6
;    resenting offset of DTA	 
;   Ĵ
;      return address that TB	 
;      will go to after comple-  <----- BP + 2
;      tion of routine		 
;   Ĵ
;            saved BP		  <----- BP
;   				 
;   


DosCall  equ  21h	; equates for this module
GetDTA   equ  2Fh

program segment	; begin program segment
  assume cs:program

  push  bp      ; save bp
  mov   bp, sp
  push  es      ; save es because we'll use it for pointer manipulation
  push  ds      ; ditto

  ; call dos function to get current DTA's location
  mov   ah, GetDTA
  int   DosCall

  ; now get pointers to Turbo Basic integers and store segment and
  ; offset of DTA in them

  lds   di, [bp + 6h]	; load pointer to offset variable
  mov   ds:[di], bx	; mov offset of DTA into Turbo Basic integer

  lds   di, [bp + 0Ah]  ; load pointer to segment variable
  mov   ds:[di], es	; mov offset of DTA into Turbo Basic integer

  pop   ds
  pop   es	; restore registers
  pop   bp

program ends	; end program segment

end

