//---------------------------------------------------------------------------
// Toolbox bitmap resource IDs numbers.
//---------------------------------------------------------------------------
#define IDBMP_CTRLINFO		8000
#define IDBMP_CTRLINFODOWN	8001
#define IDBMP_CTRLINFOMONO	8003
#define IDBMP_CTRLINFOEGA 	8006

//---------------------------------------------------------------------------
// Change these for each new VBX file
//---------------------------------------------------------------------------
#define VBX_COMPANYNAME 	   "\0"
#define VBX_FILEDESCRIPTION	"Visual Basic Property Diagnostic Custom Control\0"
#define VBX_INTERNALNAME	   "CTRLINFO\0"
#define VBX_LEGALCOPYRIGHT	   "\0"
#define VBX_LEGALTRADEMARKS	"Microsoft\256 is a registered trademark of Microsoft Corporation. Visual Basic\231 is a trademark of Microsoft" 
#define VBX_ORIGINALFILENAME	"CTRLINFO.VBX\0"
#define VBX_PRODUCTNAME 	   "Microsoft\256 Visual Basic\231 for Windows\231\0"

//---------------------------------------------------------------------------
// Update these fields for each build.
//---------------------------------------------------------------------------
#define VBX_VERSION		    3,00,0,00
#define VBX_VERSION_STR 	"3.00.000\0"


#ifndef RC_INVOKED
//---------------------------------------------------------------------------
// Macro for referencing member of structure
//---------------------------------------------------------------------------
#define OFFSETIN(struc,field)	  ((USHORT)&(((struc *)0)->field))

//---------------------------------------------------------------------------
// CTRLINFO control data and structs
//---------------------------------------------------------------------------

typedef struct tagCTRLINFO
{
   HWND      hwndButton;
} CTRLINFO;

typedef CTRLINFO FAR * LPCTRLINFO;

#define LpCtrlInfoDEREF(hctl)	((LPCTRLINFO)VBDerefControl(hctl))


// ID's for Child Controls
enum
{
   ID_Button,
};

//---------------------------------------------------------------------------
// Control Procedure
//---------------------------------------------------------------------------
LONG FAR PASCAL _export CtrlInfoCtlProc(HCTL, HWND, USHORT, USHORT, LONG);


//---------------------------------------------------------------------------
// Define the consecutive indicies for the properties
//---------------------------------------------------------------------------
enum
{
   IPROP_CTRLINFO_CTLNAME,
   IPROP_CTRLINFO_INDEX,
   IPROP_CTRLINFO_LEFT,
   IPROP_CTRLINFO_TOP,
   IPROP_CTRLINFO_WIDTH,
   IPROP_CTRLINFO_HEIGHT,
   IPROP_CTRLINFO_VISIBLE,
   IPROP_CTRLINFO_PARENT,
   IPROP_CTRLINFO_DRAGMODE,
   IPROP_CTRLINFO_DRAGICON,
   IPROP_CTRLINFO_TAG,
   IPROP_CTRLINFO_HWND
};

PPROPINFO CtrlInfo_Properties[] =
{
    PPROPINFO_STD_CTLNAME,
    PPROPINFO_STD_INDEX,
    PPROPINFO_STD_LEFT,
    PPROPINFO_STD_TOP,
    PPROPINFO_STD_WIDTH,
    PPROPINFO_STD_HEIGHT,
    PPROPINFO_STD_VISIBLE,
    PPROPINFO_STD_PARENT,
    PPROPINFO_STD_DRAGMODE,
    PPROPINFO_STD_DRAGICON,
    PPROPINFO_STD_TAG,
    PPROPINFO_STD_HWND,
    NULL
};


//---------------------------------------------------------------------------
// Event list
//---------------------------------------------------------------------------

enum
{
   IEVENT_MOUSEMOVED,
   IEVENT_MOUSEDOWN,
};

PEVENTINFO CtrlInfo_Events[] =
{
   PEVENTINFO_STD_MOUSEMOVE,
   PEVENTINFO_STD_MOUSEDOWN,
   NULL		  
};


//---------------------------------------------------------------------------
// Model struct
//---------------------------------------------------------------------------
// Define the control model (using the event and property structures).
//---------------------------------------------------------------------------
MODEL modelCtrlInfo =
    {
    VB_VERSION, 			       // VB version being used
    MODEL_fLoadMsg,			    // MODEL flags
    (PCTLPROC)CtrlInfoCtlProc, // Control procedure
    0,	                      // Class style
    WS_VISIBLE,			       // Default Windows style
    sizeof(CTRLINFO),			 // Size of CTRLINFO structure
    IDBMP_CTRLINFO,			    // Palette bitmap ID
    "Ctrlinfo",   				 // Default control name
    "CTRLINFO",				    // Visual Basic class name
    NULL,				          // Parent class name
    CtrlInfo_Properties,		 // Property information table
    CtrlInfo_Events,			    // Event information table
    0,                         // Default property
    0/*IEVENT_...*/,           // Default event
    -1					          // Property representing value of ctl
    };

#endif	// RC_INVOKED



// 'Control' dialog box constants
#define   IDD_CTRL_DLG      101 
#define   IDD_HCTL         1001
#define   IDD_HWND         1002
#define   IDD_CLASS        1003
#define   IDD_PARENTCLASS  1004
#define   IDD_EXTRABYTES   1005
#define   IDD_PROCEDURE    1006
#define   IDD_VERSION      1007
#define   IDD_VBVERSION    1008
#define   IDD_FLAGS        1009
#define   IDD_PROPERTIES   1010
#define   IDD_SPY          1011
#define   IDD_HIDE         1012

// 'Properties' dialog boxes constants
#define   IDD_STANDARD_DLG  102
#define   IDD_CUSTOM_DLG    103
#define   IDD_VALUE_LABEL  1021
#define   IDD_NAME         1022
#define   IDD_ADDRESS      1023
#define   IDD_DATATYPE     1024
#define   IDD_VALUE        1025
#define   IDD_PROP_FLAGS   1026



//---------------------------------------------------------------------------
