C This is variation in the MatMult subroutine Do loops
C The loop variable i ranges from the current thread number to the
C maximum number of rows in A in steps of the maximum number of threads
C The loop variable j ranges across all the columns of B, but is 
C staggered according to the current thread number to minimize memory
C contention on an SMP machine. The loop variable jj translates (maps)
C the value of j to fall within the permissible range of B, that is
C from 1 to B_Columns

      Do i = CurrentThread, A_Rows,  MaxThreadCount
         Do j = (CurrentThread-1)*MaxThreadCount, 
     +           B_Columns + (CurrentThread-1)*MaxThreadCount - 1
            jj =  1 + mod(j, B_Columns)
            Do k = 1, A_Columns
               C(i, jj)  =  C(i, jj) + A(i, k) * B(k, jj)
            End Do
         End Do
      End Do
