/******************************************************************************
Module name: AniBtn.h
Written by: Jeffrey Richter
Notices: Copyright (c) 1995 Jeffrey Richter
Purpose: AniBtn superclass child control header file
******************************************************************************/


///////////////////////////////// Class Name //////////////////////////////////


#define WC_ANIBTNA  "AniBtn"
#define WC_ANIBTNW L"AniBtn"

#ifdef UNICODE
#define WC_ANIBTN WC_ANIBTNW
#else
#define WC_ANIBTN WC_ANIBTNA
#endif


///////////////////////////// Class Registration //////////////////////////////


// Register and unregister the AniBtn window class.
ATOM WINAPI AniBtn_RegisterClass (HINSTANCE hinst, BOOL fGlobalClass);
BOOL WINAPI AniBtn_UnregisterClass (HINSTANCE hinst);


//////////////////////// Class-Specific Window Styles /////////////////////////


// NOTE: Superclassed classes cannot have any class-specific window styles.


////////////////////////// Parent Notification Codes //////////////////////////


// AniBtn controls have no class-specific notification codes at this time.


/////////////////////// Class-Specific Window Messages ////////////////////////


// NOTE: We must select a value for ABM_FIRSTMSG that is guaranteed not to
// conflict with other messages.  If the application defines other WM_APP
// messages, the following line will have to change.  Similarly, if the 
// application uses other superclasses or subclasses, their message ranges
// must not overlap!
#define ABM_FIRSTMSG    (WM_APP + 0)

//{{adgMSGCRACK_MESSAGES

// Purpose: Sets the timer interval between image changes.
// wParam:  int nTimeout - New timer interval in milliseconds
// lParam:  N/A
// Returns: void
#define ABM_SETTIMER         (ABM_FIRSTMSG + 0)

// Purpose: Gets the timer interval between image changes.
// wParam:  N/A
// lParam:  N/A
// Returns: int - Current timer interval in milliseconds
#define ABM_GETTIMER         (ABM_FIRSTMSG + 1)

// Purpose: Sets the imagelist that contains the set of images.
// wParam:  HIMAGELIST himl - New imagelist containing images
// lParam:  N/A
// Returns: void
#define ABM_SETIMAGELIST     (ABM_FIRSTMSG + 2)

// Purpose: Gets the imagelist that contains the set of images.
// wParam:  N/A
// lParam:  N/A
// Returns: HIMAGELIST - Current imagelist containing images
#define ABM_GETIMAGELIST     (ABM_FIRSTMSG + 3)

//}}adgMSGCRACK_MESSAGES


//////////////////////////////// Message APIs /////////////////////////////////


//{{adgMSGCRACK_APIS

#define AniBtn_SetTimer(hwnd, nTimeout) \
   ((void)SendMessage((hwnd), ABM_SETTIMER, (WPARAM)(DWORD)(nTimeout), 0))

#define AniBtn_GetTimer(hwnd) \
   ((int )SendMessage((hwnd), ABM_GETTIMER, 0, 0))

#define AniBtn_SetImageList(hwnd, himl) \
   ((void)SendMessage((hwnd), ABM_SETIMAGELIST, (WPARAM)(DWORD)(himl), 0))

#define AniBtn_GetImageList(hwnd) \
   ((HIMAGELIST )SendMessage((hwnd), ABM_GETIMAGELIST, 0, 0))

//}}adgMSGCRACK_APIS


////////////////////////////// Message Crackers ///////////////////////////////


// The following message crackers are available for use in subclassing and
// superclassing the AniBtn control.

//{{adgMSGCRACK_CRACKERS

// void Cls_OnSetTimer (HWND hwnd, int nTimeout)
#define HANDLE_ABM_SETTIMER(hwnd, wParam, lParam, fn) \
   ((fn)((hwnd), (int)(wParam)), 0)
#define FORWARD_ABM_SETTIMER(hwnd, nTimeout, fn) \
   (void)((fn)((hwnd), ABM_SETTIMER, (WPARAM)(DWORD)(nTimeout), 0))

// int  Cls_OnGetTimer (HWND hwnd)
#define HANDLE_ABM_GETTIMER(hwnd, wParam, lParam, fn) \
   (LRESULT)(fn)((hwnd))
#define FORWARD_ABM_GETTIMER(hwnd, fn) \
   (int )((fn)((hwnd), ABM_GETTIMER, 0, 0))

// void Cls_OnSetImageList (HWND hwnd, HIMAGELIST himl)
#define HANDLE_ABM_SETIMAGELIST(hwnd, wParam, lParam, fn) \
   ((fn)((hwnd), (HIMAGELIST)(wParam)), 0)
#define FORWARD_ABM_SETIMAGELIST(hwnd, himl, fn) \
   (void)((fn)((hwnd), ABM_SETIMAGELIST, (WPARAM)(DWORD)(himl), 0))

// HIMAGELIST  Cls_OnGetImageList (HWND hwnd)
#define HANDLE_ABM_GETIMAGELIST(hwnd, wParam, lParam, fn) \
   (LRESULT)(fn)((hwnd))
#define FORWARD_ABM_GETIMAGELIST(hwnd, fn) \
   (HIMAGELIST )((fn)((hwnd), ABM_GETIMAGELIST, 0, 0))

//}}adgMSGCRACK_CRACKERS


///////////////////////////////// End of File /////////////////////////////////
