/******************************************************************************
Module name: Arcade.c
Written by: Jeffrey Richter
Notices: Copyright (c) 1995 Jeffrey Richter
Purpose: AniBtn superclass child control implementation file.
******************************************************************************/

#include "..\Win95ADG.h"          /* See Appendix A for details */
#include <Windows.h>
#include <Windowsx.h>
#pragma warning(disable: 4001)    /* Single- line comment */
#include <commctrl.h>
#include <stdarg.h>
#include "AniBtn.h"
#include "resource.h"


///////////////////////////////////////////////////////////////////////////////


HIMAGELIST Arcade_MakeImageList (HINSTANCE hinstRes, int idi, ...) {

   va_list args;
   HIMAGELIST himl = ImageList_Create(
      GetSystemMetrics(SM_CXICON), GetSystemMetrics(SM_CYICON), 
      ILC_MASK, 5, 5);
   adgASSERT(himl != NULL);

   va_start(args, idi);
   while (idi != 0) {
      ImageList_AddIcon(himl, LoadIcon(hinstRes, MAKEINTRESOURCE(idi)));
      idi = va_arg(args, int);
   }
   va_end(args);
   return(himl);
}

///////////////////////////////////////////////////////////////////////////////

       
BOOL Arcade_OnInitDialog (HWND hwnd, HWND hwndFocus, LPARAM lParam) {

   // Create and set the imagelists for both buttons. 
   // NOTE: When an AniBtn is destroyed, it destroys the imagelist.
   HINSTANCE hinstRes = GetWindowInstance(hwnd);
   HIMAGELIST himl;

   // Initialize the Pong AniBtn.
   himl = Arcade_MakeImageList(hinstRes, IDI_PONG1, IDI_PONG2, 
      IDI_PONG3, IDI_PONG4, IDI_PONG5, IDI_PONG6, 0);
   adgASSERT(himl != NULL);
   AniBtn_SetImageList(GetDlgItem(hwnd, IDC_PONG), himl);
   AniBtn_SetTimer(GetDlgItem(hwnd, IDC_PONG), 250);

   // Initialize the Tetris AniBtn.
   himl = Arcade_MakeImageList(hinstRes, IDI_TETRIS1, IDI_TETRIS2, 
      IDI_TETRIS3, IDI_TETRIS4, IDI_TETRIS5, IDI_TETRIS6, IDI_TETRIS7, 0);
   adgASSERT(himl != NULL);
   AniBtn_SetImageList(GetDlgItem(hwnd, IDC_TETRIS), himl);
   AniBtn_SetTimer(GetDlgItem(hwnd, IDC_TETRIS), 500);

   adgSETDLGICONS(hwnd, IDI_ARCADE, IDI_ARCADE);

   return(TRUE);  // Accepts default focus window.
}


///////////////////////////////////////////////////////////////////////////////


void Arcade_OnCommand (HWND hwnd, int id, HWND hwndCtl, UINT codeNotify) {

   switch (id) {

      case IDCANCEL:              // Allows dialog box to close.
         EndDialog(hwnd, id);
         break;

      case IDC_PONG:
         adgMB(__TEXT("Imagine Pong running here."));
         break;

      case IDC_TETRIS:
         adgMB(__TEXT("Imagine Tetris running here."));
         break;
   }
}


///////////////////////////////////////////////////////////////////////////////


BOOL WINAPI Arcade_DlgProc (HWND hwnd, UINT uMsg, 
   WPARAM wParam, LPARAM lParam) {

   switch (uMsg) {
      // Standard Window's messages
      adgHANDLE_DLGMSG(hwnd, WM_INITDIALOG, Arcade_OnInitDialog);
      adgHANDLE_DLGMSG(hwnd, WM_COMMAND, Arcade_OnCommand);
   }
   return(FALSE);
}



///////////////////////////////////////////////////////////////////////////////


int WINAPI WinMain (HINSTANCE hinstExe, HINSTANCE hinstPrev, 
   LPSTR lpszCmdLine, int nCmdShow) {


#ifndef WINDOWSNT_COMPATIBILITY
   OSVERSIONINFO VerInfo;
   adgINITSTRUCT(VerInfo, TRUE);
   GetVersionEx(&VerInfo);
   if ((VerInfo.dwPlatformId == VER_PLATFORM_WIN32_NT) && 
       (VerInfo.dwMajorVersion <= 3 && VerInfo.dwMinorVersion <= 51)) {
      adgMB(__TEXT("This program may not run properly on Windows NT because ")
         __TEXT("it requires that the BS_BITMAP style be supported by the ")
         __TEXT("Windows' Button class."));
   }
#endif

   adgWARNIFUNICODEUNDERWIN95();

   // Register the AniBtn control class.
   if (AniBtn_RegisterClass(hinstExe, FALSE) != INVALID_ATOM) {

      adgVERIFY(-1 != DialogBox(hinstExe, 
         MAKEINTRESOURCE(IDD_ARCADE), NULL, Arcade_DlgProc));

      // Unregister window classes.
      AniBtn_UnregisterClass(hinstExe);
   }
   return(0);
}


//////////////////////////////// End of File //////////////////////////////////
