/******************************************************************************
Module name: SuperCls.h
Written by: Jeffrey Richter
Notices: Copyright (c) 1995 Jeffrey Richter
Purpose: Utility functions to help with window superclassing
******************************************************************************/


// Function that registers a superclass
ATOM WINAPI SuperCls_RegisterClassEx (
   PWNDCLASSEX pwc,              // lpfnWndClass member is base class WndProc.
   WNDPROC pfnWndProcSuperCls,   // Address of superclass WndProc function
   int cbClsAdditional,          // # of class extra bytes for superclass
   int cbWndAdditional);         // # of window extra bytes for superclass


// Function to retrieve the WndProc address of the base class
WNDPROC WINAPI SuperCls_GetWndProcBaseCls (HWND hwnd);


// Functions to manipulate a superclass's class extra bytes without affecting
// the base class's class extra bytes
WORD  WINAPI SuperCls_SetClassWord (HWND hwnd, int nIndex, WORD wNewWord);
WORD  WINAPI SuperCls_GetClassWord (HWND hwnd, int nIndex);
DWORD WINAPI SuperCls_SetClassLong (HWND hwnd, int nIndex, DWORD dwNewLong);
DWORD WINAPI SuperCls_GetClassLong (HWND hwnd, int nIndex);


// Functions to manipulate a superclass's window extra bytes without affecting
// the base class's window extra bytes.
WORD  WINAPI SuperCls_SetWindowWord (HWND hwnd, int nIndex, WORD wNewWord);
WORD  WINAPI SuperCls_GetWindowWord (HWND hwnd, int nIndex);
DWORD WINAPI SuperCls_SetWindowLong (HWND hwnd, int nIndex, DWORD dwNewLong);
DWORD WINAPI SuperCls_GetWindowLong (HWND hwnd, int nIndex);


//////////////////////////////// End of File //////////////////////////////////
