(* ----------------------------------------------------------- *(
**  combine.pas -- Combination Random Number Generator         **
** ----------------------------------------------------------- **
**  Combines Algorithm #16 (Linear Congruential Random Number  **
**  Generator) with Algorithm #17 (Fibonaccii Random Number    **
**  Generator) to create a table-driven combination generator. **
** ----------------------------------------------------------- **
**     Copyright (c) 1993 by Tom Swan. All rights reserved.    **
)* ----------------------------------------------------------- *)

program Combine;

const
  m4 = 10000;       { 10 ^^ 4 }
  m8 = 100000000;   { 10 ^^ 8 }
  b  = 31415621;    { constant multiplier }
  maxIndex = 100;   { array of Values }

var
  List: array[1 .. 17] of WORD;
  Values: array[1 .. maxIndex] of LongInt;
  I, J: Integer;
  Seed: LongInt;

function LongMult(p, q: LongInt): LongInt;
var
  p1, p0, q1, q0: LongInt;
begin
  p1 := p div m4;
  p0 := p mod m4;
  q1 := q div m4;
  q0 := q mod m4;
  LongMult := 
    (((p0 * q1 + p1 * q0) mod m4) * m4 + p0 * q0) mod m8
end;

function LinearRandomInt: LongInt;
begin
  Seed := (LongMult(Seed, b) + 1) mod m8;
  LinearRandomInt := Seed
end;

procedure RandomInit(StartingSeed: LongInt);
var
  N: Integer;
begin
  Seed := StartingSeed;
  List[17] := 1;
  List[16] := 2;
  for N := 15 downto 1 do
    List[N] := List[N+1] + List[N+2];
  I := 17;
  J := 5;
  for N := 1 to maxIndex do
    Values[N] := LinearRandomInt
end;

function FiboRandomInt: WORD;
var
  K: WORD;
begin
  K := List[I] + List[J];
  List[I] := K;
  I := I - 1;
  J := J - 1;
  if I = 0 then I := 17;
  if J = 0 then J := 17;
  FiboRandomInt := K
end;

function RandomRange(R: LongInt): LongInt;
var
  V: Integer;
begin
  V := 1 + (FiboRandomInt mod 100);
  RandomRange := ((Values[V] div m4) * R) div m4;
  Values[V] := LinearRandomInt
end;

var
  N: Integer;

begin
  Writeln;
  Writeln('Combination Random Number Generator');
  Writeln;
  RandomInit(7654321);
  for N := 1 to 1000 do
    Write(RandomRange(65536):10)
end.


(*
// --------------------------------------------------------------
// Copyright (c) 1993 by Tom Swan. All rights reserved
// Revision 1.00    Date: 10/04/1993   Time: 10:10 am
*)

