(* ----------------------------------------------------------- *(
**  linear.pas -- Linear Congruential Random Number Generator  **
** ----------------------------------------------------------- **
**                                                             **
** ----------------------------------------------------------- **
**     Copyright (c) 1993 by Tom Swan. All rights reserved.    **
)* ----------------------------------------------------------- *)

program Linear;

const
  m4 = 10000;       { 10 ^^ 4 }
  m8 = 100000000;   { 10 ^^ 8 }
  b  = 31415621;    { constant multiplier }

var
  Seed: LongInt;
  I: Integer;

function LongMult(p, q: LongInt): LongInt;
var
  p1, p0, q1, q0: LongInt;
begin
  p1 := p div m4;
  p0 := p mod m4;
  q1 := q div m4;
  q0 := q mod m4;
  LongMult := 
    (((p0 * q1 + p1 * q0) mod m4) * m4 + p0 * q0) mod m8
end;

procedure RandomInit(StartingSeed: LongInt);
begin
  Seed := StartingSeed
end;

function RandomInt: LongInt;
begin
  Seed := (LongMult(Seed, b) + 1) mod m8;
  RandomInt := Seed
end;

function RandomRange(R: LongInt): LongInt;
begin
  RandomRange := ((RandomInt div m4) * R) div m4
end;

begin
  Writeln;
  Writeln('Linear Congruential Random Number Generator');
  Writeln;
  RandomInit(1234567);
  for I := 1 to 32 do
    Write(RandomInt:10);
  Writeln;
  for I := 1 to 32 do
    Write(RandomRange(32768):10);
end.


(*
// --------------------------------------------------------------
// Copyright (c) 1993 by Tom Swan. All rights reserved
// Revision 1.00    Date: 10/04/1993   Time: 04:56 pm
*)

