(* ----------------------------------------------------------- *(
**  longmult.pas -- Demonstrate 32-bit multiplication          **
**     Copyright (c) 1993 by Tom Swan. All rights reserved.    **
)* ----------------------------------------------------------- *)

program LongMultTest;
const
  m4 = 10000;      { 10 ^^ 4 }
  m8 = 100000000;  { 10 ^^ 8 }
var
  p, q, p1, p0, q1, q0: LongInt;
  low, mid, high: LongInt;
begin
  p := 12345678;   { First value }
  q := 87654321;   { Second value }
  p1 := p div m4;
  p0 := p mod m4;
  q1 := q div m4;
  q0 := q mod m4;
  low := 
    (((p0 * q1 + p1 * q0) mod m4) * m4 + p0 * q0) mod m8;
  mid := 
    (((p1 * q0 + p0 * q1) + 
    ((p0 * q0) div m4)) + 
    ((((p1 * q1)) mod m4) * m4)) mod m8;
  high :=
    ((((((p1 * q0 + p0 * q1) + 
    ((p0 * q0) div m4)) + 
    ((((p1 * q1)) mod m4) * m4)) div m4) + 
    ((((p1 * q1)) div m4) * m4))) mod m8;
  Writeln('low = ', low);
  Writeln('mid = ', mid);
  Writeln('high = ', high);
  Writeln;
  Writeln(p, ' * ', q, ' = ', high, low)
end.


(*
// --------------------------------------------------------------
// Copyright (c) 1993 by Tom Swan. All rights reserved
// Revision 1.00    Date: 10/07/1993   Time: 11:53 am
*)
