unit Trafform;

{ TRAFFIC.EXE : Track web traffic counts on a page-by-page basis.

  This is a 16-bit application that will run under Windows 3.1x, Win 95
  and Windows NT.  It has been tested extensively under Windows NT AS 3.5.

  ---

  Up & Running Info
  =================
  This program requires 2 components which can be downloaded at
  http://super.sonic.net/ann/delphi/cgicomp/detail.html

  TCGIEnvData (free, written by Ann Lynnworth )
  TCGIDB ($39 shareware from Ann )

  Usage: <img src="/cgi-win/traffic.exe">
  See cgicomp/index.html for sample usage.

  traffic.exe requires 2 DLLS on the server, to make the the .gif image:
  BMP2GIF.DLL which is available on website.ora.com (free)
  GIFUTIL.DLL which is also part of VBStats at O'Reilly.
    (both of these are in rdenny.zip at ftp.sonic.net)
  BIVBX11.DLL which ships with Delphi

  It also requires IDAPI installed on the server (on the Delphi CD)

  It also requires a BDE Alias named WebTrafficCounter, pointing to a
  directory which contains hit.db and hit.px.  This Paradox table
  (TableHit object) should be included in the .zip file you found
  this source code in!

  ---
  This program is Copyright  1995 Ann Lynnworth dba SynchroniciTech.
  Permission is hereby granted for any registered user of TCGIDB to
  freely copy and/or modify this program provided that these original
  credits are kept intact.

  Suggestions should be mailed to ann@sonic.net -- thank you.

  Release Notes:
  29 June 96: adjusted getTempIMGFilename so that it handles .bmp and
              .gif separately

  26 June 96: changed to convert URL to lower case, and to strip off
              server name in an attempt to condense hits on the "same"
              URL.  (For example, on Ann's NT server, there were 4
              server names that are equivalent -- super.sonic.net or
              www2.sonic.net, with and without the port 80 information.)

              Also added getTempGIFfilename so that there couldn't be
              multi-user collisions on c:\temp\counter.gif any more.

  19 June 95: changed to use PostMessage launching technique with
              application.run turned on; also added Expires: section in
              the Header to help in situations where this counter is
              used by more than one page in the same site.  Also
              reorganized the procedures for (hopefully) easier reading.

              It *seems* that if you move the form off-screen, e.g.
              top = 4000 and left = 4000, traffic.exe runs faster.
              I didn't save the project that way -- so that you'd
              be able to easily see the form at design time...

}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms,
  { Dialogs,  { showMessage }
  StdCtrls, ExtCtrls, Cgidb, Cgi, DB, DBTables;

const
  wm_Traffic = wm_User;

type
  TForm1 = class(TForm)
    DataSource1: TDataSource;
    TableHit: TTable;
    CGIEnvData1: TCGIEnvData;
    CGIDB: TCGIDB;
    Image: TImage;
    procedure FormCreate(Sender: TObject);
    function makegif : string;
    function getCount : string;
  private
    { Private declarations }
    procedure wmTraffic(var Msg: TMessage); message wm_Traffic;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ declaration of function inside BMP2GIF.DLL }
function BMPTOGIF(infile: PChar; outfile: PChar ): boolean; far; external 'BMP2GIF';

procedure TForm1.FormCreate(Sender: TObject);
begin
     with CGIEnvData1 do
     begin

       websiteINIfilename := paramstr(1);
       application.onException := cgiErrorHandler;
       application.processMessages;

     end;

  PostMessage(Handle, wm_Traffic, 0, 0);   { this takes us to wmTraffic below }
      { postMessage of a custom message only works if
        application.run; is included the .dpr file }

end;

function getFileSize( filename : string ) : longint;
var
  tmpFile : file of byte;
begin

  try
    assignfile( tmpFile, filename );
  except
    raise exception.create( 'error assigning FILE ' + filename );
  end;

  { these 2 lines might not be necessary }
  filemode := 0;
  reset( tmpFile );

  result := filesize( tmpFile );
  closeFile( tmpFile );

end;

procedure TForm1.wmTraffic(var Msg: TMessage);
var
  gifFile : integer;
  stdoutname : string;
  stdout : TFileStream;
  gifFilename : string;
  gifSize : longint;
  bufSize : word;
  gifbufSize : word;
  buf : pchar;
  gifbuf : pointer;
  count : longint;

begin

     buf := nil;
     gifbuf := nil;

     stdoutname := CGIEnvData1.SystemOutputFile^;

   { This is where we actually create the .gif image based on the
     count... }
   gifFilename := makegif;   { makegif looks for CGIReferer, which
                               could be cginotfound and therefore cause
                               writing to stdout! Therefore this call
                               must be before any other use of stdout. }

   if gifFilename = '' then
   begin
     CGIEnvData1.sendNoOp;
     closeApp( application );
   end;

   bufsize := 4096;
   gifsize := getFileSize( gifFilename );
   gifbufsize := word( gifsize + 1 ); { we know these are little files
                                        so we don't worry about word vs longint }

{ A Note about File I/O techniques ...
  * The fileOpen, fileWrite series of commands worked ok under Win HTTPD, but not
    WebSite with Win NT.
  * TFileStream.open command with fmOpen parameter worked in the same situations.
  * Only TFileStream.open with fmCreate OR fmOpen worked with WebSite under NT.
  * If anyone would like to tell me *why* this is true, please do.  I'm just glad
    I got it working.  -ann
}

       try
         { adding fmCreate seems to have done the trick for NT }
         stdout := TFileStream.create( stdoutname, fmCreate OR fmOpenWrite );
       except
         raise exception.create( 'failed to open stdout: ' + stdoutname );
         exit;
       end;

       try

         getmem( buf, bufsize );
         getmem( gifbuf, gifbufsize );

         strpcopy( buf, 'HTTP/1.0 200 OK' + #13#10 +
                  'Server: ' + CGIEnvData1.CGIServerSoftware^ + #13#10 +
                  'Date: ' + CGIEnvData1.webDate( now ) + #13#10 +
                  'Expires: ' + CGIEnvData1.webDate( now + (1/(24*120)) ) + #13#10 +  {in 30 seconds}
                  'Content-type: image/gif' + #13#10 + { absolutely required }
{                  'Content-Transfer-Encoding: 8bit' + #13#10 + { probably unnecessary }
                  'Content-length: ' + intToStr( gifSize ) + #13#10#13#10 );  { optional }

         try
           { send header info defined above }
           stdout.write( buf[0], strlen(buf) );  { from CWG.HLP }
         except
           freemem( buf, bufsize );
           freemem( gifbuf, gifbufsize );
           raise exception.create( 'write of buf failed' );
         end;

         { read the entire .gif file into memory }
         giffile := fileopen( gifFilename, fmOpenRead );
         fileRead( giffile, gifbuf^, gifsize );
         fileClose( giffile );

         { append the .gif image to stdout }
         try
           stdout.write( gifbuf^, gifsize );
         except
           freemem( buf, bufsize );
           freemem( gifbuf, gifbufsize );
           raise exception.create( 'write of gifbuf failed' );
         end;

       finally
         if gifbuf <> nil then
           freeMem( gifbuf, gifbufsize );
         if buf <> nil then
           freeMem( buf, bufsize );
         stdout.free;
       end;

  DeleteFile( gifFilename );   {delete the now useless gif file}
  application.processMessages;
  closeApp( application );     { see cgihelp.hlp file }

end;

{ getCount figures out the count and returns it as a string }
function TForm1.getCount : string;
var
  n : double;
  refer : string;
  x : byte;

begin

  result := '???';   { hopefully we'll have something better to say }

  refer := CGIEnvData1.CGIReferer^;  { get URL of page that launched us }
  if refer = cginotfound then
  begin
    result := 'N/A';                 { added 6/19/95 aml }
    CGIEnvData1.closeStdout;         { don't want error message keeping file open! }
    exit;
  end;

  refer := lowercase( refer );       { added 6/26/96 aml }
  x := pos( '//', refer );
  if x > 0 then
  begin
    { strip of http://super.sonic.net portion of referer }
    refer := copy( refer, x + 2, 60 );
    x := pos( '/', refer );
    if x > 0 then
      refer := copy( refer, x, 60 );
  end;

  { if URL ends in /, append index.html as document name }
  if refer[ length(refer) ] = '/' then
    refer := refer + 'index.html';

  with tableHit do
  begin
    open;
    edit;
    if NOT findKey( [ refer ] ) then
    begin
      insert;
      fields[0].asString := refer;   { key field, URL of page }
      fields[1].asFloat := 2.0;      { count # for next surfer }
      n := 1;
    end
    else
    begin
      edit;
      n := fieldByName( 'Count' ).asFloat;     { fields[1] is Count }
      fieldByName( 'Count' ).asFloat := n + 1;
    end;

    post;
    close;
  end;

  result := floatToStr( n );

end;

{ start with should be a single letter, such as 'g'
  ext better be a valid file extension such as .gif or .bmp ! }
function getTempIMGFilename( startWith : string; ext : string ) : string;
var
  p : array[0..255] of char;
  startWithP : array[0..255] of char;

begin

     { temp file should be in TEMP directory based on that DOS
       environment variable.  }
     strpcopy( startWithP, startWith );
     getTempFilename( '0', startWithP, 0, p );
     result := strpas( p );
     {deleteFile( strpas(p) );
     result := changeFileExt( strpas( p ), ext );}

end;

{ make gif generates a .bmp first, and then converts that to a .gif }
function TForm1.makegif : string;
var
  pict : TPicture;
  Bitmap: TBitmap;
  tmpfileBMP: ARRAY[0..255] of char;
  tmpfileBMPs : string;
  tmpfileGIF: ARRAY[0..255] of char;
  tmpfileGIFs : string;
  retval: boolean;   { anyone remember PAL for DOS? :)  }

begin

  pict := TPicture.create;
  image.picture := pict;

  bitmap := TBitmap.create;
  bitmap.height := 20;
  bitmap.width := 80;
  image.picture.bitmap := bitmap;

  try
    { here's the magic -- we use textOut to create a bitmap with the
      count value !! }
    image.picture.bitmap.canvas.textout( 2, 2, getCount );
  except
    raise exception.create( 'could not draw on canvas' );
  end;

  tmpFileBMPs := getTempIMGFilename( 'b', '.bmp' );  { changed 6/26/95 aml from hardcoded name }
  strpcopy( tmpFileBMP, tmpFileBMPs  );
  try
    { Delphi can save bitmaps, easily }
    image.picture.Bitmap.SaveToFile( tmpFileBMPs );
  except
    raise exception.create( 'could not save bitmap to file' );
  end;

  tmpFileGIFs := getTempIMGFilename( 'g', '.gif' );
  strpcopy( tmpFileGIF, tmpFileGIFs );
  retval := bmptogif(tmpfileBMP, tmpfileGIF); {convert to gif}
  DeleteFile(tmpFileBMPs);  {delete the now useless bmp file}

  bitmap.free;
  pict.free;

  if retval then
    result := tmpfileGIFs  {return the gif filename to caller}
  else
    result := '';

end;

end.
