/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	file;
include	symtab;
include	debug;

AddrS:	addrSizes;
DataS:	addrSizes;

disassemble:	public	(addr: unsigned, limit: unsigned) unsigned =
	{
	code:		ref byte;
	addrS:		addrSizes;
	dataS:		addrSizes;
	loc:		unsigned[32];
	sym:		ref symbol;
	instruction:	boolean;
	prefix:		boolean;

	AddrS = AS_DWORD;
	DataS = AS_DWORD;
	instruction = FALSE;
	prefix = FALSE;
	for	(;;){
		if	(addr >= RunHeader->codeLen){
			printf("Too large\n");
			return addr;
			}
		if	(instruction && addr >= limit)
			return addr;
		addrS = AS_DWORD;
		dataS = AS_DWORD;
		code = Code + addr;
		if	(!prefix){
			if	(isBreakPoint(addr))
				printf("*");
			else
				printf(" ");
			printf("%7x\t", addr);
			}
		addr++;
		instruction = TRUE;
		prefix = FALSE;
		switch	(*code){
		case	0x00:
		case	0x01:
		case	0x02:
		case	0x03:
		case	0x04:
		case	0x05:
			addr += arithmetic("add", *code, addr);
			break;

		case	0x06:	printf("push\tes\n");	break;
		case	0x07:	printf("pop\tes\n");	break;

		case	0x08:
		case	0x09:
		case	0x0a:
		case	0x0b:
		case	0x0c:
		case	0x0d:
			addr += arithmetic("or", *code, addr);
			break;

		case	0x0e:	printf("push\tcs\n");	break;

		case	0x0f:
			code++;
			addr++;
			switch	(*code){
			case	0x06:	printf("clts\n");	break;

			case	0x80:
			case	0x81:
			case	0x82:
			case	0x83:
			case	0x84:
			case	0x85:
			case	0x86:
			case	0x87:
			case	0x88:
			case	0x89:
			case	0x8a:
			case	0x8b:
			case	0x8c:
			case	0x8d:
			case	0x8e:
			case	0x8f:
				loc = * ref signed[32](code + 1);
				addr += 4;
				loc += addr;
				printf("%s\t%x\n", Jumps[*code & 0xf], loc);
				break;

			case	0xa0:	printf("push\tfs\n");	break;
			case	0xa1:	printf("pop\tfs\n");	break;

			case	0xa8:	printf("push\tgs\n");	break;
			case	0xa9:	printf("pop\tgs\n");	break;

			case	0xaf:
				printf("imul\t%S,", 
					regName((code[1] >> 3) & 0x7, DataS));
				addr += modRm(code + 1, DataS);
				printf("\n");
				break;

			case	0xb6:
				printf("movzx\t%S,",
					regName((code[1] >> 3) & 0x7, DataS));
				addr += modRm(code + 1, AS_BYTE);
				printf("\n");
				break;

			case	0xb7:
				printf("movzx\t%S,",
					regName((code[1] >> 3) & 0x7, DataS));
				addr += modRm(code + 1, AS_WORD);
				printf("\n");
				break;

			case	0xbe:
				printf("movsx\t%S,",
					regName((code[1] >> 3) & 0x7, DataS));
				addr += modRm(code + 1, AS_BYTE);
				printf("\n");
				break;

			case	0xbf:
				printf("movsx\t%S,",
					regName((code[1] >> 3) & 0x7, DataS));
				addr += modRm(code + 1, AS_WORD);
				printf("\n");
				break;

			default:
				printf("Unknown opcode %x:%x\n", code[-1], *code);
				return addr + 1;
				}
			break;

		case	0x10:
		case	0x11:
		case	0x12:
		case	0x13:
		case	0x14:
		case	0x15:
			addr += arithmetic("adc", *code, addr);
			break;

		case	0x16:	printf("push\tss\n");	break;
		case	0x17:	printf("pop\tss\n");	break;

		case	0x18:
		case	0x19:
		case	0x1a:
		case	0x1b:
		case	0x1c:
		case	0x1d:
			addr += arithmetic("sbb", *code, addr);
			break;

		case	0x1e:	printf("push\tds\n");	break;
		case	0x1f:	printf("pop\tds\n");	break;

		case	0x20:
		case	0x21:
		case	0x22:
		case	0x23:
		case	0x24:
		case	0x25:
			addr += arithmetic("and", *code, addr);
			break;

		case	0x26:
			printf("es:\n");
			instruction = FALSE;
			break;

		case	0x27:	printf("\tdaa\n");	break;

		case	0x28:
		case	0x29:
		case	0x2a:
		case	0x2b:
		case	0x2c:
		case	0x2d:
			addr += arithmetic("sub", *code, addr);
			break;

		case	0x2e:
			printf("cs:\n");
			instruction = FALSE;
			break;

		case	0x2f:	printf("\tdas\n");	break;

		case	0x30:
		case	0x31:
		case	0x32:
		case	0x33:
		case	0x34:
		case	0x35:
			addr += arithmetic("xor", *code, addr);
			break;

		case	0x36:
			printf("ss:\n");
			instruction = FALSE;
			break;

		case	0x37:	printf("\taaa\n");	break;

		case	0x38:
		case	0x39:
		case	0x3a:
		case	0x3b:
		case	0x3c:
		case	0x3d:
			addr += arithmetic("cmp", *code, addr);
			break;

		case	0x3e:
			printf("ds:\n");
			instruction = FALSE;
			break;

		case	0x3f:	printf("\taas\n");	break;

		case	0x40:
		case	0x41:
		case	0x42:
		case	0x43:
		case	0x44:
		case	0x45:
		case	0x46:
		case	0x47:
			printf("inc\t%S\n", regName(*code & 7, DataS));
			break;

		case	0x48:
		case	0x49:
		case	0x4a:
		case	0x4b:
		case	0x4c:
		case	0x4d:
		case	0x4e:
		case	0x4f:
			printf("dec\t%S\n", regName(*code & 7, DataS));
			break;

		case	0x50:
		case	0x51:
		case	0x52:
		case	0x53:
		case	0x54:
		case	0x55:
		case	0x56:
		case	0x57:
			printf("push\t%S\n", regName(*code & 7, DataS));
			break;

		case	0x58:
		case	0x59:
		case	0x5a:
		case	0x5b:
		case	0x5c:
		case	0x5d:
		case	0x5e:
		case	0x5f:
			printf("pop\t%S\n", regName(*code & 7, DataS));
			break;
		case	0x60:	printf("pusha\n");	break;
		case	0x61:	printf("popa\n");	break;

		case	0x64:
			printf("fs:\n");
			instruction = FALSE;
			break;

		case	0x65:
			printf("gs:\n");
			instruction = FALSE;
			break;

		case	0x66:				// data override
			addrS = AddrS;
			dataS = AS_WORD;
			instruction = FALSE;
			prefix = TRUE;
			break;

		case	0x67:				// address override
			addrS = AS_WORD;
			dataS = DataS;
			instruction = FALSE;
			prefix = TRUE;
			break;

		case	0x68:
			printf("push\t");
			addr += immediate(addr, DataS, TRUE);
			printf("\n");
			break;

		case	0x6a:
			printf("push\t");
			addr += immediate(addr, AS_BYTE, FALSE);
			printf("\n");
			break;

		case	0x70:
		case	0x71:
		case	0x72:
		case	0x73:
		case	0x74:
		case	0x75:
		case	0x76:
		case	0x77:
		case	0x78:
		case	0x79:
		case	0x7a:
		case	0x7b:
		case	0x7c:
		case	0x7d:
		case	0x7e:
		case	0x7f:
			loc = * ref signedByte(code + 1);
			addr++;
			loc += addr;
			printf("%s\t%x\n", Jumps[*code & 0xf], loc);
			break;

		case	0x80:
			printf("%s\t", Immediate[(code[1] >> 3) & 0x7]);
			addr += modRm(code + 1, AS_BYTE);
			printf(",");
			addr += immediate(addr, AS_BYTE, FALSE);
			printf("\n");
			break;

		case	0x81:
			printf("%s\t", Immediate[(code[1] >> 3) & 0x7]);
			addr += modRm(code + 1, DataS);
			printf(",");
			addr += immediate(addr, DataS, FALSE);
			printf("\n");
			break;

		case	0x83:
			printf("%s\t", Immediate[(code[1] >> 3) & 0x7]);
			addr += modRm(code + 1, DataS);
			printf(",");
			addr += immediate(addr, AS_BYTE, FALSE);
			printf("\n");
			break;

		case	0x86:
			printf("xchg\t%S,",
				regName((code[1] >> 3) & 0x7, AS_BYTE));
			addr += modRm(code + 1, AS_BYTE);
			printf("\n");
			break;

		case	0x87:
			printf("xchg\t%S,",
				regName((code[1] >> 3) & 0x7, DataS));
			addr += modRm(code + 1, DataS);
			printf("\n");
			break;

		case	0x88:
			printf("mov\t");
			addr += modRm(code + 1, AS_BYTE);
			printf(",%S\n", regName((code[1] >> 3) & 0x7, AS_BYTE));
			break;

		case	0x89:
			printf("mov\t");
			addr += modRm(code + 1, DataS);
			printf(",%S\n", regName((code[1] >> 3) & 0x7, DataS));
			break;

		case	0x8a:
			printf("mov\t%S,", 
				regName((code[1] >> 3) & 0x7, AS_BYTE));
			addr += modRm(code + 1, AS_BYTE);
			printf("\n");
			break;

		case	0x8b:
			printf("mov\t%S,",
				regName((code[1] >> 3) & 0x7, DataS));
			addr += modRm(code + 1, DataS);
			printf("\n");
			break;

		case	0x8c:
			printf("mov\t");
			addr += modRm(code + 1, AS_WORD);
			printf(",%s\n", segRegName((code[1] >> 3) & 0x7));
			break;

		case	0x8d:
			if	(code[1] == 0xc3){
				printf(".source error\n");
				addr++;
				break;
				}
			printf("lea\t%S,", 
				regName((code[1] >> 3) & 0x7, DataS));
			addr += modRm(code + 1, DataS);
			printf("\n");
			break;

		case	0x8e:
			printf("mov\t%s,", segRegName((code[1] >> 3) & 0x7));
			addr += modRm(code + 1, AS_WORD);
			printf("\n");
			break;

		case	0x90:	printf("nop\n");	break;

		case	0x98:	printf("cbw\n");	break;
		case	0x99:
			if	(DataS == AS_WORD)
				printf("cwd\n");
			else
				printf("cdq\n");
			break;

		case	0x9a:
			printf("callf\t");
			if	(AddrS == AS_WORD){
				printf("%04x:%04x\n", 
						* ref unsigned[16](code + 3), 
						* ref unsigned[16](code + 1));
				addr += 4;
				}
			else	{
				printf("%04x:%08x\n", 
						* ref unsigned[16](code + 5),
						* ref unsigned[32](code + 1));
				addr += 6;
				}
			break;

		case	0x9b:	printf("wait\n");	break;
		case	0x9c:	printf("pushf\n");	break;
		case	0x9d:	printf("popf\n");	break;				
		case	0x9e:	printf("sahf\n");	break;
		case	0x9f:	printf("lahf\n");	break;
		case	0xa0:
			printf("mov\tal,");
			addr += displacement(code + 1, DataSymbols);
			printf("\n");
			break;

		case	0xa1:
			printf("mov\t%S,", regName(0, DataS));
			addr += displacement(code + 1, DataSymbols);
			printf("\n");
			break;

		case	0xa2:
			printf("mov\t");
			addr += displacement(code + 1, DataSymbols);
			printf(",al\n");
			break;

		case	0xa3:
			printf("mov\t");
			addr += displacement(code + 1, DataSymbols);
			printf(",%S\n", regName(0, DataS));
			break;

		case	0xa4:	printf("movsb\n");	break;
		case	0xa5:	printf("movs%c\n", DataS == AS_DWORD ? 'd' : 'w'); break;
		case	0xa6:	printf("cmpsb\n");	break;
		case	0xa7:	printf("cmps%c\n", DataS == AS_DWORD ? 'd' : 'w'); break;
		case	0xa8:
			printf("test\tal,");
			addr += immediate(addr, AS_BYTE, FALSE);
			printf("\n");
			break;

		case	0xa9:
			printf("test\t%S,", regName(0, DataS));
			addr += immediate(addr, DataS, FALSE);
			printf("\n");
			break;

		case	0xaa:	printf("stosb\n");	break;
		case	0xab:	printf("stos%c\n", DataS == AS_DWORD ? 'd' : 'w'); break;
		case	0xac:	printf("lodsb\n");	break;
		case	0xad:	printf("lods%c\n", DataS == AS_DWORD ? 'd' : 'w'); break;
		case	0xae:	printf("scasb\n");	break;
		case	0xaf:	printf("scas%c\n", DataS == AS_DWORD ? 'd' : 'w'); break;

		case	0xb0:
		case	0xb1:
		case	0xb2:
		case	0xb3:
		case	0xb4:
		case	0xb5:
		case	0xb6:
		case	0xb7:
			printf("mov\t%S,", regName(*code & 7, AS_BYTE));
			addr += immediate(addr, AS_BYTE, FALSE);
			printf("\n");
			break;

		case	0xb8:
		case	0xb9:
		case	0xba:
		case	0xbb:
		case	0xbc:
		case	0xbd:
		case	0xbe:
		case	0xbf:
			printf("mov\t%S,", regName(*code & 7, DataS));
			addr += immediate(addr, DataS, TRUE);
			printf("\n");
			break;

		case	0xc0:
			printf("%s\t", Immediate2[(code[1] >> 3) & 0x7]);
			addr += modRm(code + 1, AS_BYTE);
			printf(",");
			addr += immediate(addr, AS_BYTE, FALSE);
			printf("\n");
			break;

		case	0xc1:
			printf("%s\t", Immediate2[(code[1] >> 3) & 0x7]);
			addr += modRm(code + 1, DataS);
			printf(",");
			addr += immediate(addr, AS_BYTE, FALSE);
			printf("\n");
			break;

		case	0xc2:
			printf("ret\t%x\n", * ref unsigned[16](code + 1));
			return addr + 2;

		case	0xc3:	printf("ret\n");	return addr;

		case	0xc6:
			printf("mov\t");
			addr += modRm(code + 1, AS_BYTE);
			printf(",");
			addr += immediate(addr, AS_BYTE, FALSE);
			printf("\n");
			break;

		case	0xc7:
			printf("mov\t");
			addr += modRm(code + 1, DataS);
			printf(",");
			addr += immediate(addr, DataS, TRUE);
			printf("\n");
			break;

		case	0xc9:	printf("leave\n");	break;

		case	0xca:
			printf("retf\t%x\n", * ref unsigned[16](code + 1));
			return addr + 2;

		case	0xcb:	printf("retf\n");	return addr;
		case	0xcc:	printf("int\t3\n");	break;

		case	0xcd:
			printf("int\t");
			addr += immediate(addr, AS_BYTE, FALSE);
			printf("\n");
			break;

		case	0xce:	printf("into\n");	break;
		case	0xcf:	printf("iret\n");	return addr;

		case	0xd0:
			printf("%s\t", Immediate2[(code[1] >> 3) & 0x7]);
			addr += modRm(code + 1, AS_BYTE);
			printf(",1\n");
			break;

		case	0xd1:
			printf("%s\t", Immediate2[(code[1] >> 3) & 0x7]);
			addr += modRm(code + 1, DataS);
			printf(",1\n");
			break;

		case	0xd2:
			printf("%s\t", Immediate2[(code[1] >> 3) & 0x7]);
			addr += modRm(code + 1, AS_BYTE);
			printf(",cl\n");
			break;

		case	0xd3:
			printf("%s\t", Immediate2[(code[1] >> 3) & 0x7]);
			addr += modRm(code + 1, DataS);
			printf(",cl\n");
			break;

		case	0xd4:	printf("aam\n");	break;
		case	0xd5:	printf("aad\n");	break;

		case	0xd7:	printf("xlat\n");	break;

		case	0xd8:
			if	(code[1] & 0xc0 == 0xc0){	// MOD == 11
				switch	((code[1] >> 3) & 0x7){
				case	0:	printf("fadd\tst,st(%d)\n", code[1] & 7);	break;
					}
				addr++;
				break;
				}
			switch	((code[1] >> 3) & 7){
			case	0:	printf("fadd\t");	break;
			case	1:	printf("fmul\t");	break;
			case	2:	printf("fcom\t");	break;
			case	3:	printf("fcomp\t");	break;
			case	4:	printf("fsub\t");	break;
			case	5:	printf("fsubr\t");	break;
			case	6:	printf("fdiv\t");	break;
			case	7:	printf("fdivr\t");	break;
				}
			addr += modRm(code + 1, AS_DWORD);
			printf("\n");
			break;

		case	0xd9:
			if	(code[1] & 0xc0 == 0xc0){	// MOD == 11
				switch	(code[1] & 0x3F){
				case	0x24:	printf("fld1\n");	break;
				case	0x2E:	printf("fldz\n");	break;
				case	0x3C:	printf("frndint\n");	break;
					}
				addr++;
				break;
				}
			switch	((code[1] >> 3) & 7){
			case	0:	printf("fld\t");	break;
			case	1:	printf("d9,001\t");	break;
			case	2:	printf("fst\t");	break;
			case	3:	printf("fstp\t");	break;
			case	4:	printf("fldenv\t");	break;
			case	5:	printf("fldcw\t");	break;
			case	6:	printf("fstenv\t");	break;
			case	7:	printf("fstcw\t");	break;
				}
			addr += modRm(code + 1, AS_DWORD);
			printf("\n");
			break;

		case	0xdb:
			switch	((code[1] >> 3) & 7){
			case	0:
				printf("fild\t");
				addr += modRm(code + 1, AS_DWORD);
				break;

			case	5:
				printf("fld\t");
				addr += modRm(code + 1, AS_TBYTE);
				break;

			case	7:
				printf("fstp\t");
				addr += modRm(code + 1, AS_TBYTE);
				break;
				}
			printf("\n");
			break;

		case	0xdc:
			switch	((code[1] >> 3) & 7){
			case	0:	printf("fadd\t");	break;
			case	1:	printf("fmul\t");	break;
			case	2:	printf("fcom\t");	break;
			case	3:	printf("fcomp\t");	break;
			case	4:	printf("fsub\t");	break;
			case	5:	printf("fsubr\t");	break;
			case	6:	printf("fdiv\t");	break;
			case	7:	printf("fdivr\t");	break;
				}
			addr += modRm(code + 1, AS_QWORD);
			printf("\n");
			break;

		case	0xdd:
			switch	((code[1] >> 3) & 7){
			case	0:
				printf("fld\t");
				addr += modRm(code + 1, AS_QWORD);
				break;

			case	3:
				printf("fstp\t");
				addr += modRm(code + 1, AS_QWORD);
				break;

			case	4:
				printf("frstor\t");
				addr += modRm(code + 1, AS_DWORD);
				break;

			case	6:
				printf("fsave\t");
				addr += modRm(code + 1, AS_DWORD);
				break;
				}
			printf("\n");
			break;

		case	0xde:
			if	(code[1] & 0xc0 == 0xc0){	// MOD == 11
				switch	((code[1] >> 3) & 0x7){
				case	0:	printf("faddp\tst(%d),st\n", code[1] & 7);	break;
				case	1:	printf("fmulp\tst(%d),st\n", code[1] & 7);	break;
				case	4:	printf("fsubrp\tst(%d),st\n", code[1] & 7);	break;
				case	5:	printf("fsubp\tst(%d),st\n", code[1] & 7);	break;
				case	6:	printf("fdivrp\tst(%d),st\n", code[1] & 7);	break;
				case	7:	printf("fdivp\tst(%d),st\n", code[1] & 7);	break;
				case	3:
					if	(code[1] & 7 == 1){
						printf("fcompp\n");
						break;
						}
				default:
					printf("de,%d\n", (code[1] >> 3) & 0x7);
					}
				addr++;
				break;
				}
			switch	((code[1] >> 3) & 7){
			case	0:
				printf("fiadd\t");
				addr += modRm(code + 1, AS_WORD);
				printf("\n");
				break;
				}
			break;

		case	0xdf:
			if	(code[1] & 0xc0 == 0xc0){	// MOD == 11
				switch	((code[1] >> 3) & 0x7){
				case	4:	printf("fstsw\tax\n");	break;
				default:
					printf("df,%d\n", (code[1] >> 3) & 0x7);
					}
				addr++;
				break;
				}
			as:	addrSizes = AS_WORD;
			switch	((code[1] >> 3) & 7){
			case	0:	printf("fild\t");	break;
			case	1:	printf("df,001\t");	break;
			case	2:	printf("fist\t");	break;
			case	3:	printf("fistp\t");	break;
			case	4:	printf("fbld\t");	break;
			case	5:	
				printf("fild\t");
				as = AS_QWORD;
				break;

			case	6:	printf("fbstp\t");	break;
			case	7:
				printf("fistp\t");
				as = AS_QWORD;
				break;
				}
			addr += modRm(code + 1, as);
			printf("\n");
			break;

			
		case	0xe0:
			loc = * ref signedByte(code + 1);
			addr++;
			loc += addr;
			printf("loopnz\t%x\n", loc);
			break;

		case	0xe1:
			loc = * ref signedByte(code + 1);
			addr++;
			loc += addr;
			printf("loopz\t%x\n", loc);
			break;

		case	0xe2:
			loc = * ref signedByte(code + 1);
			addr++;
			loc += addr;
			printf("loop\t%x\n", loc);
			break;

		case	0xe3:
			loc = * ref signedByte(code + 1);
			addr++;
			loc += addr;
			printf("jcxz\t%x\n", loc);
			break;

		case	0xe4:
			printf("in\tal,%x\n", code[1]);
			addr++;
			break;

		case	0xe5:
			printf("in\t%S,%x\n", regName(0, DataS), code[1]);
			addr++;
			break;

		case	0xe6:
			printf("out\t%x,%S\n", code[1], regName(0, AS_BYTE));
			addr++;
			break;

		case	0xe7:
			printf("out\t%x,%S\n", code[1], regName(0, DataS));
			addr++;
			break;

		case	0xe8:
			if	(AddrS == AS_DWORD){
				loc = * ref signed[32](code + 1);
				addr += 4;
				}
			else	{
				loc = * ref signed[16](code + 1);
				addr += 2;
				}
			loc += addr;
			sym = CodeSymbols findSymbol(loc);
			printf("call\t");
			sym display(loc);
			printf("\n");
			break;

		case	0xe9:
			if	(AddrS == AS_DWORD){
				loc = * ref signed[32](code + 1);
				addr += 4;
				}
			else	{
				loc = * ref signed[16](code + 1);
				addr += 2;
				}
			loc += addr;
			printf("jmp\t%x\n", loc);
			break;

		case	0xeb:
			loc = * ref signedByte(code + 1);
			addr++;
			loc += addr;
			printf("jmp\t%x\n", loc);
			break;

		case	0xec:
			printf("in\tal,dx\n");
			break;

		case	0xed:
			printf("in\t%S,dx\n", regName(0, DataS));
			break;

		case	0xee:
			printf("out\tdx,al\n");
			break;

		case	0xef:
			printf("out\tdx,%S\n", regName(0, DataS));
			break;

		case	0xf0:
			printf("lock\n");
			instruction = FALSE;
			break;

		case	0xf1:
			printf("Parasol error\n");
			break;

		case	0xf2:
			printf("repnz\n");
			instruction = FALSE;
			break;

		case	0xf3:
			printf("repz\n");
			instruction = FALSE;
			break;

		case	0xf4:	printf("hlt\n");	break;
		case	0xf5:	printf("cmc\n");	break;

		case	0xf6:
			switch	((code[1] >> 3) & 7){
			case	2:
				printf("not\t");
				addr += modRm(code + 1, AS_BYTE);
				printf("\n");
				break;

			case	3:
				printf("neg\t");
				addr += modRm(code + 1, AS_BYTE);
				printf("\n");
				break;

			case	4:
				printf("mul\tal,");
				addr += modRm(code + 1, AS_BYTE);
				printf("\n");
				break;

			case	5:
				printf("imul\tal,");
				addr += modRm(code + 1, AS_BYTE);
				printf("\n");
				break;

			case	6:
				printf("div\tal,");
				addr += modRm(code + 1, AS_BYTE);
				printf("\n");
				break;

			case	7:
				printf("idiv\tal,");
				addr += modRm(code + 1, AS_BYTE);
				printf("\n");
				break;

			default:
				printf("Unknown opcode: %x:%x\n", *code, code[1]);
				return addr + 1;
				}
			break;

		case	0xf7:
			switch	((code[1] >> 3) & 7){
			case	2:
				printf("not\t");
				addr += modRm(code + 1, DataS);
				printf("\n");
				break;

			case	3:
				printf("neg\t");
				addr += modRm(code + 1, DataS);
				printf("\n");
				break;

			case	4:
				printf("mul\t%S,", regName(0, DataS));
				addr += modRm(code + 1, DataS);
				printf("\n");
				break;

			case	5:
				printf("imul\t%S,", regName(0, DataS));
				addr += modRm(code + 1, DataS);
				printf("\n");
				break;

			case	6:
				printf("div\t%S,", regName(0, DataS));
				addr += modRm(code + 1, DataS);
				printf("\n");
				break;

			case	7:
				printf("idiv\t%S,", regName(0, DataS));
				addr += modRm(code + 1, DataS);
				printf("\n");
				break;

			default:
				printf("Unknown opcode: %x:%x\n", *code, code[1]);
				return addr + 1;
				}
			break;

		case	0xf8:	printf("clc\n");	break;
		case	0xf9:	printf("stc\n");	break;
		case	0xfa:	printf("cli\n");	break;
		case	0xfb:	printf("sti\n");	break;
		case	0xfc:	printf("cld\n");	break;
		case	0xfd:	printf("std\n");	break;

		case	0xfe:
			switch	((code[1] >> 3) & 7){
			case	0:
				printf("inc\t");
				addr += modRm(code + 1, AS_BYTE);
				printf("\n");
				break;

			case	1:
				printf("dec\t");
				addr += modRm(code + 1, AS_BYTE);
				printf("\n");
				break;

			default:
				printf("Unknown opcode: %x:%x\n", *code, code[1]);
				return addr + 1;
				}
			break;

		case	0xff:
			switch	((code[1] >> 3) & 7){
			case	0:
				printf("inc\t");
				addr += modRm(code + 1, DataS);
				printf("\n");
				break;

			case	1:
				printf("dec\t");
				addr += modRm(code + 1, DataS);
				printf("\n");
				break;

			case	2:
				printf("call\t");
				addr += modRm(code + 1, AddrS);
				printf("\n");
				break;

			case	4:
				printf("jmp\t");
				addr += modRm(code + 1, AddrS);
				printf("\n");
				break;

			case	6:
				printf("push\t");
				addr += modRm(code + 1, DataS);
				printf("\n");
				break;

			default:
				printf("Unknown opcode: %x:%x\n", *code, code[1]);
				return addr + 1;
				}
			break;

		default:
			printf("Unknown opcode: %x\n", *code);
			return addr;
			}
		AddrS = addrS;
		DataS = dataS;
		}
	}

Immediate:	[8] ref char = [
		"add",
		"or",
		"adc",
		"sbb",
		"and",
		"sub",
		"xor",
		"cmp"
		];

Immediate2:	[8] ref char = [
		"rol",
		"ror",
		"rcl",
		"rcr",
		"shl",
		"shr",
		"",
		"sar"
		];

displacement:	(code: ref byte, sym: ref symbol) int =
	{
	loc:	unsigned;
	addr:	int;
	x:	unsigned;

	if	(AddrS == AS_DWORD){
		loc = * ref unsigned[32](code);
		addr = 4;
		}
	else	{
		loc = * ref unsigned[16](code);
		addr = 2;
		}
	printf("[");
	showAddress(loc, sym);
	printf("]");
	return addr;
	}

showAddress:	(loc: unsigned, sym: ref symbol) =
	{
	sym = sym findSymbol(loc);
	if	(loc < RunHeader->dataTotalLen &&
		 sym)
		sym display(loc);
	else
		printf("%x", loc);
	}

Jumps:	[16] ref char = [
	"jo",
	"jno",
	"jb",
	"jnb",
	"jz",
	"jnz",
	"jbe",
	"jnbe",
	"js",
	"jns",
	"jp",
	"jnp",
	"jl",
	"jnl",
	"jle",
	"jnle"
	];

arithmetic:	(op: ref char, opcode: byte, addr: unsigned) int =
	{
	i:	int;
	reg:	int;

	reg = (Code[addr] >> 3) & 7;
	printf("%s\t", op);
	switch	(opcode & 7){
	case	0:
		i = modRm(Code + addr, AS_BYTE);
		printf(",%S\n", regName(reg, AS_BYTE));
		return i;

	case	1:
		i = modRm(Code + addr, DataS);
		printf(",%S\n", regName(reg, DataS));
		return i;

	case	2:
		printf("%S,", regName(reg, AS_BYTE));
		i = modRm(Code + addr, AS_BYTE);
		printf("\n");
		return i;

	case	3:
		printf("%S,", regName(reg, DataS));
		i = modRm(Code + addr, DataS);
		printf("\n");
		return i;

	case	4:
		printf("%S,", regName(0, AS_BYTE));
		i = immediate(addr, AS_BYTE, FALSE);
		printf("\n");
		return i;

	case	5:
		printf("%S,", regName(0, DataS));
		i = immediate(addr, DataS, FALSE);
		printf("\n");
		return i;
		}
	printf("Unexpected subcode: %x\n", opcode);
	return 0;
	}

immediate:	(addr: unsigned, showSize: addrSizes, 
					possibleAddr: boolean) int =
	{
	if	(showSize == AS_DWORD){
		if	(possibleAddr)
			showAddress(* ref signed[32](Code + addr), 
								DataSymbols);
		else
			printf("%x", * ref signed[32](Code + addr));
		return 4;
		}
	else if	(showSize == AS_WORD){
		printf("%x", * ref signed[16](Code + addr));
		return 2;
		}
	else	{
		printf("%x", * ref signedByte(Code + addr));
		return 1;
		}
	}

regName:	(reg: int, showSize: addrSizes) [:] char =
	{
	WordNames:	static	[8] [:] char = [
			"ax",
			"cx",
			"dx",
			"bx",
			"sp",
			"bp",
			"si",
			"di"
			];
	DWordNames:	static	[8] [:] char = [
			"eax",
			"ecx",
			"edx",
			"ebx",
			"esp",
			"ebp",
			"esi",
			"edi"
			];
	ByteNames:	static	[8] [:] char = [
			"al",
			"cl",
			"dl",
			"bl",
			"ah",
			"ch",
			"dh",
			"bh"
			];

	switch	(showSize){
	case	AS_DWORD:		return DWordNames[reg];
	case	AS_WORD:		return WordNames[reg];
	case	AS_BYTE:		return ByteNames[reg];
	default:			return "?";
		}
	}

segRegName:	(reg: int) ref char =
	{
	WordNames:	static	[8] ref char = [
			"es",
			"cs",
			"ss",
			"ds",
			"fs",
			"gs",
			"",
			""
			];

	return WordNames[reg];
	}

addrSizes:	type	int = {
	AS_BYTE,
	AS_WORD,
	AS_DWORD,
	AS_QWORD,
	AS_TBYTE
	};

modRm:	(code: ref char, showSize: addrSizes) int =
	{
	WordBases:	static	[8] ref char = [
			"bx+si",
			"bx+di",
			"bp+si",
			"bp+di",
			"si",
			"di",
			"bp",
			"bx"
			];
	rm:	int;
	mod:	int;
	d:	int;
	len:	int;

	rm = *code & 7;
	mod = (*code >> 6) & 3;
	switch	(mod){
	case	0x3:			// register
		printf(regName(rm, showSize));
		return 1;

	case	0x1:			// base displacement
		d = * ref signedByte(code + 1);
		showSizePrefix(showSize);
		if	(AddrS == AS_DWORD){
			if	(rm != 4){
				printf("[%S", regName(rm, AddrS));
				if	(d < 0)
					printf("-%x]", -d);
				else
					printf("+%x]", d);
				return 2;
				}

				// two-byte mod/rm escape

			d = * ref signedByte(code + 2);
			len = 3;
			}
		else	{
			printf("[%s", WordBases[rm]);
			if	(d < 0)
				printf("-%x]", -d);
			else
				printf("+%x]", d);
			return 2;
			}
		break;

	case	0x2:			// base displacement
		showSizePrefix(showSize);
		if	(AddrS == AS_DWORD){
			if	(rm != 4){
				printf("[%S", regName(rm, AddrS));
				d = * ref signed[32](code + 1);
				if	(d < 0)
					printf("-%x]", -d);
				else
					printf("+%x]", d);
				return 5;
				}

				// two-byte mod/rm escape

			d = * ref unsigned[32](code + 2);
			len = 6;
			}
		else	{
			printf("[%s", WordBases[rm]);
			d = * ref signed[16](code + 1);
			if	(d < 0)
				printf("-%x]", -d);
			else
				printf("+%x]", d);
			return 3;
			}
		break;

	case	0x0:
		showSizePrefix(showSize);
		if	(AddrS == AS_DWORD){
			if	(rm == 5){
				displacement(code + 1, DataSymbols);
				return 5;
				}
			else if	(rm != 4){
				printf("[%S]", regName(rm, AddrS));
				return 1;
				}

				// two-byte mod/rm escape

			d = 0;
			len = 2;
			if	((code[1] & 7) == 5){
				d = * ref unsigned[32](code + 2);
				len = 6;
				}
			}
		else	{
			if	(rm != 6){
				printf("[%s]", WordBases[rm]);
				return 1;
				}
			else	{
				displacement(code + 1, DataSymbols);
				return 3;
				}
			}
		}
	base:	int;
	index:	int;
	scale:	int;

	base = code[1] & 7;
	index = (code[1] >> 3) & 7;
	scale = 1 << ((code[1] >> 6) & 3);
	printf("[");
	if	(mod != 0 || base != 5){
		printf(regName(base, AS_DWORD));
		if	(index != 4)
			printf("+");
		}
	if	(index != 4){
		printf("%S", regName(index, AS_DWORD));
		if	(scale != 1)
			printf("*%d", scale);
		}
	if	(mod == 0 && base == 5 && index == 4)
		printf("%x", d);
	else if	(d)
		printf("+%x", d);
	printf("]");
	return len;
	}

showSizePrefix:	(showSize: addrSizes) =
	{
	switch	(showSize){
	case	AS_BYTE:	printf("byte ptr ");	return;
	case	AS_WORD:	printf("word ptr ");	return;
	case	AS_DWORD:	printf("dword ptr ");	return;
	case	AS_QWORD:	printf("qword ptr ");	return;
	case	AS_TBYTE:	printf("tbyte ptr ");	return;
	default:
		return;
		}
	}

