/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	alys;
include	kprintf;
include	object;
include	filesys;
include	console;
include	window;
include	video;
include	process;
include	hardware;

ConsoleFile:	public	inherit	file	{
	public:
	windows:	ref consoleWindows;

open:	dynamic	(cf: accessRights_t) ref far channel = 
	{
	j:	ref far job;
	cw:	ref consoleWindows;

	j = CurProc->myJob;
	for	(cw = windows; cw; cw = cw->next){
		if	(cw->windowJob == j)
			break;
		}
	if	(cw == 0){
		myWindow:	ref PC_textWindow;
		myWindowId:	ref far PC_textWindow;

		myWindow = new PC_textWindow[ [ 80, 25 ], &ConsoleObject ];
		myWindowId = ref far PC_textWindow(
				publishKernel("conWindow", myWindow, AR_ANY, 
						AR_ANY, AR_NONE, AR_NONE));
		processJob(myWindowId);
		myWindowId zoom([ 0, 0 ], WZ_NORMAL);
		cw = new consoleWindows[ 0, myWindow, myWindowId, j ];
		n:	threadLock;

		n lock();
		cw->next = windows;
		windows = cw;
		n unlock();
		}

	ch:	ref PC_consoleChannel;
	fch:	ref far channel;

	ch = new PC_consoleChannel[ cw->windowId ];
	fch = ref far channel(publishKernel("conChannel", ch, cf, AR_NONE, AR_NONE, AR_NONE));
	processJob(fch);
	return fch;
	}

	};

consoleWindows:	type	{ public:
	next:		ref consoleWindows;
	windowObj:	ref PC_textWindow;
	windowId:	ref far PC_textWindow;
	windowJob:	ref far job;
	};

PC_consoleChannel:	public	type	inherit	consoleChannel	{
	public:
	screen:		ref far PC_textWindow;
	cursor:		point;

constructor:	(v: ref far PC_textWindow) =
	{
	screen = v;
	cursor = [ 0, 0 ];
	super constructor(1);
	}

read:	gate	() [] byte =
	{
	i:	int;
	line:	static	[256] char;
	k:	keystroke;

	i = 0;
	for	(;;){
		k = screen getKey();
		if	(k == keystroke(-1))
			return "";
		cursor = Screen->cursor;
		switch	(k){
		case	'\n':
		case	'\r':
			putchar('\n');
			line[i] = '\n';
			screen textCursor(cursor);
			return line[:i + 1];

		case	'\b':
			if	(i > 0){
				i--;
				putchar('\b');
				putchar(' ');
				putchar('\b');
				screen textCursor(cursor);
				}
			break;

		default:
			if	(k >= 256)
				continue;
			putchar(k);
			screen textCursor(cursor);
			line[i] = k;
			i++;
			if	(i >= |line)
				return line;
			}
		}
	}

write:	gate	(buf: [:] byte) int =
	{
	cp:	ref char;
	i:	int;

	if	(screen != TopWindow)
		screen toTop();
	cursor = Screen->cursor;
	for	(i = 0; i < |buf; i++)
		putchar(buf[i]);
	screen textCursor(cursor);
	return |buf;
	}

putchar:	(c: char) =
	{
 	if	(c == '\r')
		cursor.x = 0;
	else if	(c == '\n'){
		if	(cursor.y < 24)
			cursor.y++;
		else	{
			screen verticalScroll([ 0, 0 ], [ 80, 25 ], 1);
			}
		cursor.x = 0;
		}
	else if	(c == '\b'){
		if	(cursor.x > 0)
			cursor.x--;
		}
	else if	(c == '\t'){
		do	{
			putchar(' ');
			}
			while	(cursor.x & 7);
		}
	else	{
		screen putc(cursor, c);
		cursor.x++;
		if	(cursor.x >= 80){
			if	(cursor.y < 24)
				cursor.y++;
			else	{
				screen verticalScroll([ 0, 0 ], [ 80, 25 ], 1);
				}
			cursor.x = 0;
			}
		}
	}

appearsOn:	gate	() ref far console =
	{
	return screen appearsOn();
	}

	};

