/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	alys;
include	hardware;
include	process;

MAXTIME:	public	const int = 1000000;	// Maximum time for zap timer

Now:		public	time_t;
Tcount:		public	tick_t;
Ticks:		public	tick_t;

TimerQueue:	ref timer = 0;

sleep:	public	(n: int) =
	{
	then:	time_t;

	then = Now;
	for	(;;){
		if	(Now == then + n)
			return;
		}
	}

timer:	public	type	{
	public:

constructor:	(cnt: tick_t) =
	{
	v:	ref ref timer;
	s:	ref timer;
	n:	threadLock;

	count = cnt;
	fired = 0;
	v = &TimerQueue;
	n lock();
	s = TimerQueue;
	if	(s)
		s->count = Tcount;
	while	(s && s->count <= count){
		v = &s->next;
		count -= s->count;
		s = *v;
		}
	if	(v == &TimerQueue)
		Tcount = count;
	if	(s)
		s->count -= count;
	*v = self;
	next = s;
	n unlock();
	}

abort:	() =
	{
	n:	threadLock;
	v:	ref ref timer;
	s:	ref timer;

	fired = 1;
	v = &TimerQueue;
	n lock();
	s = TimerQueue;
	while	(s != self){
		if	(s == 0){		// must have fired
			n unlock();
			return;			// so we don't need to worry
			}
		v = &s->next;
		s = *v;
		}
	s = next;				// s now points at the next, if any
	if	(v == &TimerQueue){
		if	(s)
			Tcount += s->count;
		}
	else if	(s)
		s->count += count;
	*v = s;
	n unlock();
	}

fire:	dynamic	() =
	{
	}

dispose:	dynamic	() =
	{
	}

	fired:		byte;
	next:		* timer;
	count:		tick_t;
	};

semaphoreTimer:	public	type	inherit timer {
	public:

	event:	semaphore;

constructor:	(clk: tick_t) =
	{
	event = [ 0 ];
	super constructor(clk);
	}

wait:	(clk: tick_t) boolean =
	{
	self = [ clk ];
	if	(!event down(TRUE)){
		abort();
		return FALSE;
		}
	else
		return TRUE;
	}

fire:	dynamic	() =
	{
	event up();
	}

	};

zapTimer:	type	inherit timer {

fire:	dynamic	() =
	{
	Zap = [ MAXTIME ];
	}

	};

Zap:	zapTimer;

start:	entry	() =
	{
	Zap = [ MAXTIME ];
	}

/*
	This function is called from the hardware clock timer whenever 
	Tcount decrements to zero.  This routine is called with interrupts
	disabled.
 */
timerExpires:	public	() =
	{
	t:	ref timer;
	ty:	int;

	do	{
		t = TimerQueue;
		TimerQueue = TimerQueue->next;
		if	(!t->fired){
			t->fired = 1;
			t fire();
			}
		else
			t dispose();
		}
		while	(TimerQueue->count == 0);
	Tcount = TimerQueue->count;
	}
