/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	format;
include	console;

video:	public	type	{
	public:
	cursor:		point;
	mcursor:	point;
	corner:		point;
	size:		point;

mouseCursor:	dynamic	(point) =
	{
	}

showMouse:	dynamic	(boolean) =
	{
	}

hideMouse:	dynamic	() boolean =
	{
	}

positionCursor:	dynamic	(point) =
	{
	}

showCursor:	dynamic	() =
	{
	}

hideCursor:	dynamic	() =
	{
	}

setColor:	dynamic	(char) =
	{
	}

putc:	dynamic	(point, char) =
	{
	}

putcc:	dynamic	(point, char, color_t) =
	{
	}

write:	dynamic	(point, * char, unsigned) =
	{
	}

writeCA:	dynamic	(point, * colorChar, unsigned) =
	{
	}

read:	dynamic	(point, * colorChar, unsigned) =
	{
	}

close:	dynamic	() int =
	{
	}

verticalScroll:	dynamic	(point, point, int) =
	{
	}

horizontalScroll:	dynamic	(point, point, int) =
	{
	}

	};

Screen:	public	ref video;
ScreenPrintf:	public	consoleEmitter;

consoleEmitter:	public	type	inherit	emitter	{

putc:	dynamic	(c: char) =
	{
	vPutc(c);
	}

	};

vPutc:	public	(c: char) =
	{
	if	(Screen == 0)
		return;
	if	(c == '\r')
		Screen->cursor.x = 0;
	else if	(c == '\n'){
		if	(Screen->cursor.y < 24)
			Screen->cursor.y++;
		else	{
			Screen verticalScroll([ 0, 0 ], [ 79, 24 ], 1);
			}
		Screen->cursor.x = 0;
		}
	else if	(c == '\b'){
		if	(Screen->cursor.x > 0)
			Screen->cursor.x--;
		}
	else if	(c == '\t'){
		do	{
			vPutc(' ');
			}
			while	(Screen->cursor.x & 7);
		}
	else	{
		Screen putc(Screen->cursor, c);
		Screen->cursor.x++;
		if	(Screen->cursor.x >= 80){
			if	(Screen->cursor.y < 24)
				Screen->cursor.y++;
			else	{
				Screen verticalScroll([ 0, 0 ], [ 79, 24 ], 1);
				}
			Screen->cursor.x = 0;
			}
		}
	Screen showCursor();
	}
