/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	alys;
include	error;
include	string;
include	environ;

MAXPATHLIST:	public	const	int = 4096;
MAXPATH:	public	const int = 256;
MAXDIR:		public	const int = 224;	// MAXPATH - 32

AR_READ:	public	const accessRights_t = 0x0001;
AR_WRITE:	public	const accessRights_t = 0x0002;

FileSystem:	public	const	ref far nameContext = 
					ref far nameContext(FSYS_SLOT);

nameContext:	public	type	inherit	external {
	public:

open:			gate	(fname: [:] char, opt: accessRights_t) 
							ref far channel = 
	{
	reject(ERRINVALIDFUNC);
	}

stat:			gate	(fname: [:] char) file_t = 
	{
	reject(ERRINVALIDFUNC);
	}

create:			gate	(fname: [:] char, attr: fAttributes_t) 
							ref far channel = 
	{
	reject(ERRINVALIDFUNC);
	}

makeDirectory:		gate	(fname: [:] char) int = 
	{
	reject(ERRINVALIDFUNC);
	}

removeDirectory:	gate	(fname: [:] char) int = 
	{
	reject(ERRINVALIDFUNC);
	}

unlink:			gate	(fname: [:] char) int = 
	{
	reject(ERRINVALIDFUNC);
	}

unlinkGroup:		gate	(fname: [:] char) int = 
	{
	reject(ERRINVALIDFUNC);
	}

move:			gate	(fname1: [:] char, fname2: [:] char) int = 
	{
	reject(ERRINVALIDFUNC);
	}

getAbsolutePath:	gate	(fname: [:] char) [] char = 
	{
	reject(ERRINVALIDFUNC);
	}

access:			gate	(fname: [:] char, accessRights_t) int = 
	{
	reject(ERRINVALIDFUNC);
	}

setFileAttributes:	gate	(fname: [:] char, fAttributes_t) int = 
	{
	reject(ERRINVALIDFUNC);
	}

setCurrentDirectory:	gate	(fname: [:] char) int = 
	{
	reject(ERRINVALIDFUNC);
	}

getDriveInfo:		gate	(fname: [:] char) drive_t = 
	{
	reject(ERRINVALIDFUNC);
	}

scanDirectory:		gate	(fname: [:] char) ref far directoryScanner =
	{
	reject(ERRINVALIDFUNC);
	}

	// Process management calls

spawn:			gate	(host: ref far external, cmd: [:] char, 
					args: [:] char) ref far external =
	{
	reject(ERRINVALIDFUNC);
	}

spawnDebug:		gate	(host: ref far external, cmd: [:] char, 
					args: [:] char) ref far external =
	{
	reject(ERRINVALIDFUNC);
	}

	};

directoryScanner:	public	type	inherit external {
	public:

next:	gate	() fileDescriptor_t =
	{
	reject(ERRINVALIDFUNC);
	}

	};

fileDescriptor_t:	public	type	packed	{ public:
	info:		file_t;
	nlen:		byte;		// File name length in char's
	name:		[32] char;
	};

directory:	public	type	inherit	external {
	public:

open:			gate	(fname: [:] char, opt: accessRights_t) 
							ref far channel = 
	{
	reject(ERRINVALIDFUNC);
	}

stat:			gate	(fname: [:] char) file_t = 
	{
	reject(ERRINVALIDFUNC);
	}

create:			gate	(fname: [:] char, attr: fAttributes_t) 
							ref far channel = 
	{
	reject(ERRINVALIDFUNC);
	}

makeDirectory:		gate	(fname: [:] char) int =
	{
	reject(ERRINVALIDFUNC);
	}

removeDirectory:	gate	(fname: [:] char) int =
	{
	reject(ERRINVALIDFUNC);
	}

unlink:			gate	(fname: [:] char) int =
	{
	reject(ERRINVALIDFUNC);
	}

unlinkGroup:		gate	(fname: [:] char) int =
	{
	reject(ERRINVALIDFUNC);
	}

move:			gate	(fname1: [:] char, d2: ref far directory, 
						fname2: [:] char) int =
	{
	reject(ERRINVALIDFUNC);
	}

getAbsolutePath:	gate	(fname: [:] char) [] char =
	{
	reject(ERRINVALIDFUNC);
	}

access:			gate	(fname: [:] char, accessRights_t) int =
	{
	reject(ERRINVALIDFUNC);
	}

setFileAttributes:	gate	(fname: [:] char, fAttributes_t) int =
	{
	reject(ERRINVALIDFUNC);
	}

getDrive:		gate	(fname: [:] char) int =
	{
	reject(ERRINVALIDFUNC);
	}

find:			gate	(fname: [:] char) ref far directory = 
	{
	return 0;
	}

addReference:		gate	() =
	{
	reject(ERRINVALIDFUNC);
	}

getDriveInfo:		gate	() drive_t = 
	{
	reject(ERRINVALIDFUNC);
	}

scanDirectory:		gate	() ref far directoryScanner =
	{
	reject(ERRINVALIDFUNC);
	}

	};

channel:	public	type	inherit external {
	public:

	channelClass:	byte;
	filePosition:	long;

constructor:	(class: byte) =
	{
	channelClass = class;
	filePosition = 0;
	}

open:			gate	() int =
	{
	reject(ERRINVALIDFUNC);
	}

read:			gate	() [] byte =
	{
	reject(ERRINVALIDFUNC);
	}

write:			gate	([:] byte) int =
	{
	reject(ERRINVALIDFUNC);
	}

seek:			gate	(long, seek_t) long =
	{
	reject(ERRINVALIDFUNC);
	}

setAge:			gate	(time_t) int =
	{
	reject(ERRINVALIDFUNC);
	}

getClass:		gate	() channelClass_t =
	{
	reject(ERRINVALIDFUNC);
	}

	};

channelClass_t:	public	type	byte = {
	CC_FILE,			// a disk file channel
	CC_CONSOLE,			// a console window channel
	};

directoryChannel:	public	type	inherit channel {

next:	gate	() [] byte =
	{
	}

	};

channel_t:	public	type	packed	{
	channelClass:	byte;
			[3] byte;
	filePosition:	long;
	};

file_t:	public	type	packed	{
	public:
	attributes:	fAttributes_t;
	size:		long;
	ftime:		time_t;
	user:		userId;
	group:		userId;
	id:		int;		// A unique identifier

isValid:	() boolean =
	{
	return id != -1;
	}

	};

drive_t:	public	type	packed	{
	public:
	sectors:		unsigned[32];
	sectorSize:		unsigned[32];		// size in bytes
	freeSectors:		unsigned[32];
	};

fAttributes_t:	public	type	unsigned = {
	FA_USER_READ	= 0x000001,
	FA_USER_WRITE	= 0x000002,
	FA_USER_CONTROL	= 0x000004,
	FA_USER_EXEC	= 0x000008,
	FA_GRP_READ	= 0x000010,
	FA_GRP_WRITE	= 0x000020,
	FA_GRP_CONTROL	= 0x000040,
	FA_GRP_EXEC	= 0x000080,
	FA_WRLD_READ	= 0x000100,
	FA_WRLD_WRITE	= 0x000200,
	FA_WRLD_CONTROL	= 0x000400,
	FA_WRLD_EXEC	= 0x000800,
	FA_READ		= 0x000111,
	FA_WRITE	= 0x000222,
	FA_CONTROL	= 0x000444,
	FA_EXEC		= 0x000888,
	FA_HIDDEN	= 0x001000,
	FA_SYSTEM	= 0x002000,
	FA_VLABEL	= 0x004000,
	FA_DIR		= 0x008000,
	FA_ARCHIVE	= 0x010000,
	FA_SETUID	= 0x020000,
	FA_DEVICE	= 0x040000,
	FA_SEEKOK	= 0x080000,
	FA_NETNODE	= 0x100000,
	};

volume:	public	type	{
	};

file:	public	type	{
	public:
	attributes:	fAttributes_t;
	size:		long;
	ftime:		time_t;
	useCount:	signed[16];
	user:		userId;
	group:		userId;
	flags:		fileFlags_t;

attach:	(access: accessRights_t) int =
	{
	i:	int;

	i = access & (AR_READ|AR_WRITE);
/*
	if	(CurProc->uid != user){
		i <<= 4;
		if	(CurProc->groupid != group)
			i <<= 4;
		}
 */
	if	(attributes & i != i){
		close();
		return ERRPERMISSION;
		}
	if	(flags & F_LOCKED){
		close();
		return ERRPERMISSION;
		}
/*
	if	(access & AR_EXCLUSIVE){
		if	(useCount > 1){
			close();
			return ERRPERMISSION;
			}
		flags |= F_LOCKED;
		}
 */
	return SUCCESS;
	}

dup:	() =
	{
	useCount++;
	}

open:	dynamic	(accessRights_t) ref far channel = 
	{
	return 0;
	}

dispose:	dynamic	() =
	{
	}

sync:	dynamic	() =
	{
	}

close:	() =
	{
	useCount--;
	if	(useCount == 0)
		dispose();
	}

	};

fileFlags_t:	public	type	byte = {
	F_LOCKED	= 0x01,
	F_CHANGED	= 0x02,
	};

getExtension:	public	(path: [:] char) [:] char =
	{
	i:	int;

	i = stringReverseScan(path, '/');
	if	(i >= 0)
		path = path[i + 1:];
	i = stringReverseScan(path, '.');
	if	(i < 0)
		return "";
	else if	(i == 0){
		if	(|path == 1)
			return "";		// filename is .
		}
	else if	(i == 1){
		if	(|path == 2 &&
			 path[0] == '.')	// filename is ..
			return "";
		}
	return path[i:];
	}

getDirectory:	public	(path: [:] char) [:] char =
	{
	i:	int;

	i = stringReverseScan(path, '/');
	if	(i < 0)
		return "";
	else if	(i == 0)		// handle the root
		i++;
	return path[:i];
	}

getFilename:	public	(path: [:] char) [:] char =
	{
	i:	int;

	i = stringReverseScan(path, '/');
	if	(i >= 0)
		path = path[i + 1:];
	i = stringReverseScan(path, '.');
	if	(i < 0)
		return path;
	else if	(i == 0){
		if	(|path == 1)
			return path;		// filename is .
		}
	else if	(i == 1){
		if	(|path == 2 &&
			 path[0] == '.')	// filename is ..
			return path;
		}
	return path[:i];
	}

stripExtension:	public	(path: [:] char) [:] char =
	{
	s:	[:] char;
	i, j:	int;

	s = path;
	j = stringReverseScan(path, '/');
	if	(j >= 0)
		path = path[j + 1:];
	i = stringReverseScan(path, '.');
	if	(i < 0)
		return s;
	else if	(i == 0){
		if	(|path == 1)
			return s;		// filename is .
		}
	else if	(i == 1){
		if	(|path == 2 &&
			 path[0] == '.')	// filename is ..
			return s;
		}
	return s[:i + j + 1];
	}

stripDirectory:	public	(path: [:] char) [:] char =
	{
	i:	int;

	i = stringReverseScan(path, '/');
	if	(i < 0)
		return path;
	else
		return path[i + 1:];
	}

PathTrap:	public	trap;

makePath:	public	(path: [:] char, dir: [:] char, file: [:] char, 
					ext: [:] char) [:] char =
	{
	len:	int;
	extraSlash, extraDot: boolean;

	extraSlash = FALSE;
	extraDot = FALSE;
	len = |dir + |file + |ext;
	if	(|dir && dir[|dir - 1] != '/'){
		len++;
		extraSlash = TRUE;
		}
	if	(|ext && ext[0] != '.'){
		len++;
		extraDot = TRUE;
		}
	if	(len > ||path)
		PathTrap raise();
	path [:]= dir;
	if	(extraSlash)
		path = stringAppend(path, "/");
	path = stringAppend(path, file);
	if	(extraDot)
		path = stringAppend(path, ".");
	return stringAppend(path, ext);
	}

makeLocal:	public	(obj: ref far external, slot: ref far external) int =
	{
	_EBX = int(obj);
	_EDX = int(slot);
	_emit(0x9a, _null, _GDT_MAKELOCAL);
	}

makeAnyLocal:	public	(obj: ref far external) ref far external =
	{
	_EBX = int(obj);
	_emit(0x9a, _null, _GDT_MAKEANYLOCAL);
	}

setForkAction:	public	(slot: ref far external, action: forkAction_t) int =
	{
	_EBX= int(slot);
	_DL = action;
	_emit(0x9a, _null, _GDT_SETFORKACTION);
	}

forkAction_t:	public	type	byte = {
	FA_CLOSE,				// when the arena forks,
						// close this reference
	FA_COPY,				// when the arena forks,
						// copy the object itself
	FA_REF,					// when the arena forks,
						// make a new reference only.
	FA_STATIC,				// just copy the id, dont
						// count it
	};

finder:	public	type	{
	public:
	pathname:	[:] char;
	attrib:		fAttributes_t;
	ftime:		long;
	size:		long;

open:	(path: [:] char, fpattern: [:] char, attrib: int) int =
	{
	patternAttr = ~attrib &
			 (FA_HIDDEN|FA_SYSTEM|FA_VLABEL|FA_DIR);
	baseLen = |path;
	pathname = fileBuf;
	pathname [:]= path;
	if	(baseLen == 1 &&
		 path[0] == '/')
		;
	else if	(baseLen != 0){
		fileBuf[baseLen] = '/';
		baseLen++;
		}
	patternName = patternBuf;
	patternName [:]= fpattern;

	if	(|path == 0)
		path = ".";
	scanner = FileSystem scanDirectory(path);
	if	(scanner == 0)
		return ERRNOPATH;
	else	{
		scanner = ref far directoryScanner(makeAnyLocal(scanner));
		return SUCCESS;
		}
	}

close:	() =
	{
	scanner close();
	}

next:	() int =
	{
	i:		int;
	err:		int;
	cp:		* char;
	n:		int;
	filename:	[12] char;
	x:		fileDescriptor_t;
	fname:		[:] char;
	nm:		[:] char;

	for	(;;){
		x = scanner next();
		if	(x.nlen == 0)
			return ERRNOFILE;

		if	(x.info.attributes & patternAttr)
			continue;

			// Null byte entries signal end of directory

		fname = x.name[:x.nlen];
		if	(!match(fname, patternName))
			continue;
		break;
		}
	attrib = x.info.attributes;
	ftime = x.info.ftime;
	size = x.info.size;
	nm = fileBuf[baseLen:];
	nm [:]= fname;
	pathname = fileBuf[:baseLen + |nm];
	return SUCCESS;
	}

private:

	patternName:	[:] char;
	patternBuf:	[MAXPATH - MAXDIR] char;
	patternAttr:	int;
	baseLen:	byte;
	fileBuf:	[MAXPATH] char;
	scanner:	ref far directoryScanner;
	};

match:	(s: [:] char, pat: [:] char) boolean =
	{
	while	(|pat){
		if	(pat[0] == '*'){
			pat = pat[1:];
			if	(|pat == 0)
				return TRUE;
			while	(|s){
				if	(match(s, pat))
					return TRUE;
				s = s[1:];
				}
			return FALSE;
			}
		if	(|s == 0)
			return FALSE;
		if	(pat[0] != '?' &&
			 pat[0] != s[0])
			return FALSE;
		pat = pat[1:];
		s = s[1:];
		}
	return |s == 0;
	}

pathList:	public	type	{
	Path:	[:] char;
	Buffer:	[MAXPATH] char;

	public:

useEnvironment:	(varName: [:] char) =
	{
	i:	size_t;

	if	(|Path)
		free(Path);
	Path = "";
	i = Environment probe(varName);
	Path = new [i] char;
	Path [:]= Environment get(varName);
	}

useString:	(path: [:] char) =
	{
	if	(|Path)
		free(Path);
	Path = new [|path] char;
	Path [:]= path;
	}

search:	(file: [:] char, ...) [:] char =
	{
	ffile:	[:] char;
	ext:	[:] char;
	dir:	[:] char;
	i:	int;
	ap:	varArgs;

	ext = getExtension(file);
	if	(|ext){
		i = FileSystem access(file, AR_READ);
		if	(i == SUCCESS)
			return file;
		}
	else	{
		ffile = searchExtensions(file, ...);
		if	(|ffile)
			return ffile;
		}
	dir = getDirectory(file);
	if	(|dir)
		return "";
	pathp:	[:] char;
	cp:	* char;
	next:	[:] char;

	for	(pathp = Path; |pathp; ){
		ffile = Buffer;
		i = stringScan(pathp, ';');
		if	(i >= 0){
			ffile [:]= pathp[:i];
			next = pathp[i + 1:];
			}
		else	{
			ffile [:]= pathp;
			next = "";
			}
		if	(|ffile && ffile[|ffile - 1] != '/')
			ffile = stringAppend(ffile, "/");
		ffile = stringAppend(ffile, file);
		if	(|ext){
			i = FileSystem access(ffile, AR_READ);
			if	(i == SUCCESS)
				return ffile;
			}
		else	{
			ffile = searchExtensions(ffile, ...);
			if	(|ffile)
				return ffile;
			}
		if	(|next == 0)
			break;
		pathp = next;
		}
	return "";
	}

	};

searchExtensions:	(f: [:] char, ap: varArgs) [:] char =
	{
	cp:	ref char;
	buffer:	static	[MAXPATH] char;
	file:	[:] char;
	xp:	[:] char;
	i:	int;
	j:	int;

	file = buffer;
	file [:]= f;
	xp = file[|file:MAXPATH];
	j = |file;
	for	(;;){
		ap nextArg(&cp, sizeof cp);
		if	(cp == 0)
			break;
		xp [:]= cp[:stringLength(cp)];
		|file = j + |xp;
		i = FileSystem access(file, AR_READ);
		if	(i >= 0)
			return file;
		}
	return "";
	}

