/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	target;
include	ptree;
include	symtab;
/*
isInSet:	macro	(i, s) = (((s)[(i) >> 3]) &  (1 << ((i) & 7)));
turnOffSet:	macro	(i, s) = (((s)[(i) >> 3]) &= ~(1 << ((i) & 7)));
turnOnSet:	macro	(i, s) = (((s)[(i) >> 3]) |= (1 << ((i) & 7)));
 */

/*
InterferenceGraph:	extern	graphPtr;
VarMap:			extern	varNumPtr;
 */

assignRegisterVariables:	public	() int =
	{
/*
	if	(Config.optimize != CF_OPT_NONE)
		optimizingAssign();
	else
		nonOptimizingAssign();
	}

/*
	Variables are assigned to registers according to the live range
	information computed before.  In principle, all temps created by
	quads should be represented as variables, and then they can be
	allocated using this following algorithm.  Unfortunately, that
	would introduce unacceptably large numbers of variables, thus
	greatly expanding the size of the bit vectors involved and slowing
	down the whole process.

	In order to arrive at a reasonable compromise, temps are assigned
	to registers in a separate scan of the quads (see ALOCTMP.C).  Temps
	interfere with each other in very specific ways that mean that a full
	interference graph is not necessary.  Temps obey a nearly LIFO
	lifetime, so in fact the portion of an interference graph occupied
	by temps is sparse and tends to form clumps of temps which are alive
	at the same time.

	On the other hand, variables created by CSE's or by user declarations
	can have very complicated live ranges, necessitating a more complete
	treatment.  Therefore, we compute a partial interference graph
	consisting only of true variables.  The effect of temps is factored
	in by recording in each variable the set of registers that have been
	assigned to temps whose live ranges overlap with the variable.
 */
optimizingAssign:	() =
	{
	s:		* stmtitem;
/*
	lv:		livePtr;
	ld:		liveDeltaPtr;
 */
	i:		int;
	j:		int;
	v:		* variable;
/*
	g:		graphPtr;
	gn:		graphPtr;
	cv:		CSEvarPtr;
 */
	rootscope:	* stmtitem;
	regmask:	unsigned;
	sc:		* stmtitem;
	winscope:	* stmtitem;
	winvar:		* variable;
	winrank:	unsigned;
	thisrank:	unsigned;
	thisreg:	regNum;
	winreg:		regNum;
	winmask:	regMask;

		/* Now pick some registers */

#if	defined(VALIDATE_CODER)
	if	(DebugFlag){
		g = InterferenceGraph;
		for	(i = 0; i < TargetData.maxVar; i++){
			printf("set for v %d [%x] ", i, VarMap[i]);
			for	(j = 0; j < TargetData.setSize; j++, g++){
				printf(":%x", *g);
				}
			printf(": regMask %x\n", VarMap[i]->liveTemps);
			}
		for	(s = TargetData.sList; s; s = s->next){
			if	(s->kind != SK_QUADS &&
				 s->kind != SK_SWITCH)
				continue;
			printf("stmt %x: ", s);
			lv = getStmtLive(s, &ld);
			for	(i = 0; i < TargetData.setSize; i++)
				printf(":%x", lv[i]);
			printf(":\n");
			while	(ld->where){
				printf("delta <%d, %d>\n", ld->where, ld->toggledVar->variableNumber);
				ld--;
				}
			}
		}
#endif
	regmask = EAX|EBX|ECX|EDX|ESI|EDI;
	if	(regmask == 0)
		return;
	for	(v = TargetData.vars; v; v = v->next)
		v->liveTemps |= ~regmask;

	for	(;;){
		winrank = 1;
		winvar = 0;
		winreg = 0;

			/* Find the busiest qualified variable */

		for	(v = TargetData.vars; v; v = v->next){
			thisrank = rank(v, &thisreg, ~v->liveTemps);
			if	(thisrank >= winrank){
				winvar = v;
				winrank = thisrank;
				winreg = thisreg;
				}
			}

			/* Convert it to a register variable. */

		if	(winvar == 0)
			break;
		if	(DebugFlag)
			printf("assigned reg %x to v %d\n", winreg,
				winvar->variableNumber);
		winvar->flags |= VF_REG;
		winvar->reg = winreg;
		if	(winvar->declaration){
			winvar->declaration->reg = winreg;
			}

		g = InterferenceGraph;
		winmask = getRegMask(winreg);
		TargetData.usedRegisters |= winmask;
		j = winvar->variableNumber;
		for	(i = 0; i < TargetData.maxVar; i++, g += TargetData.setSize)
			if	(isInSet(j, g)){
				if	(DebugFlag)
					printf("blacked-out v %d\n", i);
				VarMap[i]->liveTemps |= winmask;
				}
		}
	}

nonOptimizingAssign:	() =
	{
 */
	s:		ref blockScope;
	i:		unsigned;
	rootscope:	ref blockScope;
	regmask:	unsigned;
	sc:		ref scope_s;
	winscope:	ref blockScope;
	winvar:		* variable;
	winrank:	unsigned;
	thisrank:	unsigned;
	thisreg:	regNum;
	winreg:		regNum;
	winmask:	regMask;
	assignedAny:	boolean;

	assignedAny = FALSE;
	rootscope = TargetData.rootScope;
	TargetData.reservedRegisters |=
		(TargetData.reservedRegisters & (AHmask|BHmask|CHmask|DHmask)) >> 1;
	for	(;;){
		winrank = 1;
		winvar = 0;
		winscope = 0;
		winreg = 0;

			/* Find the busiest qualified variable
			   in any un-tiled scope */

		findhighest(rootscope, &winrank, &winvar, &winscope, &winreg);

			/* Convert it to a register variable. */

		if	(winvar == 0)
			break;
		winvar->flags |= VF_REG;
		assignedAny = TRUE;
		winvar->reg = winreg;

			/* Now tile the affected scopes. */

			/* First the chain of ancestor scopes */

		winmask = getRegMask(winreg);
		TargetData.usedRegisters |= winmask;
		winscope->usedInScope |= winmask;
		for	(sc = winscope; sc; sc = sc->enclosing)
			sc->reservedInScope |= winmask;

			/* Now the forest of sub-scopes */

		tiledown(winscope->child, winmask);
		}
	return assignedAny;
	}

findhighest:	(s: ref blockScope, winrankp: * unsigned,
				    winvarp: * * variable,
				    winscopep: * ref blockScope,
				    winregp: * regNum) =
	{
	v:		* variable;
	i:		unsigned;
	thisreg:	regNum;
	r:		regMask;

	if	(s == 0)
		return;
	r = ~(s->reservedInScope | TargetData.reservedRegisters |
			(ESmask|SSmask|CSmask|SPmask|BPmask|DSmask|
			 AHmask|BHmask|CHmask|DHmask));
	if	(r){
		for	(v = TargetData.vars; v; v = v->next){
			if	(v->declaredScope != s)
				continue;
			i = rank(v, &thisreg, r);
			if	(i >= *winrankp){
				*winvarp = v;
				*winscopep = s;
				*winrankp = i;
				*winregp = thisreg;
				}
			}
		}
	for	(s = s->child; s; s = s->sibling)
		findhighest(s, winrankp, winvarp, winscopep, winregp);
	}

tiledown:	(s: ref blockScope, winmask: regMask) =
	{
	while	(s){
		s->reservedInScope |= winmask;
		s->usedInScope |= winmask;
		tiledown(s->child, winmask);
		s = s->sibling;
		}
	}

lowestReg:	(regmask: regMask) unsigned =
	{
	winreg:		unsigned;
	r:		regNum;

	assert(regmask != 0);
	r = 0;
	for	(winreg = 1; (winreg & regmask) == 0; winreg <<= 1, r++)
		;
	return(r);
	}

rank:	(var: * variable, thisregp: * regNum, regmask: regMask) unsigned =
	{
	x:	unsigned;
	i:	int;
	r:	regMask;

	if	(var->flags & (VF_NIXREG|VF_REG))
		return 0;
	if	(regmask == 0)
		return 0;
	switch	(var->dtype->topType){
	case	T_UNSIGNED:
	case	T_SIGNED:

			// If the variable is a byte variable or if it
			// was used as a byte variable, we need a 'byte'
			// register.

		if	(var->dtype sizeOf() == 1 ||
			 var->flags & VF_BYTEREG){
			r = ALmask|BLmask|CLmask|DLmask;
			if	(!overlaps(r, regmask))
				return 0;
			regmask &= r;
			if	(var->shiftCount &&
				 overlaps(CLmask, regmask))
				regmask = CLmask;
			}

	case	T_REF:
		*thisregp = lowestReg(regmask);
		break;

	default:
		return 0;
		}
	if	(fits(var->preferredReg, regmask)){
		x = 2;
		*thisregp = var->preferredReg;
		}
	else
		x = 0;
	x += var->totalCount;
	if	(fits(*thisregp, CXmask))
		x += var->shiftCount;
	if	(var->declaration &&
		 var->declaration->storageClass == SC_PARM)
		i = 2;
	else
		i = 1;
	if	(x < i)
		return 0;
	return x - i;
	}

