/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	filesys;
include	alys;
include	file;
include	error;

PathFound:	int;				// Set by searchPath to:
Path:		[512] char;
LastChild:	ref far external;
WaitFor:	ref far external;

RUN_PATH:	const	int = 0;		// Path was a .RUN file
EXE_PATH:	const	int = 1;		// Path was an .EXE file

main:	entry	() =
	{
	_Thread declareObject(&TTYViewer);
	newJob();
	fd:	stream;

	fd open("/con", AR_READ);			// stdin
	fd open("/con", AR_WRITE);			// stdout
	fd dup();					// stderr
	thread(&ReadChannel) start();
	thread(&WriteChannel) start();
	startCommand();
	do
		TTYViewer wait(&external.childExit);
		while	(WaitFor != LastChild);
	}

startCommand:	() =
	{
	cmd:		[:] char;
	arg0:		[:] char;
	lookup:		pathList;
	i:		int;

	if	(ArgumentCount == 0){
		printf("Use is: SESSION cmd arg(s)\n");
		return;
		}
	arg0 = getNextArgument();
	lookup useEnvironment("PATH");
	cmd = lookup search(arg0, ".run", ".com", ".exe", 0);
	if	(|cmd == 0)
		return;
	if	(ArgumentCount == 0)
		arg0 = "";
	else
		arg0 = _ArgumentVector;
	i = forkArena();
	if	(i)
		printf("forkArena %S\n", cmdError(i));
	makeLocal(ReadChannel.objectId, ref far channel(0));
	makeLocal(WriteChannel.objectId, ref far channel(1));
	makeLocal(WriteChannel.objectId, ref far channel(2));
	try
		WaitFor = FileSystem spawn(0, cmd, arg0);
	except
		exit(1);
	i = discardArena();
	if	(i)
		exit(-i + 0x20);
	}
/*
	This is the channel that the shell reads from.  It must deliver
	a line of text, one character at a time.  The read channel must also
	support type ahead.  So, the session maintains a 
 */
ReadChannel:	inherit	channel	{
	public:

start:	gate	() =
	{
	}

read:	gate	() [] byte =
	{
	i:	int;
	c:	int;

	for	(i = 0; i < MessageHeader->len; i++){
		c = getchar();
		printf("c = %d\n", c);
		replyPartial(&c, 1);
		if	(c == '\n');
			break;
		}
	}

	};

WriteChannel:	inherit	channel	{
	public:

start:	gate	() =
	{
	}

write:	gate	(buf: [:] byte) int =
	{
	stdout write(buf);
	}

	};

Measure:	inherit	external {

attention:	gate!	() =
	{
	}

};

TTYViewer:	inherit	external {

childExit:	gate	(code: unsigned) =
	{
	LastChild = MessageHeader->sender;
	}

	};

dumpData:	public	(p: pointer, len: int) =
	{
	cp:	ref byte;
	i:	int;
	j:	int;

	cp = p;
	while	(len){
		printf("%08x: ", cp);
		i = 8;
		j = 0;
		while	(i){
			if	(len){
				printf("%02x ", *cp);
				j--;
				len--;
				cp++;
				}
			else
				printf("   ");
			i--;
			}
		i = 8;
		printf(" ");
		while	(i){
			if	(len){
				printf("%02x ", *cp);
				j--;
				len--;
				cp++;
				}
			else
				printf("   ");
			i--;
			}
		printf("  ");
		for	(i = j; i < 0; i++){
			if	(cp[i] == 0 ||
				 cp[i] == '\n' ||
				 cp[i] == '\t' ||
				 cp[i] == '\r')
				printf(".");
			else
				printf("%c", cp[i]);
			}
		printf("\n");
		}
	}

