/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	string;
include	file;
include	environ;
include	error;

path:	[256] char;

start:	entry	() =
	{
	i:	int;
	j:	int;
	p:	[:] char;

	p = path;
	if	(ArgumentCount == 0){

			// An environment list report:

		try
			for	(i = 1; ; i++){
				p [:]= Environment getByIndex(i);
				printf("%S\n", p);
				}
		return;
		}

			// Defining an environment variable:

	nxt:	[:] char;

	p [:]= getNextArgument();
	while	(|p < ||p && ArgumentCount){
		nxt = getNextArgument();
		if	(|p < ||p)
			p = stringAppend(p, " ");
		if	(|p + |nxt > ||p)
			|nxt = ||p - |p;
		p = stringAppend(p, nxt);
		}
	i = parseDefinition(p);
	if	(i < 0)
		printf("Definition failed: %S\n", cmdError(i));
	}

parseDefinition:	(p: [:] char) int =
	{
	i, j:		int;
	cp:		ref char;
	name, value:	[:] char;

	cp = p;
	i = |p;
	while	(i && isspace(*cp)){
		cp++;
		i--;
		}
	if	(i == 0)
		return ERRINVALIDFORMAT;
	for	(j = 0; j < i; j++)
		if	(isspace(cp[j]) ||
			 cp[j] == '=')
			break;
	name = cp[:j];
	cp += j;
	i -= j;
	while	(i && isspace(*cp)){
		cp++;
		i--;
		}
	if	(i == 0 || *cp != '=')
		return ERRINVALIDFORMAT;
	cp++;
	i--;
	while	(i && isspace(*cp)){
		cp++;
		i--;
		}
	value = cp[:i];
	if	(i)
		Environment define(name, value);
	else
		Environment undefine(name);
	return SUCCESS;
	}
