/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	file;
include	alys;

main:	entry	() =
	{
	n:	node_t;

	n = Host describe();
	printf("ALYS Kernel version %d.%02d %s\n\n", n.kernelVersion >> 8,
			n.kernelVersion & 0xff, n.name);
	printf("Cumulative user time %d ticks.  System time %d ticks.  ",
			n.userTime, n.sysTime);
	printf("Idle ticks %d.\n", n.idleTime);
	x:	long;
	y:	long;

	x = n.userTime + n.sysTime;
	y = x + n.idleTime;
	x = x * 1000 / y;
	printf("Utilization %d.%d%%\n", x / 10, x % 10);
	printf("Hard disk retries %d.\n", n.diskRetries);
	y = n.cacheHits + n.cacheMisses;
	x = n.cacheHits * 1000 / y;
	printf("Cache misses %d hits %d (%d.%d%%) \n", n.cacheMisses, 
				n.cacheHits,
				x / 10, x % 10);
	printf("\n\tMemory usage:\n\n");
	printf("Available RAM: %9d\n", n.availableRAM);
	printf("Disk cache:    %9d\n", n.diskCache);
	printf("Kernel code:   %9d\n", n.kernelCode);
	printf("Kernel data:   %9d\n", n.kernelData);
	printf("DOS Memory:    %9d\n", n.dosMemory);
	printf("Net buffers:   %9d\n", n.netBuffers);
	}
