/******************************************************************************
Module name: NoDigCls.c
Written by: Jeffrey Richter
Notices: Copyright (c) 1995 Jeffrey Richter
Purpose: NoDigits subclass child control implementation file
******************************************************************************/


#include "..\Win95ADG.h"          /* See Appendix A for details */
#include <Windows.h>
#include <WindowsX.h>
#pragma warning(disable: 4001)    /* Single-line comment */
#include "resource.h"


///////////////////////////////////////////////////////////////////////////////


static LPCTSTR g_szNoDigitsClassWndProcOrig = 
   __TEXT("NoDigitsClassWndProcOrig");


///////////////////////////////////////////////////////////////////////////////


// The sole purpose of this function is to call the base class's window 
// procedure. When using the FORWARD_* message crackers, a function like
// this one is necessary because the last parameter to a FORWARD_* message cracker
// is a function with the standard WNDPROC function prototype, whereas 
// CallWindowProc requires a fifth parameter - the address of the window
// procedure to call.
LRESULT NoDigitsClass_CallOrigWndProc (HWND hwnd, UINT uMsg, 
   WPARAM wParam, LPARAM lParam) {

   // Call the base class's window procedure.  It was saved as a window
   // property by the NoDigitsClass_ConvertEdit function.
   return(CallWindowProc(
     (WNDPROC) (DWORD) GetProp(hwnd, g_szNoDigitsClassWndProcOrig),
     hwnd, uMsg, wParam, lParam));
}


///////////////////////////////////////////////////////////////////////////////


void NoDigitsClass_OnChar (HWND hwnd, TCHAR ch, int cRepeat)  {

   if (adgINRANGE(__TEXT('0'), ch, __TEXT('9'))) {

      // Beep when a digit is received.
      MessageBeep(0);
   } else {
   
      // Allow nondigits to pass through to the original window procedure.
      FORWARD_WM_CHAR(hwnd, ch, cRepeat, NoDigitsClass_CallOrigWndProc);
   }
}


///////////////////////////////////////////////////////////////////////////////


// This function processes all messages sent to the NoDigits windows.
LRESULT WINAPI NoDigitsClass_WndProc (HWND hwnd, UINT uMsg,
   WPARAM wParam, LPARAM lParam) {

   switch (uMsg) {
      HANDLE_MSG(hwnd, WM_CHAR, NoDigitsClass_OnChar);
   }
   return(NoDigitsClass_CallOrigWndProc(hwnd, uMsg, wParam, lParam));
}


///////////////////////////////////////////////////////////////////////////////


// Function that converts an edit window to a NoDigitsClass window
// by subclassing the edit window.
BOOL WINAPI NoDigitsClass_ConvertEdit (HWND hwnd, BOOL fSubclass) {

   BOOL fOk = FALSE;

   if (fSubclass) {
      fOk = SetProp(hwnd, g_szNoDigitsClassWndProcOrig,
        (HANDLE) (DWORD) SubclassWindow(hwnd, NoDigitsClass_WndProc));
   } else {
      WNDPROC wp = (WNDPROC) (DWORD) 
         RemoveProp(hwnd, g_szNoDigitsClassWndProcOrig);
     SubclassWindow(hwnd, wp);
     fOk = (wp != NULL);      
   }
   return(fOk);
}


//////////////////////////////// End of File //////////////////////////////////
