/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	file;
//include	format;
//include	project;
//include	cdata, unit;

		// in parser.p

ErrOpen:		public	[] char = "Unable to open input file '%s'";
ErrDeclarationSyntax:	public	[] char = "Declaration syntax";
ErrIncludeSyntax:	public	[] char = "Include statement syntax";

		// in ptree.p

ErrRedecl:		public	[] char = "Redeclaration of '%s'";

		// in sbuffer.p

ErrStringNoTerm:	public	[] char = "Unterminated string or character constant";
ErrBadEscape:		public	[] char = "Unknown escape character %c (0x%x)";
WarnHexTooBig:		public	[] char = "Hexadecimal constant too large";
ErrNumLarge:		public	[] char = "Numeric constant too large";
ErrEofInComment:	public	[] char = "Unexpected end of file in comment";

		// in scanner.p

ErrBadChar:		public	[] char = "Incorrect character '%c' (0x%x)";
ErrBadNumber:		public	[] char = "Incorrect number format";
ErrTooManyDecimals:	public	[] char = "Too many decimal points";
ErrMisplacedDecimal:	public	[] char = "Misplaced decimal point";
ErrTooManyExponents:	public	[] char = "Too many exponents";
ErrNotOctalDigit:	public	[] char = "Not an octal digit";
ErrStringLong:		public	[] char = "String too long";
ErrCConstLong:		public	[] char = "Character constant too long";

NO_LINE:	public	const	fileOffset = ~0;

messageGenerator:	public	type	{
	public:

objectName:	dynamic	() ref char =
	{
	return 0;
	}

lineno:		dynamic	(fileOffset) int =
	{
	return 0;
	}

	};

messageContext:	public	type	{
	public:

	obj:		ref messageGenerator;
					// object associated with the
					// message
	offset:		fileOffset;	// offset in source file

clear:	() =
	{
	obj = 0;
	offset = 0;
	}

	};

CurrentContext:	public	messageContext;
ErrorCount:	public	int;

fatal:	public	(s: [:] char, ...) =
	{
	ap:	varArgs;

	ap = ...;
	prefix("Fatal", &CurrentContext, ap, s);
	ErrorCount++;
//	MsgTrap raise();
	exit(1);
	}

error:	public	(s: [:] char, ...) =
	{
	ap:	varArgs;

	ap = ...;
	prefix("Error", &CurrentContext, ap, s);
	ErrorCount++;
	}

errorV:	public	(s: [:] char, ap: varArgs) =
	{
	prefix("Error", &CurrentContext, ap, s);
	ErrorCount++;
	}

errorAt:	public	(m: ref messageContext, s: [:] char, ...) =
	{
	ap:	varArgs;

	ap = ...;
	prefix("Error", m, ap, s);
	ErrorCount++;
	}

warn:	public	(s: [:] char, ...) =
	{
	ap:	varArgs;

	ap = ...;
	prefix("Warning", &CurrentContext, ap, s);
	}

prefix:	(m: [:] char, mm: ref messageContext, ap: varArgs, s: [:] char) =
	{
	printf(m);
	if	(mm->obj){
		printf(" %S", mm->obj objectName());
		if	(mm->offset != NO_LINE)
			printf(" %d", mm->obj lineno(mm->offset));
		}
	printf(": ");
	if	(|s &&
		 s[|s - 1] == 0)
		--|s;			// strip off the trailing null
	vprintf(s, ap);
	stdout putc('\n');
	}

