/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	error;
include	kprintf;
include	arena;
include	alys;
include	format;
include	object;
include	filesys;
include	vmemory;
include	hardware, list;
include	process;
include	timer;
include	disk;
include	karena;
include	memory;

AlysNode:	public	inherit	node {
	public:

	kernelVersion:		unsigned[16];
	name:			[33] char;

	root:			ref far directory;

	userTime:		tick_t;
	sysTime:		tick_t;
	idleTime:		tick_t;

	diskRetries:		long;
	cacheHits:		long;
	cacheMisses:		long;

time:			gate	() time_t = 
	{
	return Now;
	}

setTime:		gate	(t: time_t) = 
	{
	Now = t;
	}

close:	gate	() boolean =
	{
//	kprintf("rejecting a close\n");
	return FALSE;
	}

delete:	gate	() boolean =
	{
//	kprintf("rejecting a delete\n");
	return FALSE;
	}

copy:	gate	() ref far external =
	{
	return objectId;
	}

	// Process management calls

spawn:			gate	(cmd: [:] char, args: [:] char) 
							ref far external =
	{
	l:	ref loader;
	x:	ref far external;

//	printf("spawn(%S, %S)\n", cmd, args);
	for	(l = ref loader(Loaders.next); l != &Loaders; 
					l = ref loader(l->next))
		try	{
			return l load(MessageHeader->sender, 0, cmd, args);
			}
		except	{
			}
	reject(ERRNOTRUNFILE);
	}

spawnDebug:		gate	(cmd: [:] char, args: [:] char) 
							debug_t =
	{
	l:	ref loader;
	d:	debug_t;

	for	(l = ref loader(Loaders.next); l != &Loaders; 
					l = ref loader(l->next)){
		if	(l debugLoad(MessageHeader->sender, &d, 0, cmd, args))
			return d;
		}
	reject(ERRNOTRUNFILE);
	}

nullDebug:		gate	() debug_t =
	{
	reject(ERRINVALIDFUNC);
	}

getProcess:	gate	(pid: int) process_t = 
	{
	p:	process_t;

	memSet(&p, 0, sizeof p);
	if	(pid < 0 || pid > NPROCS)
		p.status = PINVALID;
	else if	(pid == 0)
		CurProc describe(&p);
	else if	(ProcessTable[pid - 1] == 0)
		p.status = PFREE;
	else
		ProcessTable[pid - 1] describe(&p);
	return p;
	}

getObject:	gate	(oid: ref far external) object_t = 
	{
	o:	object_t;
	op:	ref object;

//	kprintf("oid = %d\n", oid);
	memSet(&o, 0, sizeof o);
	op = objectEntry(oid);
	if	(op)
		op describe(&o);
	return o;
	}

getObjectName:	gate	(oid: ref far external) [] char = 
	{
	op:	ref object;

//	kprintf("oid = %d\n", oid);
	op = objectEntry(oid);
	if	(op)
		return op->name;
	else
		return "";
	}

getSegment:	gate	(sid: int) segment_t =
	{
	s:	segment_t;

	if	(describeSegment(sid, &s))
		return s;
	else
		reject(0);
	}

setCacheSize:	gate	(newSize: unsigned[32]) int =
	{
	return resizeCache(newSize);
	}

describe:	gate	() node_t =
	{
	n:	node_t;

	n.kernelVersion = kernelVersion;
	n.name [:]= name;
	n.root = root;
	n.userTime = userTime;
	n.sysTime = sysTime;
	n.idleTime = idleTime;
	n.diskRetries = diskRetries;
	n.cacheHits = cacheHits;
	n.cacheMisses = cacheMisses;
	n.availableRAM = FreePages.pageCount * PAGE_SIZE;
	n.dosMemory = CSbase;
	n.kernelCode = CSsize;
	n.kernelData = paddr_t(_brklvl);
	n.diskCache = CacheSegment->length;
	n.netBuffers = 0;
//	n.netBuffers = NetBufferSize;
	return n;
	}

	};

Loaders:	public	queue;
LoaderTrap:	trap;

loader:	public	type	inherit	queue	{
	public:
/*
	This function raises an exception if there is an error loading the
	image.
 */
load:	dynamic	(par: ref far external, d: ref far directory, cmd: [:] char, 
					args: [:] char) ref far external =
	{
	LoaderTrap raise();
	}

debugLoad:	dynamic	(par: ref far external, d: ref debug_t, 
				d: ref far directory, cmd: [:] char, 
				args: [:] char) boolean =
	{
	LoaderTrap raise();
	}

register:	() =
	{
	Loaders enqueue(self);
	}

	};

startup:	entry	() =
	{
	BootContext.localObject[HOST_SLOT] =
				publishKernel("Host", &AlysNode, 
				AR_ANY, AR_ANY, AR_ANY, AR_ANY);
	BootContext.forkAction[HOST_SLOT] = FA_STATIC;
	Loaders = [];
	}
