/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	console;
include	video;
include	process;
include	hardware;
include	pc_hdw;
include	kprintf;

MOUSE_ATTR:	const	byte = 0x7F;

PC_Screen:	PCvideo;

setup:	entry	() =
	{
	i:		long;
	va:		* char;
	pa:		int;
	videoMode:	char;

	copyIn(&videoMode, 0x449, sizeof videoMode);
	if	(videoMode == 7){
		va = physicalToAddressable(0xb0000);
		pa = 0x3b4;
		}
	else	{
		va = physicalToAddressable(0xb8000);
		pa = 0x3d4;
		}
	PC_Screen = [ pa, va, [ 80, 25 ] ];
	PC_Screen clear();
	PC_Screen setColor(HIGH|RED);
	Screen = &PC_Screen;
	VideoEvent constructor(0);
	PrintfConsole = &ScreenPrintf;
	}

VideoEvent:		public	semaphore;
VideoSuppressFlag:	public	int = 0;

PCvideo:	public	type	inherit	video	{
	private:

	addr_6845:		unsigned;
	video_address:		* char;
	address:		unsigned;
	mouseCursorVisible:	boolean;

setCursor:	() =
	{
	if	(VideoSuppressFlag)
		VideoEvent down(FALSE);
	_outportByte(addr_6845, 14);	/* Select cursor register */
	_outportByte(addr_6845 + 1, address >> 9);
	_outportByte(addr_6845, 15);	/* Select cursor register again */
	_outportByte(addr_6845 + 1, address >> 1);
	}

	public:

	useCount:		unsigned[16];
	attribute:		char;
	cursorVisible:		boolean;

constructor:	(addr_chip: unsigned, video_addr: * char, size: point) =
	{
	addr_6845 = addr_chip;
	video_address = video_addr;
	corner = [ 0, 0 ];
	self->size = size;
	cursorVisible = TRUE;
	cursor = [ 0, 0 ];
	mcursor = [ 0, 0 ];
	attribute = WHITE;
	useCount = 1;
	mouseCursorVisible = FALSE;
	}

mouseCursor:	dynamic	(p: point) =
	{
	if	(p.x >= size.x && p.y >= size.y)
		return;
	if	(mouseCursorVisible){
		wa:	unsigned;

		wa = (mcursor.y * size.x + mcursor.x) * 2;
		video_address[wa + 1] ^= MOUSE_ATTR;
		}
	mcursor = p;
	if	(mouseCursorVisible){
		wa:	unsigned;

		wa = (mcursor.y * size.x + mcursor.x) * 2;
		video_address[wa + 1] ^= MOUSE_ATTR;
		}
	}

showMouse:	dynamic	(v: boolean) =
	{
	if	(v && !mouseCursorVisible){
		wa:	unsigned;

		wa = (mcursor.y * size.x + mcursor.x) * 2;
		video_address[wa + 1] ^= MOUSE_ATTR;
		mouseCursorVisible = TRUE;
		}
	}

hideMouse:	dynamic	() boolean =
	{
	b:	boolean;

	b = mouseCursorVisible;
	if	(b){
		wa:	unsigned;

		wa = (mcursor.y * size.x + mcursor.x) * 2;
		video_address[wa + 1] ^= MOUSE_ATTR;
		mouseCursorVisible = FALSE;
		}
	return b;
	}

toggleMouse:	() =
	{
	if	(mouseCursorVisible){
		wa:	unsigned;

		wa = (mcursor.y * size.x + mcursor.x) * 2;
		video_address[wa + 1] ^= MOUSE_ATTR;
		}
	}

loadState:	(v: * PCvideo) =
	{
	addr_6845 = 	v->addr_6845;
	video_address = v->video_address;
	address = 	v->address;
	attribute = 	v->attribute;
	cursorVisible = v->cursorVisible;
 	size = 		v->size;
	cursor = 	v->cursor;
	}

saveState:	(v: * PCvideo) =
	{
	v->addr_6845 = 		addr_6845;
	v->video_address = 	video_address;
	v->address = 		address;
	v->attribute = 		attribute;
	v->cursorVisible = 	cursorVisible;
 	v->size = 		size;
	v->cursor = 		cursor;
	}

absoluteCoordinates:	dynamic	(p: point) point =
	{
	return p;
	}

dup:	() =
	{
	useCount++;
	}

close:	dynamic	() int =
	{
	useCount--;
	if	(useCount)
		return 0;
	else
		return 1;
	}

positionCursor:	dynamic	(p: point) =
	{
	if	(p.x < size.x && p.y < size.y){
		address = (p.y * size.x + p.x) * 2;
		cursor = p;
		if	(cursorVisible)
			setCursor();
		}
	}

hideCursor:	dynamic	() =
	{
	address = (int(size.x) * size.y) * 2;
	cursorVisible = FALSE;
	setCursor();
	}

showCursor:	dynamic	() =
	{
	cursorVisible = TRUE;
	self positionCursor(cursor);
	}

read:	dynamic	(p: point, buf: * colorChar, len: unsigned) =
	{
	loc:	int;

	toggleMouse();
	loc = (p.y * size.x + p.x) * 2;
	len <<= 1;
	memCopy(buf, video_address + loc, len);
	toggleMouse();
	}

putc:	dynamic	(p: point, c: char) =
	{
	wa:	unsigned;

	if	(VideoSuppressFlag)
		VideoEvent down(FALSE);
	if	(p.x < size.x && p.y < size.y){
		wa = (p.y * size.x + p.x) * 2;
		video_address[wa] = c;
		video_address[wa + 1] = attribute;
		if	(mouseCursorVisible &&
			 p.x == mcursor.x &&
			 p.y == mcursor.y)
			video_address[wa + 1] ^= MOUSE_ATTR;
		}
	}

putcc:	dynamic	(p: point, c: char, a: color_t) =
	{
	wa:	unsigned;

	if	(VideoSuppressFlag)
		VideoEvent down(FALSE);
	if	(p.x < size.x && p.y < size.y){
		wa = (p.y * size.x + p.x) * 2;
		video_address[wa] = c;
		video_address[wa + 1] = a;
		if	(mouseCursorVisible &&
			 p.x == mcursor.x &&
			 p.y == mcursor.y)
			video_address[wa + 1] ^= MOUSE_ATTR;
		}
	}

write:	dynamic	(p: point, buf: * char, len: unsigned) =
	{
	loc:	int;
	mcv:	boolean;

	if	(VideoSuppressFlag)
		VideoEvent down(FALSE);
	loc = (p.y * size.x + p.x) * 2;
	mcv = hideMouse();
	while	(len){
		video_address[loc] = *buf;
		video_address[loc + 1] = attribute;
		buf++;
		loc += 2;
		len--;
		}
	showMouse(mcv);
	}

writeCA:	dynamic	(p: point, buf: * colorChar, len: unsigned) =
	{
	loc:	int;
	mcv:	boolean;

	if	(VideoSuppressFlag)
		VideoEvent down(FALSE);
	loc = (p.y * size.x + p.x) * 2;
	len <<= 1;
	mcv = hideMouse();
	memCopy(video_address + loc, buf, len);
	showMouse(mcv);
	}

verticalScroll:	dynamic	(ul: point, lr: point, amount: int) =
	{
	offset:		unsigned;
	diff:		unsigned;
	len:		unsigned;
	rows:		int;
	copyrows:	int;
	i:		unsigned;
	ip:		* char;
	jp:		* char;
	mcv:		boolean;

	if	(amount == 0)
		return;
	if	(lr.x < ul.x || lr.y < ul.y || lr.x > size.x || lr.y > size.y)
		return;
	if	(VideoSuppressFlag)
		VideoEvent down(FALSE);
	mcv = hideMouse();
	len = 2 * (1 + lr.x - ul.x);
	rows = 1 + lr.y - ul.y;
	i = 0;
	offset = (int(ul.y) * size.x + ul.x) * 2;
	if	(amount < 0){		/* scroll down */
		amount = -amount;
		if	(amount < rows){
			copyrows = rows - amount;
			offset += rows * size.x * 2 - size.x * 2;
			diff = amount * size.x * 2;
			for	(; i < copyrows; i++){
				memCopy(video_address + offset,
					video_address + offset - diff, len);
				offset -= size.x * 2;
				}
			}
		for	(; i < rows; i++){
			ip = video_address + offset;
			jp = ip + len;
			while	(ip < jp){
				*ip++ = ' ';
				*ip++ = attribute;
				}
			offset -= size.x * 2;
			}
		}
	else	{			/* scroll up */
		if	(amount < rows){
			copyrows = rows - amount;
			diff = amount * size.x * 2;
			for	(; i < copyrows; i++){
				memCopy(video_address + offset,
					video_address + offset + diff, len);
				offset += size.x * 2;
				}
			}
		for	(; i < rows; i++){
			ip = video_address + offset;
			jp = ip + len;
			while	(ip < jp){
				*ip++ = ' ';
				*ip++ = attribute;
				}
			offset += size.x * 2;
			}
		}
	showMouse(mcv);
	}

horizontalScroll:	dynamic	(ul: point, lr: point, amount: int) =
	{
	offset:		unsigned;
	diff:		unsigned;
	len:		unsigned;
	rows:		unsigned;
	copyrows:	unsigned;
	i:		unsigned;
	j:		unsigned;
	cp:		* char;
	mcv:		boolean;

	if	(amount == 0)
		return;
	if	(VideoSuppressFlag)
		VideoEvent down(FALSE);
	mcv = hideMouse();
	len = 2 * (1 + lr.x - ul.x);
	rows = 1 + lr.y - ul.y;
	i = 0;
	offset = (int(ul.y) * size.x + ul.x) * 2;
	cp = video_address + offset;
	if	(amount < 0){		/* scroll left */
		amount = -amount;
		diff = amount * 2;
		if	(diff > len)
			diff = len;
		for	(; i < rows; i++){
			if	(diff < len)
				memMove(cp + diff, cp, len);
			for	(j = 0; j < diff; j += 2){
				cp[j] = ' ';
				cp[j + 1] = attribute;
				}
			cp += size.x * 2;
			}
		}
	else	{			/* scroll right */
		ep:	* char;

		diff = amount * 2;
		if	(diff > len)
			diff = len;
		for	(; i < rows; i++){
			if	(diff < len)
				memMove(cp, cp + diff, len);
			ep = cp + len - diff;
			for	(j = 0; j < diff; j += 2){
				ep[j] = ' ';
				ep[j + 1] = attribute;
				}
			cp += size.x * 2;
			}
		}
	showMouse(mcv);
	}

setColor:	dynamic	(a: char) =
	{
	attribute = a;
	}

getAttribute:	() char =
	{
	return attribute;
	}

clear:	() =
	{
	verticalScroll([ 0, 0 ], [ size.x - 1, size.y - 1 ], size.y);
	positionCursor([ 0, 0 ]);
	}

	};
