/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	hardware, list;
include	console;

event:	public	type	inherit	queue	{ public:
	ev:		event_t;

create:	factory	(e: event_t) ref event =
	{
	n:	threadLock;

	n lock();
	if	(FreeEvent){
		self = FreeEvent;
		FreeEvent = ref event(next);
		n unlock();
		ev = e;
		return self;
		}
	else	{
		n unlock();
		return new event[ e ];
		}
	}

free:	() =
	{
	n:	threadLock;

	n lock();
	next = FreeEvent;
	FreeEvent = self;
	n unlock();
	}

	};

FreeEvent:	ref event;
/*
/*
	A session object runs under the control of a kernel thread.  This
	thread reads events from the inputQueue and triggers them, which
	dispatches them to the session windows.  A session is taken down by
	sending it a SigQuit signal, which will set the shutDown flag for the
	session.  It will then terminate on the next iteration.
 */
session:	public	type	{
	shutDown:	boolean;
	source:		ref inputQueue;
	myObject:	ref object;

	public:

run:	() =
	{
	while	(!shutDown){
		e:	ref inputEvent;

		e = source dequeue();
		if	(e == 0)		// interrupted
			break;
		else
			e trigger(self);
		}
	exit(0);
	}

accept:	(iq: ref inputQueue) =
	{
	iq bind(self);
	source = iq;
	}

alert:	(sig: signal_t) =
	{
	myObject alert(sig);
	}

	};

characterEvent:	public	type	inherit	inputEvent {
	ch:		char;

	public:

create:	factory	(c: char) ref characterEvent =
	{
	return new characterEvent[ c ];
	}

free:	dynamic	() =
	{
	CurrentHeap free(self);
	}

	};

inputEvent:	public	type	inherit	queue	{
	public:

trigger:	dynamic	(ref session) =
	{
	}

free:	dynamic	() =
	{
	}

	};

	/*
	   The typeahead buffer is implemented as a circular buffer.
	   When BufferHead equals BufferTail, the buffer is empty.
	   The Buffer is full when BufferTail is immediately below
	   BufferHead.
	 */

inputQueue:	public	type	{
	eventControl:		semaphore;
	rawQueue:		queue;
	streamHead:		ref session;

	public:

create:	factory	() ref inputQueue =
	{
	return new inputQueue;
	}

constructor:	() =
	{
	eventControl = [ 0 ];
	rawQueue constructor();
	streamHead = 0;
	}

bind:	(sh: ref session) =
	{
	streamHead = sh;
	}

clear:	() =
	{
	e:	ref inputEvent;
	n:	threadLock;

	n lock();
	while	(eventControl.count){
		e = dequeue();
		n unlock();
		e free();
		n lock();
		}
	n unlock();
	}

dequeue:	() ref inputEvent =
	{
	n:	threadLock;
	e:	ref inputEvent;

	if	(eventControl down(TRUE)){
		n lock();
		e = ref inputEvent(rawQueue dequeue());
		n unlock();
		return e;
		}
	else
		return 0;
	}

isEmpty:	() boolean =
	{
	return eventControl.count <= 0;
	}

enqueue:	(e: ref inputEvent) =
	{
	n:	threadLock;

	n lock();
	rawQueue enqueue(e);
	n unlock();
	eventControl up();
	}

alert:	(sig: signal_t) =
	{
	clear();
	streamHead alert(sig);
	}

peek:	() ref inputEvent =
	{
	if	(rawQueue isEmpty())
		return 0;
	else
		return ref inputEvent(rawQueue.next);
	}

	};
 */