/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	filesys, file, error, string;

include	target;
include	encoder;
include	symtab;
include	value;
include	backend;
include	hash;
include	errmsg;

AsmEncoder:	public	inherit	encoder {
	private:

	asmStream:	stream;
	codeLabel:	unsigned;
	currentSegment:	unsigned;
	valueIndex:	unsigned;

	public:

constructor:	(unitName: ref identifier) ref stream =
	{
	fpath:		[MAXPATH] char;
	f:		[:] char;

	f = makePath(fpath, "", unitName spelling(), ".asm");
	codeLabel = 0;
	valueIndex = 0;
	ch:	* heap;

	ch = Heap activate();
	if	(asmStream create(f, AR_READ|AR_WRITE) != SUCCESS){
		ch activate();
		error(ErrCreate, f);
		}
	asmStream printf("	.unit	%S\n", unitName spelling());
	ch activate();
	currentSegment = 0;
	return &asmStream;
	}

close:	() =
	{
	ch:	* heap;

	ch = Heap activate();
	asmStream close();
	ch activate();
	}

startupFunction:	dynamic	(v: ref value) =
	{
	if	(v->owner == 0)
		Project.asmFd printf("Func%x:\n", v);
	else
		asmLabel(v->owner);
	}

asmLabel:	dynamic	(sym: ref symbol_s) =
	{
	if	(sym->name)
		Project.asmFd printf(sym objectName());
/*
	else	{			// Must be a dynamic vector table
		d:	ref type_s;

		d = sym->dtype;
		if	(d &&
			 d->name)
			Project.asmFd printf(&d->name->Spelling);
		Project.asmFd printf(".vectorTable");
		}
 */
	Project.asmFd printf(":\n");
	}

dataAlign:	dynamic	(amount: int) =
	{
	if	(amount & 1)
		return;
	Project.asmFd printf("	.even\n");
	}

dataSegment:	dynamic	(i: int) =
	{
	if	(i == currentSegment)
		return;
	Project.asmFd printf("	.seg	%u\n", i);
	currentSegment = i;
	}

dataReserveBlock:	dynamic	(blockSize: addr_t) =
	{
	Project.asmFd printf("	.bss	%u\n", blockSize);
	}

byte:	dynamic	(c: char) =
	{
	Project.asmFd printf("	db	%d\n", unsignedByte(c));
	}

dwordInitializer:	dynamic	(val: * value, offset: addr_t) =
	{
	Project.asmFd printf("	dd	");
	asmSymbolName(val);
	if	(offset){
		Project.asmFd printf("+%u", offset);
		}
	Project.asmFd putc('\n');
	}

emitLiteral:		dynamic (ll: ref literalValue) =
	{
	cp:	ref char;
	len:	unsigned;
	i:	int;

	Project.asmFd printf("Lit#%x:	.literal\n", ll);
	for	(cp = ll->value, len = ll->length; len > 0; len--, cp++){
		Project.asmFd printf("	db	");
		if	(isprint(*cp) && *cp != '"'){
			Project.asmFd putc('"');
			for	(i = 0; i < 60; i++){
				Project.asmFd putc(*cp);
				cp++;
				len--;
				if	(len == 0 ||
					 !isprint(*cp))
					break;
				}
			Project.asmFd putc('"');
			}
		else
			Project.asmFd printf("%d", *cp);
		Project.asmFd putc('\n');
		}
	}

dataCodeOffset:	dynamic	(i: ref stmt_x) =
	{
	Project.asmFd printf("	dw	@%d\n", i->asmLabel);
	}

dataCodeLabel:	dynamic	(st: ref stmt_x) =
	{
	Project.asmFd printf("@C%d:", st->asmLabel);
	}
/*
recordLineNumber:	dynamic	(addr_t, lineno: unsigned) =
	{
	cp:	* char;

	if	(lineno == 0)
		return;
	cp = InputFile fetchLine(lineno - 1, 0);
	if	(cp == 0)
		return;
	Project.asmFd printf(";	");
	for	(; *cp != '\n' && *cp != TC_EOF; cp++)
		Project.asmFd putc(*cp);
	Project.asmFd putc('\n');
	}
 */
generateLabel:	dynamic	(s: ref stmt_x) =
	{
	Project.asmFd printf("@%d:\n", s->asmLabel);
	}

generateJump:	dynamic	(jc: jumpCondition, s: ref stmt_x) =
	{
	jumpInstructions:	static	[] * char = [
			0,		/* JC_NOOP */
			"jmp",		/* JC_JUMP */
			"jl",		/* JC_LT */
			"jg",		/* JC_GT */
			"jb",		/* JC_ULT */
			"ja",		/* JC_UGT */
			"jle",		/* JC_LE */
			"jge",		/* JC_GE */
			"jbe",		/* JC_ULE */
			"jae",		/* JC_UGE */
			"je",		/* JC_EQ */
			"jne",		/* JC_NE */
			"jc",		/* JC_CARRY */
			"jnc",		/* JC_NOCARRY */
			"jo",		/* JC_OVERFLOW */
			"jno",		/* JC_NOOVERFLOW */
			"js",		/* JC_SIGN */
			"jns",		/* JC_NOSIGN */
			"jp",		/* JC_PARITY */
			"jnp",		/* JC_NOPARITY */
			"loopz",	/* JC_LOOPZ */
			"loopnz",	/* JC_LOOPNZ */
			"jcxz",		/* JC_CXZ */
			"loop"		/* JC_LOOP */
			];

	if	(jc != JC_NOOP)
		Project.asmFd printf("	%s	@%d\n", 
						jumpInstructions[jc], s->asmLabel);
	}

generateExStore:	dynamic	(v: ref variable, st: ref stmt_x) =
	{
	Project.asmFd printf("	mov	dword ptr [ebp%d], offset @%d\n", 
				v->offset + ExceptFrameAddrOffset, 
				st->asmLabel);
	}

jumpToTable:	dynamic	(r: regNum, st: ref stmt_x) =
	{
	Project.asmFd printf("	jmp	word ptr cs:@C%d[%s]\n", st->asmLabel,
					registerName(r, IT_LONG));
	}

loadDS:	dynamic	(reg: regNum) =
	{
	cp:	* char;

	cp = registerName(reg, IT_WORD);
	Project.asmFd printf(	"	mov	%s,ss\n"
			"	mov	ds,%s\n"
			"	mov	es,%s\n"
			"	mov	fs,%s\n"
			"	mov	gs,%s\n", cp, cp, cp, cp, cp);
	}

encodeInstruction:	dynamic	(op: int) =
	{
	i:	int;
	j:	int;
	q:	* instInfo;

		/* Now output the instruction */

	q = &InstInfo[op];
	Project.asmFd printf("	%s	", q->mnemonic);
	switch	(op){
	case	I386_RET:
		if	(RightOpnd.address_mode)
			Project.asmFd printf("%u", RightOpnd.offset);
		break;

	case	I386_WDOFF:
	case	I386_WDSEG:
	case	I386_DD:
		disp(&LeftOpnd, IT_DONT_CARE);
		break;

	case	I386_FLSTi:
	case	I386_FFREE:
		Project.asmFd printf("st(%u)", LeftOpnd.base_register);
		break;

	case	I386_ENTER:
		Project.asmFd printf("%u,0", RightOpnd.offset);
		break;

	case	I386_INTRPT:
		Project.asmFd printf("%u", LeftOpnd.offset);
		break;

	case	I386_MULC:
	case	I386_DIVC:
	case	I386_DIVI:
	case	I386_DIVL:
	case	I386_UDIVI:
	case	I386_UDIVL:
		disp(&RightOpnd, q->optype);
		break;

	case	I386_CALL:
		disp(&LeftOpnd, IT_DONT_CARE);
		break;

	case	I386_CALLF:
		Project.asmFd printf("%u:0", LeftOpnd.offset);
		break;

	default:
		disp(&LeftOpnd, q->optype);
		if	(RightOpnd.address_mode){
			Project.asmFd putc(',');

			/* This is a hack to force the register portion of
			   a shift to be a byte register.  This will make
			   a shift be by CL rather than by CX on word shifts.
			   Same applies to byte output.
			 */

			if	(RightOpnd.address_mode == AM_ADDRESS)
				i = IT_DONT_CARE;
			else
				i = q->optype;
			switch	(op){
			case	I386_INC:
				i = IT_WORD;
				break;

			case	I386_MOVSXCL:
			case	I386_MOVSXCI:
			case	I386_MOVZXCL:
			case	I386_MOVZXCI:
				i = IT_BYTE;
				break;

			case	I386_MOVSXIL:
			case	I386_MOVZXIL:
				i = IT_WORD;
				}
			disp(&RightOpnd, i);
			}
		}
	Project.asmFd putc('\n');
	}

	};

disp:	(o: * operand, otype: int) =
	{
	any_stuff:	int;
	cp:		* char;

	any_stuff = 0;
	switch	(o->address_mode){
	case	AM_REG:
		Project.asmFd printf(registerName(o->base_register, otype));
		break;

	case	AM_ICON:
		Project.asmFd printf("%d", o->offset);
/*
		if	(otype == IT_BYTE){
			assert(signed(o->offset) <= 255 &&
				 signed(o->offset) >= -128);
			}
 */
		break;

	case	AM_OFFSET:
		Project.asmFd printf("offset ");
		if	(o->val){
			asmSymbolName(o->val);
			any_stuff = 1;
			}
		if	(o->offset){
			if	(any_stuff && o->offset)
				Project.asmFd putc('+');
			Project.asmFd printf("%u", o->offset);
			}
		break;

	case	AM_DYNAMIC:
/*
		if	(o->segment_override != nullReg){
			Project.asmFd printf(registerName(o->segment_override, IT_WORD));
			Project.asmFd putc(':');
			}
 */
		Project.asmFd printf("[%s+%u]", 
				registerName(o->base_register, IT_LONG), 
				o->offset);
		break;

	case	AM_ADDRESS:
		switch	(otype){
		case	IT_BYTE:
			Project.asmFd printf("byte ptr ");
			break;

		case	IT_DBL:
			Project.asmFd printf("qword ptr ");
			break;

		case	IT_LDBL:
			Project.asmFd printf("tbyte ptr ");
			break;

		case	IT_FLT:
		case	IT_LONG:
			Project.asmFd printf("dword ptr ");
			break;

		case	IT_WORD:
			Project.asmFd printf("word ptr ");
			}
		if	(o->segment_override != nullReg){
			Project.asmFd printf(registerName(o->segment_override, IT_WORD));
			Project.asmFd putc(':');
			}
		if	(o->val){
			asmSymbolName(o->val);
			any_stuff = 1;
			}
		else if	(o->base_register == nullReg &&
			 o->index_register == nullReg){
			Project.asmFd printf("[%u]", o->offset);
			break;
			}
		if	(o->base_register != nullReg ||
			 o->index_register != nullReg){
			Project.asmFd putc('[');
			any_stuff = 0;
			if	(o->base_register != nullReg){
				Project.asmFd printf(
					registerName(o->base_register, IT_LONG));
				any_stuff = 1;
				}
			if	(o->index_register != nullReg){
				if	(any_stuff)
					Project.asmFd putc('+');
				Project.asmFd printf(
					registerName(o->index_register, IT_LONG));
				if	(o->scale_factor){
					Project.asmFd printf("*%u", 
							1 << o->scale_factor);
					}
				any_stuff = 1;
				}
			if	(o->offset){
				if	(any_stuff && o->offset > 0)
					Project.asmFd putc('+');
				Project.asmFd printf("%d", o->offset);
				}
			Project.asmFd putc(']');
			}
		else if	(o->offset){
			if	(any_stuff)
				Project.asmFd putc('+');
			Project.asmFd printf("%u", o->offset);
			}
		}
	}

regdef:	type	{
	public:

	name:		ref char;
	regId:		regNum;
	typedef:	instTypes;
	debugval:	char;
	};

Regdef:	[32] regdef = [
		[ "_EAX",	EAX,	IT_LONG,	0x00 ],
		[ "_EDX",	EDX,	IT_LONG,	0x02 ],
		[ "_EBX",	EBX,	IT_LONG,	0x03 ],
		[ "_ECX",	ECX,	IT_LONG,	0x01 ],
		[ "_ESI",	ESI,	IT_LONG,	0x06 ],
		[ "_EDI",	EDI,	IT_LONG,	0x07 ],
		[ "_EBP",	EBP,	IT_LONG,	0x05 ],
		[ "_ESP",	ESP,	IT_LONG,	0x04 ],

		[ "_AX",	AX,	IT_WORD,	0x00 ],
		[ "_DX",	DX,	IT_WORD,	0x02 ],
		[ "_BX",	BX,	IT_WORD,	0x03 ],
		[ "_CX",	CX,	IT_WORD,	0x01 ],
		[ "_SI",	SI,	IT_WORD,	0x06 ],
		[ "_DI",	DI,	IT_WORD,	0x07 ],
		[ "_BP",	BP,	IT_WORD,	0x05 ],
		[ "_SP",	SP,	IT_WORD,	0x04 ],

		[ "_ES",	ES,	IT_WORD,	0x10 ],
		[ "_DS",	DS,	IT_WORD,	0x13 ],
		[ "_CS",	CS,	IT_WORD,	0x11 ],
		[ "_SS",	SS,	IT_WORD,	0x12 ],
		[ "_FS",	FS,	IT_WORD,	0x00 ],
		[ "_GS",	GS,	IT_WORD,	0x00 ],

		[ "_AL",	AL,	IT_BYTE,	0x08 ],
		[ "_BL",	BL,	IT_BYTE,	0x0b ],
		[ "_CL",	CL,	IT_BYTE,	0x09 ],
		[ "_DL",	DL,	IT_BYTE,	0x0a ],
		[ "_AH",	AH,	IT_BYTE,	0x0c ],
		[ "_BH",	BH,	IT_BYTE,	0x0f ],
		[ "_CH",	CH,	IT_BYTE,	0x0d ],
		[ "_DH",	DH,	IT_BYTE,	0x0e ],
		[ "_FLAGS",	nullReg,IT_WORD  ]
	];

registerName:	(rn: regNum, typedef: instTypes) [:] char =
	{
	r:		* regdef;
	a:	static	[4] char;

	for	(r = Regdef; r->name; r++)
		if	(r->regId == rn &&
			 r->typedef == typedef){
			a[3] = 0;
			a[0] = tolower(r->name[1]);
			a[1] = tolower(r->name[2]);
			a[2] = tolower(r->name[3]);
			return a[:stringLength(a)];
			}
	return "";
	}

asmSymbolName:	(val: ref value) =
	{
	if	(val->owner &&
		 val->owner->name)
		Project.asmFd printf(val->owner objectName());
	else if	(val == &LiteralValue)
		Project.asmFd printf(".literal");
	else
		Project.asmFd printf(".local");
	}
