/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	file;
//include	format;
//include	project;
//include	cdata, unit;

ErrUnfinished:		public	[] char = "Unfinished feature";

		// in parser.p

ErrOpen:		public	[] char = "Unable to open input file '%S'";
ErrDeclarationSyntax:	public	[] char = "Declaration syntax";
ErrIncludeSyntax:	public	[] char = "Include statement syntax";
ErrEnumerationSyntax:	public	[] char = "Enumeration syntax";
ErrSubtypeSyntax:	public	[] char = "Subtype declaration syntax";
ErrArraySyntax:		public	[] char = "Array bounds syntax";
ErrExpressionSyntax:	public	[] char = "Expression syntax";
ErrStrConstSyntax:	public	[] char = "Structure constant syntax";
ErrCaseSyntax:		public	[] char = "Case syntax";
ErrDotSyntax:		public	[] char = "Member reference (.) syntax";
ErrArrowSyntax:		public	[] char = "Member reference (->) syntax";
ErrSubscriptSyntax:	public	[] char = "Subscript syntax";
ErrCallSyntax:		public	[] char = "Function call syntax";
ErrMCallSyntax:		public	[] char = "Member function call syntax";
ErrOffsetofSyntax:	public	[] char = "Offsetof expression syntax";
ErrPublic:		public	[] char = "May not use public in a function";
ErrStructOnly:		public	[] char = "May only use '%s' in a structure";
ErrMisplacedToken:	public	[] char = "Misplaced keyword '%S'";
ErrRegister:		public	[] char = "Improper use of __reg__";
ErrInitDisallowed:	public	[] char = "Initializer is not allowed";
ErrBadType:		public	[] char = "Not an allowed type";
ErrBlockMissingRC:	public	[] char = "Block missing }";
ErrGotoLabel:		public	[] char = "Goto label must be an identifier";
ErrMissingSM:		public	[] char = "%s statement missing ;";
ErrMissingLP:		public	[] char = "%s statement missing (";
ErrMissingRP:		public	[] char = "%s statement missing )";
ErrMissingWhile:	public	[] char = "Do statement must have while";
ErrMissingExcept:	public	[] char = "Try statement must have except";
ErrStmtMissingSM:	public	[] char = "Statement missing ;";
ErrLabelSyntax:		public	[] char = "Label missing :";
ErrDefaultSyntax:	public	[] char = "Incorrect use of default";
ErrDuplicateDefault:	public	[] char = "Too many default cases";

		// in ptree.p

ErrRedecl:		public	[] char = "Redeclaration of '%S'";

		// in sbuffer.p

ErrStringNoTerm:	public	[] char = "Unterminated string or character constant";
ErrBadEscape:		public	[] char = "Unknown escape character %c (0x%x)";
WarnHexTooBig:		public	[] char = "Hexadecimal constant too large";
ErrNumLarge:		public	[] char = "Numeric constant too large";
ErrEofInComment:	public	[] char = "Unexpected end of file in comment";

		// in scanner.p

ErrBadChar:		public	[] char = "Incorrect character '%c' (0x%x)";
ErrBadNumber:		public	[] char = "Incorrect number format";
ErrTooManyDecimals:	public	[] char = "Too many decimal points";
ErrMisplacedDecimal:	public	[] char = "Misplaced decimal point";
ErrTooManyExponents:	public	[] char = "Too many exponents";
ErrNotOctalDigit:	public	[] char = "Not an octal digit";
ErrStringLong:		public	[] char = "String too long";
ErrCConstLong:		public	[] char = "Character constant too long";

		// in symtab.p

ErrUnitNotFound:	public	[] char = "Could not find unit '%S'";
ErrConstantExpr:	public	[] char = "Constant expression required";
ErrUndefSym:		public	[] char = "Undefined symbol '%S'";
ErrNotType:		public	[] char = "'%S' is not a type";
ErrCircular:		public	[] char = "Circular definition of '%S'";
ErrFloatWide:		public	[] char = "Floating type too large";
ErrIntWide:		public	[] char = "Integral type too large";
ErrBadInit:		public	[] char = "Incorrect initialization";
ErrFewInitParms:	public	[] char = "Too few expressions in initializer";
ErrFewParms:		public	[] char = "Too few arguments in call";
ErrFewParmsI:		public	[] char = "Too few arguments in call to '%S'";
ErrExtraParms:		public	[] char = "Too many arguments in call";
ErrExtraParmsI:		public	[] char = "Too many arguments in call to '%S'";
ErrBadParm1:		public	[] char = "Type mismatch in argument %d in call to '%S'";
ErrBadParm2:		public	[] char = "Type mismatch in argument '%S' in call to '%S'";
ErrBadParm3:		public	[] char = "Type mismatch in argument %d";
ErrBadParm4:		public	[] char = "Type mismatch in argument '%S'";
ErrNoDynamics:		public	[] char = "No dynamic functions allowed";
ErrFuncNotDynamic:	public	[] char = "Function %S must be dynamic";
ErrFuncNotGate:		public	[] char = "Function %S must be gate";
ErrBadBaseType:		public	[] char = "Cannot inherit from this type";
WarnWastedMember:	public	[] char = "Unnamed member has no effect";

		// in xtree.p

ErrBadSClass:		public	[] char = "Improper use of a symbol";
ErrVoidReturn:		public	[] char = "This function may not return with a value";
ErrVoidReply:		public	[] char = "This function may not reply with a value";
ErrBadStructOp:		public	[] char = "Incorrect structure operation";
ErrNotFunc:		public	[] char = "Call of non-function";
ErrBadFactory:		public	[] char = "'%S' is a factory function";
ErrNotFactory:		public	[] char = "'%S' is not a factory function";
ErrBadConvert:		public	[] char = "Incompatible type conversion";
ErrBadImplicit:		public	[] char = "Disallowed implicit conversion";
ErrBadCast:		public	[] char = "Cast must have an operand";
ErrArrayVararg:		public	[] char = "Variable argument may not have array type";
ErrBadFloatOp:		public	[] char = "Incorrect use of floating point";
ErrBadPointerOp:	public	[] char = "Incorrect use of pointer";
ErrBadArrayOp:		public	[] char = "Incorrect use of array";
ErrBadDescriptorOp:	public	[] char = "Incorrect use of array descriptor";
ErrBadFunctionOp:	public	[] char = "Incorrect use of function";
ErrBadRvalueArray:	public	[] char = "Array size not available for descriptor";
ErrBadIndirec:		public	[] char = "Invalid indirection";
ErrLvalueRequired:	public	[] char = "Lvalue required";
ErrSliceAssign:		public	[] char = "Incorrect types in slice assignment";
ErrSliceNeedsBound:	public	[] char = "Slice needs bound expression";
ErrPtrArrow:		public	[] char = "Pointer required on left side of ->";
ErrNoSize:		public	[] char = "Must have object type to compute size";
ErrTooManyInit:		public	[] char = "Too many initializers";
ErrSconstNeedsType:	public	[] char = "Structure constant needs a type";
ErrBadSubscript:	public	[] char = "Incorrect type in subscripting";
ErrBadOffsetof:		public	[] char = "Incorrect type in offsetof";
ErrBadPointerAdd:	public	[] char = "Invalid pointer addition";
ErrBadPointerSub:	public	[] char = "Invalid pointer subtraction";
ErrNoVarArgs:		public	[] char = "No varArgs type available";
ErrBadSelf:		public	[] char = "Misplaced use of 'self'";
ErrBadSuper:		public	[] char = "Misplaced use of 'super'";
ErrHasNoAddress:	public	[] char = "Member '%S' has no address";
WarnReturnNeeded:	public	[] char = "Function should return with a value";
WarnReplyNeeded:	public	[] char = "Function should reply with a value";
WarnConstRange:		public	[] char = "Constant out of range in comparison";
WarnAmbigAsg:		public	[] char = "Possibly incorrect assignment";
WarnNoEffect:		public	[] char = "Code has no effect";
WarnDivByZero:		public	[] char = "Division by zero";

		// in xcall.p

ErrBadMethodOp:		public	[] char = "Incorrect use of method function";

		// in xstmt.p

ErrBadCritical:		public	[] char = "Critical region must name a lock";
ErrDuplicateCase:	public	[] char = "Duplicate case";
ErrBadExceptVar:	public	[] char = "Exception variable is not correct";
ErrNotGate:		public	[] char = "Must be gate method to use reply";
ErrUndefReply:		public	[] char = "Gate function without reply capability";

		// in asmcode.p

ErrCreate:		public	[] char = "Unable to create output file '%S'";

		// in objcode.p

ErrInternal:		public	[] char = "Internal error: %S";
ErrEncoding:		public	[] char = "Illegal instruction encoding %d";

		// in alloctmp.p

ErrRegAlloc:		public	[] char = "Register allocation failure";

/*
Messages:	[] * char = [
	"Incorrect %S option: %S",		/* ErrBadOption */
//	"Out of memory",			/* ErrNoMemory */
//	"Too many error or warning messages",	/* ErrMaxMsgs */
//	"Irreducible expression tree",		/* ErrIrredTree */
	"Incorrect use of intrinsic %S",	/* ErrBadIntrinsic */
	"Incorrect external fixup: '%S'",	// ErrBadFixup

	"Incorrect .U file",			/* ErrBadUnitFile */
	"In memory changes disagree with disk copy",	// ErrChanged
	"Error writing output file",		/* ErrWrite */

	"File name too long",			/* ErrLongFilename */
	"Bit field too large",			/* ErrBitLarge */
	"Cannot modify a const object",		/* ErrModifyConst */
	"Must take address of memory location",	/* ErrAddr */
	"Array size too large",			/* ErrLargeArray */

	"'dynamic' must be function type",	/* ErrDynamicNotFunc */
	"Function %S must have a definition",	/* ErrDefinitionNeeded */

	"'%S' declared but never used",		/* WarnDeclNoUse */
	"Unreachable code",			/* WarnUnreachable */
	"Possible use of '%S' before definition",
						/* WarnUseBeforeDef */
	"Parameter '%S' is never used",		/* WarnArgNotUsed */
	"'%S' is assigned a value which is never used",
						/* WarnDefNotUsed */
	"Unit '%S' not actually used",		// WarnUsageNotUsed
	];
 */

NO_LINE:	public	const	fileOffset = ~0;

messageGenerator:	public	type	{
	public:

objectName:	dynamic	() [:] char =
	{
	return "";
	}

lineno:		dynamic	(fileOffset) int =
	{
	return 0;
	}

	};

messageContext:	public	type	{
	public:

	phase:		compilePhases;
	obj:		ref messageGenerator;
					// object associated with the
					// message
	offset:		fileOffset;	// offset in source file

clear:	() =
	{
	obj = 0;
	offset = 0;
	}

	};

CurrentContext:	public	messageContext;
ErrorCount:	public	int;

compilePhases:	public	type	byte = {
	PH_CARVE,
	PH_INTERFACE,
	PH_NO_MESSAGES = 255
	};

messageClasses:	type	char = {
	MSG_WARN,
	MSG_ERROR,
	MSG_FATAL
	};

fatal:	public	(s: [:] char, ...) =
	{
	ap:	varArgs;

	ap = ...;
	prefix("Fatal", MSG_FATAL, &CurrentContext, ap, s);
	ErrorCount++;
//	MsgTrap raise();
	exit(1);
	}

error:	public	(s: [:] char, ...) =
	{
	ap:	varArgs;

	ap = ...;
	prefix("Error", MSG_ERROR, &CurrentContext, ap, s);
	ErrorCount++;
	}

errorV:	public	(s: [:] char, ap: varArgs) =
	{
	prefix("Error", MSG_ERROR, &CurrentContext, ap, s);
	ErrorCount++;
	}

errorAt:	public	(m: ref messageContext, s: [:] char, ...) =
	{
	ap:	varArgs;

	ap = ...;
	prefix("Error", MSG_ERROR, m, ap, s);
	ErrorCount++;
	}

warn:	public	(s: [:] char, ...) =
	{
	ap:	varArgs;

	ap = ...;
	prefix("Warning", MSG_WARN, &CurrentContext, ap, s);
	}

prefix:	(m: [:] char, msgClass: messageClasses, mm: ref messageContext, 
					ap: varArgs, s: [:] char) =
	{
	if	(mm->phase == PH_NO_MESSAGES &&
		 msgClass != MSG_FATAL)
		return;
	printf(m);
	if	(mm->obj){
		printf(" %S", mm->obj objectName());
		if	(mm->offset != NO_LINE)
			printf(" %d", mm->obj lineno(mm->offset));
		}
	printf(": ");
	if	(|s &&
		 s[|s - 1] == 0)
		--|s;			// strip off the trailing null
	vprintf(s, ap);
	stdout putc('\n');
/*
	msgLen:		int;
	me:		messageEmitter;
	mBuf:		[256] char;

	me = [ &mBuf, sizeof mBuf - 1 ];
	me printf(m);
	if	(u)
		me printf(" %S", &u->name->spelling);
	if	(line)
		me printf(" %d", line);
	me printf(": ");
	me format(Messages[s], ap);
	if	(Funcname)
		me printf(" in function %S", Funcname);
	me putc(0);
	mBuf[sizeof mBuf - 1] = 0;
	Project.messages insertMessage(u, CurrentContext.phase, 
						line, msgClass, &mBuf);
 */
	}
/*
messageEmitter:	type	inherit emitter	{
	public:

buf:	* char;
rem:	int;

putc:	dynamic	(c: char) =
	{
	if	(rem){
		*buf = c;
		buf++;
		rem--;
		}
	}

write:	dynamic	(data: *, len: int) =
	{
	if	(rem){
		if	(rem < len)
			len = rem;
		memCopy(buf, data, len);
		buf += len;
		rem -= len;
		}
	}

printf:	(fmt: * char, ...) =
	{
	format(fmt, ...);
	}

};
 */
